/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.grok;

import io.krakens.grok.api.Grok;
import io.krakens.grok.api.GrokCompiler;
import io.krakens.grok.api.Match;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Exchange;
import org.apache.camel.component.grok.GrokPattern;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.DataFormatName;
import org.apache.camel.spi.annotations.Dataformat;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.ObjectHelper;

@Dataformat(value="grok")
public class GrokDataFormat
extends ServiceSupport
implements DataFormat,
DataFormatName,
CamelContextAware {
    private CamelContext camelContext;
    private Grok grok;
    private boolean allowMultipleMatchesPerLine = true;
    private Set<GrokPattern> customPatterns = new HashSet<GrokPattern>();
    private boolean flattened;
    private boolean namedOnly;
    private String pattern;

    public GrokDataFormat(String pattern) {
        this.pattern = pattern;
    }

    public GrokDataFormat() {
    }

    public GrokDataFormat registerPatternDefinition(GrokPattern pattern) {
        this.customPatterns.add(pattern);
        this.refreshGrok();
        return this;
    }

    public GrokDataFormat registerPatternDefinition(String name, String pattern) {
        return this.registerPatternDefinition(new GrokPattern(name, pattern));
    }

    public GrokDataFormat setPattern(String pattern) {
        this.pattern = pattern;
        return this;
    }

    public GrokDataFormat setFlattened(boolean flattened) {
        this.flattened = flattened;
        return this;
    }

    public GrokDataFormat setAllowMultipleMatchesPerLine(boolean allowMultipleMatchesPerLine) {
        this.allowMultipleMatchesPerLine = allowMultipleMatchesPerLine;
        return this;
    }

    public GrokDataFormat setNamedOnly(boolean namedOnly) {
        this.namedOnly = namedOnly;
        return this;
    }

    private void refreshGrok() {
        ObjectHelper.notNull(this.pattern, "pattern");
        GrokCompiler grokCompiler = GrokCompiler.newInstance();
        grokCompiler.registerDefaultPatterns();
        for (GrokPattern pattern : this.customPatterns) {
            grokCompiler.register(pattern.getName(), pattern.getPattern());
        }
        this.grok = grokCompiler.compile(this.pattern, this.namedOnly);
    }

    @Override
    public String getDataFormatName() {
        return "grok";
    }

    @Override
    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    @Override
    public void marshal(Exchange exchange, Object graph, OutputStream stream) throws Exception {
        throw new UnsupportedOperationException("GrokDataFormat does not support marshalling. Use unmarshal instead.");
    }

    @Override
    public Object unmarshal(Exchange exchange, InputStream stream) throws Exception {
        return this.unmarshal(exchange, (Object)stream);
    }

    @Override
    public Object unmarshal(Exchange exchange, Object body) throws Exception {
        ArrayList result = new ArrayList();
        Reader reader = null;
        if (body instanceof String) {
            String s = (String)body;
            reader = new StringReader(s);
        } else if (body instanceof Reader) {
            Reader r = (Reader)body;
            reader = r;
        } else {
            InputStream is = exchange.getContext().getTypeConverter().mandatoryConvertTo(InputStream.class, exchange, body);
            reader = new InputStreamReader(is, ExchangeHelper.getCharsetName(exchange));
        }
        try (Stream<String> lines = new BufferedReader(reader).lines();){
            lines.forEachOrdered(line -> this.processLine((String)line, result));
        }
        if (result.isEmpty()) {
            return null;
        }
        if (result.size() == 1) {
            return result.get(0);
        }
        return result;
    }

    private void processLine(String line, List<Map<String, Object>> resultList) {
        Match gm;
        CharBuffer charBuffer = CharBuffer.wrap(line);
        for (int start = 0; start < charBuffer.length() && Boolean.FALSE.equals((gm = this.grok.match(charBuffer.subSequence(start, charBuffer.length()))).isNull()); start += gm.getEnd()) {
            if (this.flattened) {
                resultList.add(gm.captureFlattened());
                continue;
            }
            resultList.add(gm.capture());
            if (this.allowMultipleMatchesPerLine) continue;
            break;
        }
    }

    @Override
    protected void doStart() throws Exception {
        this.customPatterns.addAll(this.getCamelContext().getRegistry().findByType(GrokPattern.class));
        this.refreshGrok();
    }

    @Override
    protected void doStop() throws Exception {
    }
}

