/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.grpc.server;

import io.grpc.stub.StreamObserver;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.component.grpc.GrpcConsumer;
import org.apache.camel.component.grpc.GrpcEndpoint;
import org.apache.camel.component.grpc.server.GrpcRequestAbstractStreamObserver;

public class GrpcRequestDelegationStreamObserver
extends GrpcRequestAbstractStreamObserver {
    public GrpcRequestDelegationStreamObserver(GrpcEndpoint endpoint, GrpcConsumer consumer, StreamObserver<Object> responseObserver, Map<String, Object> headers) {
        super(endpoint, consumer, responseObserver, headers);
        if (!endpoint.getConfiguration().isRouteControlledStreamObserver()) {
            throw new IllegalStateException("DELEGATION consumer strategy must be used with enabled routeControlledStreamObserver");
        }
    }

    @Override
    public void onNext(Object request) {
        Exchange exchange = this.endpoint.createExchange();
        exchange.getIn().setBody(request);
        exchange.getIn().setHeaders(this.headers);
        exchange.setProperty("grpcResponseObserver", (Object)this.responseObserver);
        this.consumer.process(exchange, doneSync -> {});
    }

    @Override
    public void onError(Throwable throwable) {
        Exchange exchange = this.endpoint.createExchange();
        exchange.getIn().setHeaders(this.headers);
        exchange.setProperty("grpcResponseObserver", (Object)this.responseObserver);
        this.consumer.onError(exchange, throwable);
    }

    @Override
    public void onCompleted() {
        Exchange exchange = this.endpoint.createExchange();
        exchange.getIn().setHeaders(this.headers);
        exchange.setProperty("grpcResponseObserver", (Object)this.responseObserver);
        this.consumer.onCompleted(exchange);
    }
}

