/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.camel.Exchange;
import org.apache.camel.spi.Configurer;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.spi.Metadata;

@Metadata(label="bean", description="The default header filtering strategy. Users can configure which headers is allowed or denied.", annotations={"interfaceName=org.apache.camel.spi.HeaderFilterStrategy"})
@Configurer(metadataOnly=true)
public class DefaultHeaderFilterStrategy
implements HeaderFilterStrategy {
    @Deprecated(since="3.9.0")
    public static final Pattern CAMEL_FILTER_PATTERN = Pattern.compile("(?i)(Camel|org\\.apache\\.camel)[.a-zA-z0-9]*");
    public static final String[] CAMEL_FILTER_STARTS_WITH = new String[]{"Camel", "camel", "org.apache.camel."};
    @Metadata(javaType="java.lang.String", description="Sets the in direction filter set. The in direction is referred to copying headers from an external message to a Camel message. Multiple patterns can be separated by comma")
    private Set<String> inFilter;
    private Pattern inFilterPattern;
    private String[] inFilterStartsWith;
    @Metadata(javaType="java.lang.String", description="Sets the out direction filter set. The out direction is referred to copying headers from a Camel message to an external message. Multiple patterns can be separated by comma")
    private Set<String> outFilter;
    private Pattern outFilterPattern;
    private String[] outFilterStartsWith;
    @Metadata(label="advanced", defaultValue="false", description="Whether header names should be converted to lower case before checking it with the filter Set. It does not affect filtering using regular expression pattern.")
    private boolean lowerCase;
    @Metadata(label="advanced", defaultValue="false", description="Whether to allow null values. By default a header is skipped if its value is null. Setting this to true will preserve the header.")
    private boolean allowNullValues;
    @Metadata(label="advanced", defaultValue="false", description="Sets the caseInsensitive property which is a boolean to determine whether header names should be case insensitive when checking it with the filter set. It does not affect filtering using regular expression pattern.")
    private boolean caseInsensitive;
    @Metadata(label="advanced", defaultValue="true", description="Sets what to do when a pattern or filter set is matched. When set to true, a match will filter out the header. This is the default value for backwards compatibility. When set to false, the pattern or filter will indicate that the header must be kept; anything not matched will be filtered (skipped).")
    private boolean filterOnMatch = true;

    @Override
    public boolean applyFilterToCamelHeaders(String headerName, Object headerValue, Exchange exchange) {
        return this.doFiltering(HeaderFilterStrategy.Direction.OUT, headerName, headerValue, exchange);
    }

    @Override
    public boolean applyFilterToExternalHeaders(String headerName, Object headerValue, Exchange exchange) {
        return this.doFiltering(HeaderFilterStrategy.Direction.IN, headerName, headerValue, exchange);
    }

    public Set<String> getOutFilter() {
        if (this.outFilter == null) {
            this.outFilter = new HashSet<String>();
        }
        return this.outFilter;
    }

    public void setOutFilter(Set<String> value) {
        this.outFilter = value;
    }

    public void setOutFilter(String value) {
        if (value != null) {
            this.outFilter = Set.of(value.split(","));
        }
    }

    public void setOutFilterStartsWith(String ... outFilterStartsWith) {
        this.outFilterStartsWith = outFilterStartsWith;
    }

    public String getOutFilterPattern() {
        return this.outFilterPattern == null ? null : this.outFilterPattern.pattern();
    }

    public void setOutFilterPattern(String value) {
        this.outFilterPattern = value == null ? null : Pattern.compile(value);
    }

    public void setOutFilterPattern(Pattern pattern) {
        this.outFilterPattern = pattern;
    }

    public Set<String> getInFilter() {
        if (this.inFilter == null) {
            this.inFilter = new HashSet<String>();
        }
        return this.inFilter;
    }

    public void setInFilter(Set<String> value) {
        this.inFilter = value;
    }

    public void setInFilter(String value) {
        if (value != null) {
            this.inFilter = Set.of(value.split(","));
        }
    }

    public void setInFilterStartsWith(String ... inFilterStartsWith) {
        this.inFilterStartsWith = inFilterStartsWith;
    }

    public String getInFilterPattern() {
        return this.inFilterPattern == null ? null : this.inFilterPattern.pattern();
    }

    public void setInFilterPattern(String value) {
        this.inFilterPattern = value == null ? null : Pattern.compile(value);
    }

    public void setInFilterPattern(Pattern pattern) {
        this.inFilterPattern = pattern;
    }

    public boolean isLowerCase() {
        return this.lowerCase;
    }

    public void setLowerCase(boolean value) {
        this.lowerCase = value;
    }

    public boolean isCaseInsensitive() {
        return this.caseInsensitive;
    }

    public void setCaseInsensitive(boolean caseInsensitive) {
        this.caseInsensitive = caseInsensitive;
    }

    public boolean isAllowNullValues() {
        return this.allowNullValues;
    }

    public void setAllowNullValues(boolean value) {
        this.allowNullValues = value;
    }

    public boolean isFilterOnMatch() {
        return this.filterOnMatch;
    }

    public void setFilterOnMatch(boolean filterOnMatch) {
        this.filterOnMatch = filterOnMatch;
    }

    protected boolean extendedFilter(HeaderFilterStrategy.Direction direction, String key, Object value, Exchange exchange) {
        return !this.filterOnMatch;
    }

    private boolean doFiltering(HeaderFilterStrategy.Direction direction, String headerName, Object headerValue, Exchange exchange) {
        if (headerName == null) {
            return true;
        }
        if (headerValue == null && !this.allowNullValues) {
            return true;
        }
        Pattern pattern = null;
        Set<String> filter = null;
        String[] startsWith = null;
        if (HeaderFilterStrategy.Direction.OUT == direction) {
            pattern = this.outFilterPattern;
            filter = this.outFilter;
            startsWith = this.outFilterStartsWith;
        } else if (HeaderFilterStrategy.Direction.IN == direction) {
            pattern = this.inFilterPattern;
            filter = this.inFilter;
            startsWith = this.inFilterStartsWith;
        }
        String lower = null;
        if (startsWith != null) {
            if (this.tryHeaderMatch(headerName, startsWith)) {
                return this.filterOnMatch;
            }
            if (this.lowerCase && this.tryHeaderMatch(lower = headerName.toLowerCase(), startsWith)) {
                return this.filterOnMatch;
            }
        }
        if (pattern != null && this.tryPattern(headerName, lower, pattern)) {
            return this.filterOnMatch;
        }
        if (filter != null && this.evalFilterMatch(headerName, lower, filter)) {
            return this.filterOnMatch;
        }
        return this.extendedFilter(direction, headerName, headerValue, exchange);
    }

    private boolean tryPattern(String headerName, String lower, Pattern pattern) {
        if (pattern == CAMEL_FILTER_PATTERN) {
            boolean match;
            boolean bl = match = headerName.startsWith("Camel") || headerName.startsWith("camel") || headerName.startsWith("org.apache.camel.");
            if (match) {
                return true;
            }
            if (this.lowerCase) {
                if (lower == null) {
                    lower = headerName.toLowerCase();
                }
                boolean bl2 = match = lower.startsWith("camel") || lower.startsWith("org.apache.camel.");
                if (match) {
                    return true;
                }
            }
        } else if (pattern.matcher(headerName).matches()) {
            return true;
        }
        return false;
    }

    private boolean tryHeaderMatch(String headerName, String[] startsWith) {
        for (String s2 : startsWith) {
            boolean match = headerName.startsWith(s2);
            if (!match) continue;
            return true;
        }
        return false;
    }

    private boolean evalFilterMatch(String headerName, String lower, Set<String> filter) {
        if (this.isCaseInsensitive()) {
            for (String filterString : filter) {
                if (!filterString.equalsIgnoreCase(headerName)) continue;
                return true;
            }
        } else if (this.lowerCase) {
            if (lower == null) {
                lower = headerName.toLowerCase();
            }
            if (filter.contains(lower)) {
                return true;
            }
        } else if (filter.contains(headerName)) {
            return true;
        }
        return false;
    }
}

