/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support.component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.spi.PropertyConfigurerGetter;
import org.apache.camel.support.DefaultAsyncProducer;
import org.apache.camel.support.component.AbstractApiEndpoint;
import org.apache.camel.support.component.ApiMethod;
import org.apache.camel.support.component.ApiMethodHelper;
import org.apache.camel.support.component.ApiMethodPropertiesHelper;
import org.apache.camel.support.component.PropertiesInterceptor;
import org.apache.camel.support.component.ResultInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractApiProducer<E extends Enum<E>, T>
extends DefaultAsyncProducer
implements PropertiesInterceptor,
ResultInterceptor {
    protected final AbstractApiEndpoint<E, T> endpoint;
    protected final ApiMethodPropertiesHelper<T> propertiesHelper;
    protected final ApiMethodHelper<?> methodHelper;
    private final transient Logger log = LoggerFactory.getLogger(this.getClass());

    public AbstractApiProducer(AbstractApiEndpoint<E, T> endpoint, ApiMethodPropertiesHelper<T> propertiesHelper) {
        super(endpoint);
        this.propertiesHelper = propertiesHelper;
        this.endpoint = endpoint;
        this.methodHelper = endpoint.getMethodHelper();
    }

    @Override
    public boolean process(final Exchange exchange, final AsyncCallback callback) {
        final HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.putAll(this.endpoint.getConfigurationProperties());
        properties.putAll(this.endpoint.getEndpointProperties());
        this.propertiesHelper.getExchangeProperties(exchange, properties);
        this.endpoint.interceptProperties(properties);
        this.interceptProperties(properties);
        final ApiMethod method = this.findMethod(exchange, properties);
        if (method == null) {
            callback.done(true);
            return true;
        }
        Runnable invocation = new Runnable(){

            @Override
            public void run() {
                try {
                    if (AbstractApiProducer.this.log.isDebugEnabled()) {
                        AbstractApiProducer.this.log.debug("Invoking operation {} with {}", (Object)method.getName(), properties.keySet());
                    }
                    Object result = AbstractApiProducer.this.doInvokeMethod(method, properties);
                    exchange.getMessage().setBody(result);
                    AbstractApiProducer.this.interceptResult(result, exchange);
                }
                catch (Exception t2) {
                    exchange.setException(RuntimeCamelException.wrapRuntimeCamelException(t2));
                }
                finally {
                    callback.done(false);
                }
            }
        };
        this.endpoint.getExecutorService().submit(invocation);
        return false;
    }

    @Override
    public void interceptProperties(Map<String, Object> properties) {
    }

    protected Object doInvokeMethod(ApiMethod method, Map<String, Object> properties) throws RuntimeCamelException {
        return ApiMethodHelper.invokeMethod(this.endpoint.getApiProxy(method, properties), method, properties);
    }

    @Override
    public final Object splitResult(Object result) {
        return result;
    }

    @Override
    public void interceptResult(Object methodResult, Exchange resultExchange) {
    }

    protected ApiMethod findMethod(Exchange exchange, Map<String, Object> properties) {
        ApiMethod method = null;
        List<ApiMethod> candidates = this.endpoint.getCandidates();
        if (this.processInBody(exchange, properties)) {
            Set<String> argNames = properties.keySet();
            List<ApiMethod> filteredMethods = this.methodHelper.filterMethods(candidates, ApiMethodHelper.MatchType.SUPER_SET, argNames);
            if (filteredMethods.isEmpty()) {
                Set<String> missing = this.methodHelper.getMissingProperties(this.endpoint.getMethodName(), argNames);
                throw new RuntimeCamelException(String.format("Missing properties for %s, need one or more from (%s args) %s", this.endpoint.getMethodName(), missing.size(), missing));
            }
            if (filteredMethods.size() == 1) {
                method = filteredMethods.get(0);
            } else {
                method = ApiMethodHelper.getHighestPriorityMethod(filteredMethods);
                this.log.warn("Calling highest priority operation {} from operations {}", (Object)method, filteredMethods);
            }
        }
        return method;
    }

    /*
     * Unable to fully structure code
     */
    private boolean processInBody(Exchange exchange, Map<String, Object> properties) {
        inBodyProperty = this.endpoint.getInBody();
        if (inBodyProperty != null) {
            value = exchange.getIn().getBody();
            if (value != null) {
                try {
                    configurer = this.endpoint.getComponent().getEndpointPropertyConfigurer();
                    if (configurer instanceof PropertyConfigurerGetter) {
                        getter = (PropertyConfigurerGetter)configurer;
                        type = getter.getOptionType(inBodyProperty, true);
                        if (type == null) ** GOTO lbl21
                        value = this.endpoint.getCamelContext().getTypeConverter().mandatoryConvertTo(type, exchange, value);
                    }
                    value = this.endpoint.getCamelContext().getTypeConverter().mandatoryConvertTo(this.endpoint.getConfiguration().getClass().getDeclaredField(inBodyProperty).getType(), exchange, value);
                }
                catch (Exception e) {
                    exchange.setException(new RuntimeCamelException(String.format("Error converting value %s to property %s: %s", new Object[]{value, inBodyProperty, e.getMessage()}), e));
                    return false;
                }
            } else if (!this.methodHelper.getNullableArguments().contains(inBodyProperty)) {
                exchange.setException(new NullPointerException(inBodyProperty));
                return false;
            }
lbl21:
            // 5 sources

            this.log.debug("Property [{}] has message body value {}", (Object)inBodyProperty, value);
            properties.put(inBodyProperty, value);
        }
        return true;
    }
}

