/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.grpc;

import com.google.auth.oauth2.GoogleCredentials;
import io.grpc.CallCredentials;
import io.grpc.ManagedChannel;
import io.grpc.auth.MoreCallCredentials;
import io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.NegotiationType;
import io.grpc.netty.NettyChannelBuilder;
import io.grpc.stub.StreamObserver;
import io.netty.handler.ssl.SslContextBuilder;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;
import org.apache.camel.component.grpc.GrpcAuthType;
import org.apache.camel.component.grpc.GrpcConfiguration;
import org.apache.camel.component.grpc.GrpcEndpoint;
import org.apache.camel.component.grpc.GrpcProducerStrategy;
import org.apache.camel.component.grpc.GrpcUtils;
import org.apache.camel.component.grpc.auth.jwt.JwtCallCredentials;
import org.apache.camel.component.grpc.auth.jwt.JwtHelper;
import org.apache.camel.component.grpc.client.GrpcExchangeForwarder;
import org.apache.camel.component.grpc.client.GrpcExchangeForwarderFactory;
import org.apache.camel.component.grpc.client.GrpcStreamObserverFactory;
import org.apache.camel.support.DefaultAsyncProducer;
import org.apache.camel.support.ResourceHelper;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrpcProducer
extends DefaultAsyncProducer {
    private static final Logger LOG = LoggerFactory.getLogger(GrpcProducer.class);
    protected final GrpcConfiguration configuration;
    protected final GrpcEndpoint endpoint;
    private ManagedChannel channel;
    private Object grpcStub;
    private GrpcExchangeForwarder forwarder;
    private GrpcStreamObserverFactory streamObserverFactory;

    public GrpcProducer(GrpcEndpoint endpoint, GrpcConfiguration configuration) {
        super(endpoint);
        this.endpoint = endpoint;
        this.configuration = configuration;
        if (configuration.getProducerStrategy() == GrpcProducerStrategy.STREAMING) {
            if (configuration.isSynchronous()) {
                throw new IllegalStateException("Cannot use synchronous processing in streaming mode");
            }
            if (configuration.getStreamRepliesTo() == null) {
                throw new IllegalStateException("The streamReplyTo property is mandatory when using the STREAMING mode");
            }
        }
        if (configuration.getAuthenticationType() == GrpcAuthType.GOOGLE && configuration.getNegotiationType() != NegotiationType.TLS) {
            throw new IllegalStateException("Google token-based authentication requires SSL/TLS negotiation mode");
        }
    }

    @Override
    public boolean process(Exchange exchange, AsyncCallback callback) {
        StreamObserver<Object> streamObserver = this.streamObserverFactory.getStreamObserver(exchange, callback);
        return this.forwarder.forward(exchange, streamObserver, callback);
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        this.forwarder.forward(exchange);
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        if (this.channel == null) {
            CallCredentials callCreds = null;
            this.initializeChannel();
            if (this.configuration.getAuthenticationType() == GrpcAuthType.GOOGLE) {
                ObjectHelper.notNull(this.configuration.getKeyCertChainResource(), "serviceAccountResource");
                GoogleCredentials creds = GoogleCredentials.fromStream(ResourceHelper.resolveResourceAsInputStream(this.endpoint.getCamelContext(), this.configuration.getServiceAccountResource()));
                callCreds = MoreCallCredentials.from(creds);
            } else if (this.configuration.getAuthenticationType() == GrpcAuthType.JWT) {
                ObjectHelper.notNull(this.configuration.getJwtSecret(), "jwtSecret");
                String jwtToken = JwtHelper.createJwtToken(this.configuration.getJwtAlgorithm(), this.configuration.getJwtSecret(), this.configuration.getJwtIssuer(), this.configuration.getJwtSubject());
                callCreds = new JwtCallCredentials(jwtToken);
            }
            if (this.configuration.isSynchronous()) {
                LOG.debug("Getting synchronous method stub from channel");
                this.grpcStub = GrpcUtils.constructGrpcBlockingStub(this.endpoint.getServicePackage(), this.endpoint.getServiceName(), this.channel, callCreds, this.endpoint.getCamelContext());
            } else {
                LOG.debug("Getting asynchronous method stub from channel");
                this.grpcStub = GrpcUtils.constructGrpcAsyncStub(this.endpoint.getServicePackage(), this.endpoint.getServiceName(), this.channel, callCreds, this.endpoint.getCamelContext());
            }
            this.forwarder = GrpcExchangeForwarderFactory.createExchangeForwarder(this.configuration, this.grpcStub);
            this.streamObserverFactory = new GrpcStreamObserverFactory(this.getEndpoint(), this.configuration);
            ServiceHelper.startService(this.streamObserverFactory);
        }
    }

    @Override
    protected void doStop() throws Exception {
        ServiceHelper.stopService(this.streamObserverFactory);
        if (this.channel != null) {
            this.forwarder.shutdown();
            this.forwarder = null;
            LOG.debug("Terminating channel to the remote gRPC server");
            this.channel.shutdown().shutdownNow();
            this.channel = null;
            this.grpcStub = null;
            this.streamObserverFactory = null;
        }
        super.doStop();
    }

    protected void initializeChannel() throws Exception {
        if (!ObjectHelper.isNotEmpty(this.configuration.getHost()) || this.configuration.getPort() <= 0) {
            throw new IllegalArgumentException("No connection properties (host or port) specified");
        }
        LOG.info("Creating channel to the remote gRPC server {}:{}", (Object)this.configuration.getHost(), (Object)this.configuration.getPort());
        NettyChannelBuilder channelBuilder = NettyChannelBuilder.forAddress(this.configuration.getHost(), this.configuration.getPort());
        if (this.configuration.getNegotiationType() == NegotiationType.TLS) {
            ObjectHelper.notNull(this.configuration.getKeyCertChainResource(), "keyCertChainResource");
            ObjectHelper.notNull(this.configuration.getKeyResource(), "keyResource");
            SslContextBuilder sslContextBuilder = GrpcSslContexts.forClient().keyManager(ResourceHelper.resolveResourceAsInputStream(this.endpoint.getCamelContext(), this.configuration.getKeyCertChainResource()), ResourceHelper.resolveResourceAsInputStream(this.endpoint.getCamelContext(), this.configuration.getKeyResource()), this.configuration.getKeyPassword());
            if (ObjectHelper.isNotEmpty(this.configuration.getTrustCertCollectionResource())) {
                sslContextBuilder = sslContextBuilder.trustManager(ResourceHelper.resolveResourceAsInputStream(this.endpoint.getCamelContext(), this.configuration.getTrustCertCollectionResource()));
            }
            channelBuilder = channelBuilder.sslContext(GrpcSslContexts.configure(sslContextBuilder).build());
        }
        this.channel = ((NettyChannelBuilder)((NettyChannelBuilder)channelBuilder.negotiationType(this.configuration.getNegotiationType()).flowControlWindow(this.configuration.getFlowControlWindow()).userAgent(this.configuration.getUserAgent())).maxInboundMessageSize(this.configuration.getMaxMessageSize()).intercept(this.configuration.getClientInterceptors())).build();
    }
}

