/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.guava.eventbus;

import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.guava.eventbus.GuavaEventBusConsumer;
import org.apache.camel.component.guava.eventbus.GuavaEventBusEndpoint;
import org.apache.camel.support.AsyncProcessorConverterHelper;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CamelEventHandler {
    protected final Logger log = LoggerFactory.getLogger(CamelEventHandler.class);
    protected final GuavaEventBusConsumer consumer;
    protected final GuavaEventBusEndpoint endpoint;
    protected final AsyncProcessor processor;

    public CamelEventHandler(GuavaEventBusConsumer consumer, GuavaEventBusEndpoint endpoint, Processor processor) {
        ObjectHelper.notNull(endpoint, "eventBusEndpoint");
        ObjectHelper.notNull(processor, "processor");
        this.consumer = consumer;
        this.endpoint = endpoint;
        this.processor = AsyncProcessorConverterHelper.convert(processor);
    }

    public void doEventReceived(Object event) {
        this.log.trace("Received event: {}", event);
        Exchange exchange = this.createExchange(event);
        this.log.debug("Processing event: {}", event);
        this.processor.process(exchange, new AsyncCallback(){

            @Override
            public void done(boolean doneSync) {
            }
        });
    }

    public Exchange createExchange(Object event) {
        Exchange exchange = this.consumer.createExchange(true);
        exchange.getIn().setBody(event);
        return exchange;
    }
}

