/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.task.map;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.MapRemoveAllCodec;
import com.hazelcast.client.impl.protocol.task.map.AbstractMapAllPartitionsMessageTask;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.namespace.NamespaceUtil;
import com.hazelcast.internal.nio.Connection;
import com.hazelcast.internal.util.ConcurrencyUtil;
import com.hazelcast.map.impl.EntryRemovingProcessor;
import com.hazelcast.map.impl.MapService;
import com.hazelcast.map.impl.operation.MapOperationProvider;
import com.hazelcast.query.PartitionPredicate;
import com.hazelcast.query.Predicate;
import com.hazelcast.security.permission.MapPermission;
import com.hazelcast.spi.impl.operationservice.OperationFactory;
import com.hazelcast.spi.impl.operationservice.impl.OperationServiceImpl;
import java.security.Permission;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public class MapRemoveAllMessageTask
extends AbstractMapAllPartitionsMessageTask<MapRemoveAllCodec.RequestParameters> {
    private Predicate predicate;

    public MapRemoveAllMessageTask(ClientMessage clientMessage, Node node, Connection connection) {
        super(clientMessage, node, connection);
        this.setNamespaceAware();
    }

    @Override
    protected void processMessage() {
        this.predicate = NamespaceUtil.callWithNamespace(this.nodeEngine, MapService.lookupNamespace(this.nodeEngine, ((MapRemoveAllCodec.RequestParameters)this.parameters).name), () -> (Predicate)this.serializationService.toObject(((MapRemoveAllCodec.RequestParameters)this.parameters).predicate));
        if (!(this.predicate instanceof PartitionPredicate)) {
            super.processMessage();
            return;
        }
        NamespaceUtil.runWithNamespace(this.nodeEngine, this.getUserCodeNamespace(), () -> {
            PartitionPredicate partitionPredicate = (PartitionPredicate)this.predicate;
            OperationFactory operationFactory = this.createOperationFactory();
            OperationServiceImpl operationService = this.nodeEngine.getOperationService();
            CompletableFuture future = operationService.invokeOnPartitionsAsync(this.getServiceName(), operationFactory, this.nodeEngine.getPartitionService().getPartitionIdSet(partitionPredicate.getPartitionKeys()));
            future.whenCompleteAsync((response, throwable) -> {
                if (throwable == null) {
                    this.sendResponse(this.reduce((Map<Integer, Object>)response));
                } else {
                    this.handleProcessingFailure((Throwable)throwable);
                }
            }, ConcurrencyUtil.CALLER_RUNS);
        });
    }

    @Override
    protected OperationFactory createOperationFactory() {
        MapOperationProvider operationProvider = this.getOperationProvider(((MapRemoveAllCodec.RequestParameters)this.parameters).name);
        Predicate effectivePredicate = this.predicate instanceof PartitionPredicate ? ((PartitionPredicate)this.predicate).getTarget() : this.predicate;
        return operationProvider.createPartitionWideEntryWithPredicateOperationFactory(((MapRemoveAllCodec.RequestParameters)this.parameters).name, EntryRemovingProcessor.ENTRY_REMOVING_PROCESSOR, effectivePredicate);
    }

    @Override
    protected Object reduce(Map<Integer, Object> map) {
        return null;
    }

    @Override
    protected MapRemoveAllCodec.RequestParameters decodeClientMessage(ClientMessage clientMessage) {
        return MapRemoveAllCodec.decodeRequest(clientMessage);
    }

    @Override
    protected ClientMessage encodeResponse(Object response) {
        return MapRemoveAllCodec.encodeResponse();
    }

    @Override
    public String getServiceName() {
        return "hz:impl:mapService";
    }

    @Override
    public Permission getRequiredPermission() {
        return new MapPermission(((MapRemoveAllCodec.RequestParameters)this.parameters).name, "remove");
    }

    @Override
    public String getDistributedObjectName() {
        return ((MapRemoveAllCodec.RequestParameters)this.parameters).name;
    }

    @Override
    public String getMethodName() {
        return "removeAll";
    }

    @Override
    public Object[] getParameters() {
        return new Object[]{((MapRemoveAllCodec.RequestParameters)this.parameters).predicate};
    }
}

