/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cp.internal.raft.impl.dto;

import com.hazelcast.cp.internal.raft.impl.RaftDataSerializerHook;
import com.hazelcast.cp.internal.raft.impl.RaftEndpoint;
import com.hazelcast.cp.internal.raft.impl.log.SnapshotEntry;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import java.io.EOFException;
import java.io.IOException;

public class InstallSnapshot
implements IdentifiedDataSerializable {
    private RaftEndpoint leader;
    private int term;
    private SnapshotEntry snapshot;
    private long queryRound;
    private long flowControlSequenceNumber;

    public InstallSnapshot() {
    }

    public InstallSnapshot(RaftEndpoint leader, int term, SnapshotEntry snapshot, long queryRound, long flowControlSequenceNumber) {
        this.leader = leader;
        this.term = term;
        this.snapshot = snapshot;
        this.queryRound = queryRound;
        this.flowControlSequenceNumber = flowControlSequenceNumber;
    }

    public RaftEndpoint leader() {
        return this.leader;
    }

    public int term() {
        return this.term;
    }

    public SnapshotEntry snapshot() {
        return this.snapshot;
    }

    public long queryRound() {
        return this.queryRound;
    }

    public long flowControlSequenceNumber() {
        return this.flowControlSequenceNumber;
    }

    @Override
    public int getFactoryId() {
        return RaftDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 10;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeObject(this.leader);
        out.writeInt(this.term);
        out.writeObject(this.snapshot);
        out.writeLong(this.queryRound);
        out.writeLong(this.flowControlSequenceNumber);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.leader = (RaftEndpoint)in.readObject();
        this.term = in.readInt();
        this.snapshot = (SnapshotEntry)in.readObject();
        this.queryRound = in.readLong();
        try {
            this.flowControlSequenceNumber = in.readLong();
        }
        catch (EOFException e) {
            this.flowControlSequenceNumber = -1L;
        }
    }

    public String toString() {
        return "InstallSnapshot{leader=" + this.leader + ", term=" + this.term + ", snapshot=" + this.snapshot + ", queryRound=" + this.queryRound + ", flowControlSequenceNumber=" + this.flowControlSequenceNumber + "}";
    }
}

