/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.query;

import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.internal.cluster.ClusterService;
import com.hazelcast.internal.iteration.IterationPointer;
import com.hazelcast.internal.namespace.NamespaceUtil;
import com.hazelcast.internal.partition.IPartitionService;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.internal.util.SortingUtil;
import com.hazelcast.internal.util.ToHeapDataConverter;
import com.hazelcast.logging.ILogger;
import com.hazelcast.map.impl.LazyMapEntry;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.map.impl.MapService;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.PartitionContainer;
import com.hazelcast.map.impl.iterator.MapEntriesWithCursor;
import com.hazelcast.map.impl.query.Result;
import com.hazelcast.map.impl.record.Record;
import com.hazelcast.map.impl.record.Records;
import com.hazelcast.map.impl.recordstore.RecordStore;
import com.hazelcast.query.Predicate;
import com.hazelcast.query.impl.QueryableEntriesSegment;
import com.hazelcast.query.impl.getters.Extractors;
import com.hazelcast.query.impl.predicates.PagingPredicateImpl;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.operationservice.OperationService;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;

public class PartitionScanRunner {
    protected final MapServiceContext mapServiceContext;
    protected final NodeEngine nodeEngine;
    protected final ILogger logger;
    protected final InternalSerializationService ss;
    protected final IPartitionService partitionService;
    protected final OperationService operationService;
    protected final ClusterService clusterService;

    public PartitionScanRunner(MapServiceContext mapServiceContext) {
        this.mapServiceContext = mapServiceContext;
        this.nodeEngine = mapServiceContext.getNodeEngine();
        this.ss = (InternalSerializationService)this.nodeEngine.getSerializationService();
        this.partitionService = this.nodeEngine.getPartitionService();
        this.logger = this.nodeEngine.getLogger(this.getClass());
        this.operationService = this.nodeEngine.getOperationService();
        this.clusterService = this.nodeEngine.getClusterService();
    }

    public void run(String mapName, final Predicate predicate, int partitionId, final Result result) {
        final PagingPredicateImpl pagingPredicate = predicate instanceof PagingPredicateImpl ? (PagingPredicateImpl)predicate : null;
        PartitionContainer partitionContainer = this.mapServiceContext.getPartitionContainer(partitionId);
        final RecordStore recordStore = partitionContainer.getRecordStore(mapName);
        MapContainer mapContainer = recordStore.getMapContainer();
        final boolean nativeMemory = recordStore.getInMemoryFormat() == InMemoryFormat.NATIVE;
        final boolean useCachedValues = this.isUseCachedDeserializedValuesEnabled(mapContainer, partitionId);
        final Extractors extractors = this.mapServiceContext.getExtractors(mapName);
        final Map.Entry<Integer, Map.Entry> nearestAnchorEntry = pagingPredicate == null ? null : pagingPredicate.getNearestAnchorEntry();
        recordStore.forEachAfterLoad(new BiConsumer<Data, Record>(){
            LazyMapEntry queryEntry = new LazyMapEntry();

            @Override
            public void accept(Data key, Record record) {
                Object value;
                Object object = value = useCachedValues ? Records.getValueOrCachedValue(record, PartitionScanRunner.this.ss) : record.getValue();
                if (value == null) {
                    return;
                }
                this.queryEntry.init(PartitionScanRunner.this.ss, key, value, extractors);
                this.queryEntry.setRecord(record);
                this.queryEntry.setMetadata(recordStore.getOrCreateMetadataStore().get(key));
                if (predicate.apply(this.queryEntry) && SortingUtil.compareAnchor(pagingPredicate, this.queryEntry, nearestAnchorEntry)) {
                    value = nativeMemory ? ToHeapDataConverter.toHeapData((Data)value) : value;
                    result.add(this.queryEntry.init(PartitionScanRunner.this.ss, ToHeapDataConverter.toHeapData(key), value, extractors));
                    this.queryEntry = new LazyMapEntry();
                }
            }
        }, false);
        result.orderAndLimit(pagingPredicate, nearestAnchorEntry);
    }

    public QueryableEntriesSegment run(String mapName, Predicate predicate, int partitionId, IterationPointer[] pointers, int fetchSize) {
        LinkedList resultList = new LinkedList();
        PartitionContainer partitionContainer = this.mapServiceContext.getPartitionContainer(partitionId);
        RecordStore recordStore = partitionContainer.getRecordStore(mapName);
        Extractors extractors = this.mapServiceContext.getExtractors(mapName);
        return NamespaceUtil.callWithNamespace(this.nodeEngine, MapService.lookupNamespace(this.nodeEngine, mapName), () -> {
            IterationPointer[] localPointers = pointers;
            while (resultList.size() < fetchSize && localPointers[localPointers.length - 1].getIndex() >= 0) {
                MapEntriesWithCursor cursor = recordStore.fetchEntries(localPointers, fetchSize - resultList.size());
                localPointers = cursor.getIterationPointers();
                List entries = cursor.getBatch();
                if (entries.isEmpty()) break;
                for (Map.Entry entry : entries) {
                    LazyMapEntry queryEntry = new LazyMapEntry(entry.getKey(), entry.getValue(), this.ss, extractors);
                    if (!predicate.apply(queryEntry)) continue;
                    resultList.add(queryEntry);
                }
            }
            return new QueryableEntriesSegment(resultList, localPointers);
        });
    }

    protected boolean isUseCachedDeserializedValuesEnabled(MapContainer mapContainer, int partitionId) {
        return mapContainer.isUseCachedDeserializedValuesEnabled(partitionId);
    }
}

