/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.query;

import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.core.MemberLeftException;
import com.hazelcast.internal.namespace.NamespaceUtil;
import com.hazelcast.internal.partition.IPartition;
import com.hazelcast.internal.util.ConcurrencyUtil;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.map.impl.MapDataSerializerHook;
import com.hazelcast.map.impl.MapService;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.query.Query;
import com.hazelcast.map.impl.query.QueryPartitionOperation;
import com.hazelcast.map.impl.query.QueryRunner;
import com.hazelcast.map.impl.query.Result;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.exception.TargetNotMemberException;
import com.hazelcast.spi.impl.InternalCompletableFuture;
import com.hazelcast.spi.impl.operationservice.AbstractNamedOperation;
import com.hazelcast.spi.impl.operationservice.CallStatus;
import com.hazelcast.spi.impl.operationservice.ExceptionAction;
import com.hazelcast.spi.impl.operationservice.Offload;
import com.hazelcast.spi.impl.operationservice.PartitionTaskFactory;
import com.hazelcast.spi.impl.operationservice.ReadonlyOperation;
import com.hazelcast.spi.impl.operationservice.impl.OperationServiceImpl;
import java.io.IOException;
import java.util.BitSet;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;

public class QueryOperation
extends AbstractNamedOperation
implements ReadonlyOperation {
    private Query query;
    private transient Result result;
    private transient CallStatus callStatus;

    public QueryOperation() {
    }

    public QueryOperation(Query query) {
        super(query.getMapName());
        this.query = query;
    }

    private InMemoryFormat getMapInMemoryFormat() {
        MapContainer mapContainer = this.getMapServiceContext().getMapContainer(this.name);
        return mapContainer.getMapConfig().getInMemoryFormat();
    }

    private MapServiceContext getMapServiceContext() {
        MapService mapService = (MapService)this.getService();
        return mapService.getMapServiceContext();
    }

    @Override
    public CallStatus call() throws Exception {
        this.callStatus = this.callInternal();
        return this.callStatus;
    }

    @Nonnull
    private CallStatus callInternal() {
        QueryRunner queryRunner = this.getMapServiceContext().getMapQueryRunner(this.getName());
        switch (this.getMapInMemoryFormat()) {
            case BINARY: 
            case OBJECT: {
                this.result = queryRunner.runIndexOrPartitionScanQueryOnOwnedPartitions(this.query);
                return CallStatus.RESPONSE;
            }
            case NATIVE: {
                Result indexResult;
                boolean useGlobalIndex = this.getMapServiceContext().getMapContainer(this.getName()).shouldUseGlobalIndex();
                if (useGlobalIndex && (indexResult = queryRunner.runIndexOrPartitionScanQueryOnOwnedPartitions(this.query, false)) != null) {
                    this.result = indexResult;
                    return CallStatus.RESPONSE;
                }
                BitSet queryPartitions = this.localPartitions();
                if (this.query.getPartitionIdSet() != null) {
                    queryPartitions.and(this.query.getPartitionIdSet().bitSetCopy());
                }
                if (queryPartitions.cardinality() == 0) {
                    this.result = queryRunner.populateEmptyResult(this.query, Collections.emptyList());
                    return CallStatus.RESPONSE;
                }
                return new OffloadedImpl(queryRunner, queryPartitions);
            }
        }
        throw new IllegalArgumentException("Unsupported in memory format");
    }

    private int partitionCount() {
        return this.getNodeEngine().getPartitionService().getPartitionCount();
    }

    private OperationServiceImpl getOperationService() {
        return (OperationServiceImpl)this.getNodeEngine().getOperationService();
    }

    private BitSet localPartitions() {
        BitSet partitions = new BitSet(this.partitionCount());
        for (IPartition partition : this.getNodeEngine().getPartitionService().getPartitions()) {
            if (!partition.isLocal()) continue;
            partitions.set(partition.getPartitionId());
        }
        return partitions;
    }

    @Override
    public ExceptionAction onInvocationException(Throwable throwable) {
        if (throwable instanceof MemberLeftException || throwable instanceof TargetNotMemberException) {
            return ExceptionAction.THROW_EXCEPTION;
        }
        return super.onInvocationException(throwable);
    }

    @Override
    public void onExecutionFailure(Throwable e) {
        if (this.callStatus != null && this.callStatus.ordinal() == 3) {
            this.sendResponse(e);
        }
    }

    @Override
    public Object getResponse() {
        return this.result;
    }

    @Override
    public int getFactoryId() {
        return MapDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 58;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeObject(this.query);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.query = (Query)in.readObject();
    }

    private final class OffloadedImpl
    extends Offload {
        private final BitSet localPartitions;
        private final QueryRunner queryRunner;

        private OffloadedImpl(QueryRunner queryRunner, BitSet localPartitions) {
            super(QueryOperation.this);
            this.localPartitions = localPartitions;
            this.queryRunner = queryRunner;
        }

        @Override
        public void start() {
            QueryFuture future = new QueryFuture(this.localPartitions.cardinality());
            QueryOperation.this.getOperationService().executeOnPartitions(new QueryTaskFactory(QueryOperation.this.query, this.queryRunner, future), this.localPartitions);
            future.whenCompleteAsync((BiConsumer)new ExecutionCallbackImpl(this.queryRunner, QueryOperation.this.query), ConcurrencyUtil.getDefaultAsyncExecutor());
        }
    }

    private static final class QueryLocalPartitionOperation
    extends QueryPartitionOperation {
        QueryLocalPartitionOperation() {
            throw new UnsupportedOperationException("should not be serialized");
        }

        QueryLocalPartitionOperation(Query query) {
            super(query);
        }

        @Override
        protected void runInternal() {
            IPartition partition = this.getNodeEngine().getPartitionService().getPartition(this.getPartitionId());
            if (!partition.isLocal()) {
                return;
            }
            super.runInternal();
        }
    }

    private class ExecutionCallbackImpl
    implements BiConsumer<AtomicReferenceArray<Result>, Throwable> {
        private final QueryRunner queryRunner;
        private final Query query;

        ExecutionCallbackImpl(QueryRunner queryRunner, Query query) {
            this.queryRunner = queryRunner;
            this.query = query;
        }

        @Override
        public void accept(AtomicReferenceArray<Result> response, Throwable throwable) {
            if (throwable == null) {
                try {
                    Result combinedResult = this.queryRunner.populateEmptyResult(this.query, Collections.emptyList());
                    this.populateResult(response, combinedResult);
                    QueryOperation.this.sendResponse(combinedResult);
                }
                catch (Throwable e) {
                    QueryOperation.this.sendResponse(e);
                    throw ExceptionUtil.rethrow(e);
                }
            } else {
                QueryOperation.this.sendResponse(throwable);
            }
        }

        private void populateResult(AtomicReferenceArray<Result> resultArray, Result combinedResult) {
            for (int k = 0; k < resultArray.length(); ++k) {
                Result partitionResult = resultArray.get(k);
                if (partitionResult == null) continue;
                combinedResult.combine(partitionResult);
            }
        }
    }

    private class QueryTask
    implements Runnable {
        private final int partitionId;
        private final Query query;
        private final QueryFuture future;
        private final QueryRunner queryRunner;

        QueryTask(Query query, QueryRunner queryRunner, int partitionId, QueryFuture future) {
            this.query = query;
            this.queryRunner = queryRunner;
            this.partitionId = partitionId;
            this.future = future;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            IPartition partition = QueryOperation.this.getNodeEngine().getPartitionService().getPartition(this.partitionId);
            if (!partition.isLocal()) {
                this.future.addResult(this.partitionId, null);
                return;
            }
            String mapName = this.query.getMapName();
            String namespace = MapService.lookupNamespace(QueryOperation.this.getNodeEngine(), mapName);
            NamespaceUtil.setupNamespace(QueryOperation.this.getNodeEngine(), namespace);
            try {
                this.queryRunner.beforeOperation(this.partitionId, mapName);
                Result result = this.queryRunner.runPartitionIndexOrPartitionScanQueryOnGivenOwnedPartition(this.query, this.partitionId);
                this.future.addResult(this.partitionId, result);
            }
            catch (Throwable ex) {
                this.future.completeExceptionally(ex);
            }
            finally {
                this.queryRunner.afterOperation(this.partitionId, mapName);
                NamespaceUtil.cleanupNamespace(QueryOperation.this.getNodeEngine(), namespace);
            }
        }
    }

    private class QueryTaskFactory
    implements PartitionTaskFactory {
        private final Query query;
        private final QueryFuture future;
        private final QueryRunner queryRunner;
        private final boolean tStore;

        QueryTaskFactory(Query query, QueryRunner queryRunner, QueryFuture future) {
            this.query = query;
            this.queryRunner = queryRunner;
            this.future = future;
            MapContainer mapContainer = QueryOperation.this.getMapServiceContext().getMapContainer(QueryOperation.this.name);
            this.tStore = mapContainer.getMapConfig().getTieredStoreConfig().isEnabled();
        }

        public Object create(int partitionId) {
            if (this.tStore) {
                QueryLocalPartitionOperation operation = new QueryLocalPartitionOperation(this.query);
                operation.setPartitionId(partitionId);
                operation.setNodeEngine(QueryOperation.this.getNodeEngine());
                operation.setOperationResponseHandler((op, response) -> {
                    if (response instanceof Throwable) {
                        this.future.completeExceptionally((Throwable)response);
                    } else {
                        this.future.addResult(op.getPartitionId(), (Result)response);
                    }
                });
                return operation;
            }
            return new QueryTask(this.query, this.queryRunner, partitionId, this.future);
        }
    }

    private class QueryFuture
    extends InternalCompletableFuture {
        private final AtomicReferenceArray<Result> resultArray;
        private final AtomicInteger remaining;

        QueryFuture(int localPartitionCount) {
            this.resultArray = new AtomicReferenceArray(QueryOperation.this.partitionCount());
            this.remaining = new AtomicInteger(localPartitionCount);
        }

        void addResult(int partitionId, Result result) {
            if (result != null) {
                this.resultArray.set(partitionId, result);
            }
            if (this.remaining.decrementAndGet() == 0) {
                this.complete(this.resultArray);
            }
        }
    }
}

