/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.azure;

import com.hazelcast.azure.AzureDiscoveryStrategy;
import com.hazelcast.azure.AzureProperties;
import com.hazelcast.config.properties.PropertyDefinition;
import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.spi.discovery.DiscoveryNode;
import com.hazelcast.spi.discovery.DiscoveryStrategy;
import com.hazelcast.spi.discovery.DiscoveryStrategyFactory;
import com.hazelcast.spi.utils.RestClient;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;

public class AzureDiscoveryStrategyFactory
implements DiscoveryStrategyFactory {
    private static final ILogger LOGGER = Logger.getLogger(AzureDiscoveryStrategyFactory.class);

    @Override
    public Class<? extends DiscoveryStrategy> getDiscoveryStrategyType() {
        return AzureDiscoveryStrategy.class;
    }

    @Override
    public DiscoveryStrategy newDiscoveryStrategy(DiscoveryNode node, ILogger logger, Map<String, Comparable> properties) {
        return new AzureDiscoveryStrategy(properties);
    }

    @Override
    public Collection<PropertyDefinition> getConfigurationProperties() {
        ArrayList<PropertyDefinition> result = new ArrayList<PropertyDefinition>();
        for (AzureProperties property : AzureProperties.values()) {
            result.add(property.getDefinition());
        }
        return result;
    }

    @Override
    public boolean isAutoDetectionApplicable() {
        return AzureDiscoveryStrategyFactory.azureDnsServerConfigured() && AzureDiscoveryStrategyFactory.azureInstanceMetadataAvailable();
    }

    private static boolean azureDnsServerConfigured() {
        return AzureDiscoveryStrategyFactory.readFileContents("/etc/resolv.conf").contains("internal.cloudapp.net");
    }

    static String readFileContents(String fileName) {
        String string;
        FileInputStream is = null;
        try {
            File file = new File(fileName);
            byte[] data = new byte[(int)file.length()];
            is = new FileInputStream(file);
            ((InputStream)is).read(data);
            string = new String(data, StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            try {
                throw new RuntimeException("Could not get " + fileName, e);
            }
            catch (Throwable throwable) {
                IOUtil.closeResource(is);
                throw throwable;
            }
        }
        IOUtil.closeResource(is);
        return string;
    }

    private static boolean azureInstanceMetadataAvailable() {
        return AzureDiscoveryStrategyFactory.isEndpointAvailable("http://169.254.169.254/metadata/instance?api-version=2020-06-01");
    }

    static boolean isEndpointAvailable(String url) {
        return !RestClient.create(url, 1).withRequestTimeoutSeconds(1).withRetries(1).withHeader("Metadata", "True").get().getBody().isEmpty();
    }

    @Override
    public DiscoveryStrategyFactory.DiscoveryStrategyLevel discoveryStrategyLevel() {
        return DiscoveryStrategyFactory.DiscoveryStrategyLevel.CLOUD_VM;
    }
}

