/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.nio.serialization.Serializer;
import java.util.Objects;
import javax.annotation.Nonnull;

public class SerializerConfig {
    private String className;
    private Serializer implementation;
    private Class typeClass;
    private String typeClassName;

    public SerializerConfig() {
    }

    public SerializerConfig(SerializerConfig serializerConfig) {
        this.className = serializerConfig.className;
        this.implementation = serializerConfig.implementation;
        this.typeClass = serializerConfig.typeClass;
        this.typeClassName = serializerConfig.typeClassName;
    }

    public String getClassName() {
        return this.className;
    }

    public SerializerConfig setClass(Class<? extends Serializer> clazz) {
        if (clazz != null) {
            this.setClassName(clazz.getName());
        }
        return this;
    }

    public SerializerConfig setClassName(@Nonnull String className) {
        this.className = Preconditions.checkHasText(className, "Serializer class name must contain text");
        this.implementation = null;
        return this;
    }

    public Serializer getImplementation() {
        return this.implementation;
    }

    public SerializerConfig setImplementation(@Nonnull Serializer implementation) {
        this.implementation = Preconditions.checkNotNull(implementation, "Serializer cannot be null");
        this.className = null;
        return this;
    }

    public Class getTypeClass() {
        return this.typeClass;
    }

    public SerializerConfig setTypeClass(@Nonnull Class typeClass) {
        this.typeClass = Preconditions.checkNotNull(typeClass, "Serializer type class cannot be null!");
        this.typeClassName = null;
        return this;
    }

    public String getTypeClassName() {
        return this.typeClassName;
    }

    public SerializerConfig setTypeClassName(@Nonnull String typeClassName) {
        this.typeClassName = Preconditions.checkHasText(typeClassName, "Serializer type class name must contain text");
        this.typeClass = null;
        return this;
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof SerializerConfig)) {
            return false;
        }
        SerializerConfig that = (SerializerConfig)o;
        return Objects.equals(this.implementation, that.implementation) && Objects.equals(this.className, that.className) && Objects.equals(this.typeClass, that.typeClass) && Objects.equals(this.typeClassName, that.typeClassName);
    }

    public final int hashCode() {
        return Objects.hash(this.typeClass, this.typeClassName, this.implementation, this.className);
    }

    public String toString() {
        return "SerializerConfig{className='" + this.className + "', implementation=" + this.implementation + ", typeClass=" + this.typeClass + ", typeClassName='" + this.typeClassName + "'}";
    }
}

