/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cp.internal.client;

import com.hazelcast.client.impl.ClientEndpoint;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.CPSubsystemAddMembershipListenerCodec;
import com.hazelcast.client.impl.protocol.task.AbstractAsyncMessageTask;
import com.hazelcast.cp.event.CPMembershipEvent;
import com.hazelcast.cp.event.CPMembershipListener;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.nio.Connection;
import com.hazelcast.internal.util.ConcurrencyUtil;
import com.hazelcast.spi.impl.eventservice.EventRegistration;
import com.hazelcast.spi.impl.eventservice.EventService;
import java.security.Permission;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;

public class AddCPMembershipListenerMessageTask
extends AbstractAsyncMessageTask<Boolean, UUID> {
    private static final String TOPIC = "membership";

    public AddCPMembershipListenerMessageTask(ClientMessage clientMessage, Node node, Connection connection) {
        super(clientMessage, node, connection);
    }

    @Override
    protected CompletableFuture<UUID> processInternal() {
        EventService eventService = this.clientEngine.getEventService();
        ClientCPMembershipListener listener = new ClientCPMembershipListener(this.endpoint);
        boolean local = (Boolean)this.parameters;
        if (local) {
            UUID id = eventService.registerLocalListener(this.getServiceName(), TOPIC, listener).getId();
            return CompletableFuture.completedFuture(id);
        }
        return eventService.registerListenerAsync(this.getServiceName(), TOPIC, listener).thenApplyAsync(EventRegistration::getId, ConcurrencyUtil.CALLER_RUNS);
    }

    @Override
    protected Object processResponseBeforeSending(UUID registrationId) {
        this.endpoint.addListenerDestroyAction(this.getServiceName(), TOPIC, registrationId);
        return registrationId;
    }

    @Override
    protected Boolean decodeClientMessage(ClientMessage clientMessage) {
        return CPSubsystemAddMembershipListenerCodec.decodeRequest(clientMessage);
    }

    @Override
    protected ClientMessage encodeResponse(Object response) {
        return CPSubsystemAddMembershipListenerCodec.encodeResponse((UUID)response);
    }

    @Override
    public String getServiceName() {
        return "hz:core:raft";
    }

    @Override
    public String getDistributedObjectName() {
        return null;
    }

    @Override
    public String getMethodName() {
        return "addCPMembershipListener";
    }

    @Override
    public Object[] getParameters() {
        return null;
    }

    @Override
    public Permission getRequiredPermission() {
        return null;
    }

    private class ClientCPMembershipListener
    implements CPMembershipListener {
        private final ClientEndpoint endpoint;

        ClientCPMembershipListener(ClientEndpoint endpoint) {
            this.endpoint = endpoint;
        }

        @Override
        public void memberAdded(CPMembershipEvent event) {
            this.sendEvent(event);
        }

        @Override
        public void memberRemoved(CPMembershipEvent event) {
            this.sendEvent(event);
        }

        private void sendEvent(CPMembershipEvent event) {
            if (!this.endpoint.isAlive()) {
                return;
            }
            ClientMessage message = CPSubsystemAddMembershipListenerCodec.encodeMembershipEventEvent(event.getMember(), event.getType().id());
            AddCPMembershipListenerMessageTask.this.sendClientMessage(message);
        }
    }
}

