/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.partition.impl;

import com.hazelcast.internal.partition.PartitionEventListener;
import com.hazelcast.partition.MigrationListener;
import com.hazelcast.partition.ReplicaMigrationEvent;

class MigrationListenerAdapter
implements PartitionEventListener<ReplicaMigrationEvent> {
    static final int MIGRATION_STARTED_PARTITION_ID = -1;
    static final int MIGRATION_FINISHED_PARTITION_ID = -2;
    private final MigrationListener migrationListener;

    MigrationListenerAdapter(MigrationListener migrationListener) {
        this.migrationListener = migrationListener;
    }

    @Override
    public void onEvent(ReplicaMigrationEvent event) {
        switch (event.getPartitionId()) {
            case -1: {
                this.migrationListener.migrationStarted(event.getMigrationState());
                break;
            }
            case -2: {
                this.migrationListener.migrationFinished(event.getMigrationState());
                break;
            }
            default: {
                if (event.isSuccess()) {
                    this.migrationListener.replicaMigrationCompleted(event);
                    break;
                }
                this.migrationListener.replicaMigrationFailed(event);
            }
        }
    }
}

