/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.operation.steps;

import com.hazelcast.internal.partition.InternalPartitionService;
import com.hazelcast.internal.partition.PartitionReplicaVersionManager;
import com.hazelcast.internal.services.ServiceNamespace;
import com.hazelcast.map.impl.operation.MapOperation;
import com.hazelcast.map.impl.operation.steps.IMapOpStep;
import com.hazelcast.map.impl.operation.steps.engine.State;
import com.hazelcast.map.impl.operation.steps.engine.Step;
import com.hazelcast.map.impl.operation.steps.engine.StepResponseUtil;
import com.hazelcast.map.impl.recordstore.RecordStore;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.impl.operationservice.BackupOperation;
import com.hazelcast.spi.impl.operationservice.impl.OperationRunnerImpl;
import com.hazelcast.spi.impl.operationservice.impl.OperationServiceImpl;
import java.util.function.Consumer;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum UtilSteps implements IMapOpStep
{
    FINAL_STEP{

        @Override
        public void runStep(State state) {
        }

        @Override
        public Step nextStep(State state) {
            return SEND_RESPONSE;
        }
    }
    ,
    SEND_RESPONSE{

        @Override
        public void runStep(State state) {
            Consumer backupOpAfterRun;
            StepResponseUtil.sendResponse(state);
            MapOperation operation = state.getOperation();
            operation.afterRunInternal();
            operation.disposeDeferredBlocks();
            if (operation instanceof BackupOperation && (backupOpAfterRun = state.getBackupOpAfterRun()) != null) {
                backupOpAfterRun.accept(operation);
            }
        }

        @Override
        public Step nextStep(State state) {
            return null;
        }
    }
    ,
    HANDLE_ERROR{

        @Override
        public void runStep(State state) {
            try {
                OperationRunnerImpl operationRunner = 3.getPartitionOperationRunner(state);
                operationRunner.handleOperationError(state.getOperation(), state.getThrowable());
            }
            finally {
                state.setThrowable(null);
                this.markReplicaAsSyncRequiredForBackupOps(state);
            }
        }

        private void markReplicaAsSyncRequiredForBackupOps(State state) {
            MapOperation operation = state.getOperation();
            if (!(operation instanceof BackupOperation)) {
                return;
            }
            PartitionReplicaVersionManager versionManager = this.getPartitionReplicaVersionManager(state);
            int partitionId = state.getPartitionId();
            ServiceNamespace namespace = versionManager.getServiceNamespace(operation);
            int replicaIndex = operation.getReplicaIndex();
            versionManager.markPartitionReplicaAsSyncRequired(partitionId, namespace, replicaIndex);
        }

        private PartitionReplicaVersionManager getPartitionReplicaVersionManager(State state) {
            NodeEngineImpl nodeEngine = (NodeEngineImpl)state.getRecordStore().getMapContainer().getMapServiceContext().getNodeEngine();
            InternalPartitionService partitionService = nodeEngine.getPartitionService();
            return partitionService.getPartitionReplicaVersionManager();
        }

        @Override
        public Step nextStep(State state) {
            return null;
        }
    }
    ,
    DIRECT_RUN_STEP{

        @Override
        public void runStep(State state) {
            RecordStore recordStore = state.getRecordStore();
            state.setSizeBefore(recordStore.size());
            MapOperation op = state.getOperation();
            op.runInternalDirect();
            state.setSizeAfter(recordStore.size());
        }

        @Override
        public Step nextStep(State state) {
            return FINAL_STEP;
        }
    };


    public static OperationRunnerImpl getPartitionOperationRunner(State state) {
        MapOperation operation = state.getOperation();
        return (OperationRunnerImpl)((OperationServiceImpl)operation.getNodeEngine().getOperationService()).getOperationExecutor().getPartitionOperationRunners()[state.getPartitionId()];
    }
}

