/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hazelcast.instance;

import com.hazelcast.cluster.MembershipEvent;
import com.hazelcast.cluster.MembershipListener;
import com.hazelcast.core.HazelcastInstance;
import java.net.InetSocketAddress;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.hazelcast.HazelcastComponentHelper;
import org.apache.camel.support.DefaultConsumer;
import org.apache.camel.support.DefaultEndpoint;

public class HazelcastInstanceConsumer
extends DefaultConsumer {
    public HazelcastInstanceConsumer(HazelcastInstance hazelcastInstance, DefaultEndpoint endpoint, Processor processor) {
        super(endpoint, processor);
        hazelcastInstance.getCluster().addMembershipListener(new HazelcastMembershipListener());
    }

    class HazelcastMembershipListener
    implements MembershipListener {
        HazelcastMembershipListener() {
        }

        @Override
        public void memberAdded(MembershipEvent event) {
            this.sendExchange(event, "added");
        }

        @Override
        public void memberRemoved(MembershipEvent event) {
            this.sendExchange(event, "removed");
        }

        private void sendExchange(MembershipEvent event, String action) {
            Exchange exchange = HazelcastInstanceConsumer.this.createExchange(false);
            HazelcastComponentHelper.setListenerHeaders(exchange, "instancelistener", action);
            InetSocketAddress adr = event.getMember().getSocketAddress();
            if (adr != null) {
                exchange.getIn().setHeader("CamelHazelcastInstanceHost", adr.getHostName());
                exchange.getIn().setHeader("CamelHazelcastInstancePort", adr.getPort());
            }
            try {
                HazelcastInstanceConsumer.this.getProcessor().process(exchange);
            }
            catch (Exception e) {
                exchange.setException(e);
            }
            if (exchange.getException() != null) {
                HazelcastInstanceConsumer.this.getExceptionHandler().handleException("Error processing exchange for Hazelcast consumer on your Hazelcast cluster.", exchange, exchange.getException());
            }
            HazelcastInstanceConsumer.this.releaseExchange(exchange, false);
        }
    }
}

