/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util;

import com.cedarsoftware.util.MapUtilities;
import com.cedarsoftware.util.StringUtilities;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;

public class CaseInsensitiveMap<K, V>
implements Map<K, V> {
    private final Map<K, V> map;

    public CaseInsensitiveMap() {
        this.map = new LinkedHashMap();
    }

    public CaseInsensitiveMap(int initialCapacity) {
        this.map = new LinkedHashMap(initialCapacity);
    }

    public CaseInsensitiveMap(int initialCapacity, float loadFactor) {
        this.map = new LinkedHashMap(initialCapacity, loadFactor);
    }

    public CaseInsensitiveMap(Map<K, V> source, Map<K, V> mapInstance) {
        this.map = this.copy(source, mapInstance);
    }

    public CaseInsensitiveMap(Map<K, V> m) {
        this.map = m instanceof TreeMap ? this.copy(m, new TreeMap()) : (m instanceof LinkedHashMap ? this.copy(m, new LinkedHashMap(m.size())) : (m instanceof ConcurrentSkipListMap ? this.copy(m, new ConcurrentSkipListMap()) : (m instanceof ConcurrentMap ? this.copy(m, new ConcurrentHashMap(m.size())) : (m instanceof WeakHashMap ? this.copy(m, new WeakHashMap(m.size())) : (m instanceof HashMap ? this.copy(m, new HashMap(m.size())) : this.copy(m, new LinkedHashMap(m.size())))))));
    }

    protected Map<K, V> copy(Map<K, V> source, Map<K, V> dest) {
        for (Map.Entry<K, V> entry : source.entrySet()) {
            K key = this.isCaseInsenstiveEntry(entry) ? ((CaseInsensitiveEntry)entry).getOriginalKey() : entry.getKey();
            Object altKey = key instanceof String ? new CaseInsensitiveString((String)key) : key;
            dest.put(altKey, entry.getValue());
        }
        return dest;
    }

    private boolean isCaseInsenstiveEntry(Object o) {
        return CaseInsensitiveEntry.class.isInstance(o);
    }

    @Override
    public V get(Object key) {
        if (key instanceof String) {
            String keyString = (String)key;
            return this.map.get(new CaseInsensitiveString(keyString));
        }
        return this.map.get(key);
    }

    @Override
    public boolean containsKey(Object key) {
        if (key instanceof String) {
            String keyString = (String)key;
            return this.map.containsKey(new CaseInsensitiveString(keyString));
        }
        return this.map.containsKey(key);
    }

    @Override
    public V put(K key, V value) {
        if (key instanceof String) {
            CaseInsensitiveString newKey = new CaseInsensitiveString((String)key);
            return this.map.put(newKey, value);
        }
        return this.map.put(key, value);
    }

    public Object putObject(Object key, Object value) {
        if (key instanceof String) {
            CaseInsensitiveString newKey = new CaseInsensitiveString((String)key);
            return this.map.put(newKey, value);
        }
        return this.map.put(key, value);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        if (MapUtilities.isEmpty(m)) {
            return;
        }
        for (Map.Entry<K, V> entry : m.entrySet()) {
            if (this.isCaseInsenstiveEntry(entry)) {
                CaseInsensitiveEntry ciEntry = (CaseInsensitiveEntry)entry;
                this.put(ciEntry.getOriginalKey(), entry.getValue());
                continue;
            }
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public V remove(Object key) {
        if (key instanceof String) {
            String keyString = (String)key;
            return this.map.remove(new CaseInsensitiveString(keyString));
        }
        return this.map.remove(key);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Map)) {
            return false;
        }
        Map that = (Map)other;
        if (that.size() != this.size()) {
            return false;
        }
        for (Map.Entry entry : that.entrySet()) {
            Object thatKey = entry.getKey();
            if (!this.containsKey(thatKey)) {
                return false;
            }
            Object thatValue = entry.getValue();
            V thisValue = this.get(thatKey);
            if (Objects.equals(thisValue, thatValue)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int h = 0;
        for (Map.Entry<K, V> entry : this.map.entrySet()) {
            K key = entry.getKey();
            int hKey = key == null ? 0 : key.hashCode();
            V value = entry.getValue();
            int hValue = value == null ? 0 : value.hashCode();
            h += hKey ^ hValue;
        }
        return h;
    }

    public String toString() {
        return this.map.toString();
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public Collection<V> values() {
        return this.map.values();
    }

    @Deprecated
    public Map minus(Object removeMe) {
        throw new UnsupportedOperationException("Unsupported operation [minus] or [-] between Maps.  Use removeAll() or retainAll() instead.");
    }

    @Deprecated
    public Map plus(Object right) {
        throw new UnsupportedOperationException("Unsupported operation [plus] or [+] between Maps.  Use putAll() instead.");
    }

    public Map<K, V> getWrappedMap() {
        return this.map;
    }

    @Override
    public Set<K> keySet() {
        return new AbstractSet<K>(){
            Iterator iter;

            @Override
            public boolean contains(Object o) {
                return CaseInsensitiveMap.this.containsKey(o);
            }

            @Override
            public boolean remove(Object o) {
                int size = CaseInsensitiveMap.this.map.size();
                CaseInsensitiveMap.this.remove(o);
                return CaseInsensitiveMap.this.map.size() != size;
            }

            @Override
            public boolean removeAll(Collection c) {
                int size = CaseInsensitiveMap.this.map.size();
                for (Object o : c) {
                    CaseInsensitiveMap.this.remove(o);
                }
                return CaseInsensitiveMap.this.map.size() != size;
            }

            @Override
            public boolean retainAll(Collection<?> c) {
                CaseInsensitiveMap other = new CaseInsensitiveMap();
                for (Object o : c) {
                    other.put(o, null);
                }
                int size = CaseInsensitiveMap.this.map.size();
                Iterator i = CaseInsensitiveMap.this.map.keySet().iterator();
                while (i.hasNext()) {
                    Object key = i.next();
                    if (other.containsKey(key)) continue;
                    i.remove();
                }
                return CaseInsensitiveMap.this.map.size() != size;
            }

            @Override
            public Object[] toArray() {
                Object[] items = new Object[this.size()];
                int i = 0;
                for (Object key : CaseInsensitiveMap.this.map.keySet()) {
                    items[i++] = key instanceof CaseInsensitiveString ? key.toString() : key;
                }
                return items;
            }

            @Override
            public int size() {
                return CaseInsensitiveMap.this.map.size();
            }

            @Override
            public void clear() {
                CaseInsensitiveMap.this.map.clear();
            }

            @Override
            public int hashCode() {
                int h = 0;
                for (Object key : CaseInsensitiveMap.this.map.keySet()) {
                    if (key == null) continue;
                    h += key.hashCode();
                }
                return h;
            }

            @Override
            public Iterator<K> iterator() {
                this.iter = CaseInsensitiveMap.this.map.keySet().iterator();
                return new Iterator<K>(){

                    @Override
                    public void remove() {
                        iter.remove();
                    }

                    @Override
                    public boolean hasNext() {
                        return iter.hasNext();
                    }

                    @Override
                    public K next() {
                        Object next = iter.next();
                        if (next instanceof CaseInsensitiveString) {
                            next = next.toString();
                        }
                        return next;
                    }
                };
            }
        };
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new AbstractSet<Map.Entry<K, V>>(){
            Iterator<Map.Entry<K, V>> iter;

            @Override
            public int size() {
                return CaseInsensitiveMap.this.map.size();
            }

            @Override
            public boolean isEmpty() {
                return CaseInsensitiveMap.this.map.isEmpty();
            }

            @Override
            public void clear() {
                CaseInsensitiveMap.this.map.clear();
            }

            @Override
            public boolean contains(Object o) {
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry that = (Map.Entry)o;
                if (CaseInsensitiveMap.this.containsKey(that.getKey())) {
                    Object value = CaseInsensitiveMap.this.get(that.getKey());
                    return Objects.equals(value, that.getValue());
                }
                return false;
            }

            @Override
            public boolean remove(Object o) {
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                int size = CaseInsensitiveMap.this.map.size();
                Map.Entry that = (Map.Entry)o;
                CaseInsensitiveMap.this.remove(that.getKey());
                return CaseInsensitiveMap.this.map.size() != size;
            }

            @Override
            public boolean removeAll(Collection c) {
                int size = CaseInsensitiveMap.this.map.size();
                for (Object o : c) {
                    if (!(o instanceof Map.Entry)) continue;
                    Map.Entry that = (Map.Entry)o;
                    CaseInsensitiveMap.this.remove(that.getKey());
                }
                return CaseInsensitiveMap.this.map.size() != size;
            }

            @Override
            public boolean retainAll(Collection c) {
                CaseInsensitiveMap other = new CaseInsensitiveMap();
                for (Object o : c) {
                    if (!(o instanceof Map.Entry)) continue;
                    other.put(((Map.Entry)o).getKey(), ((Map.Entry)o).getValue());
                }
                int origSize = this.size();
                Iterator i = CaseInsensitiveMap.this.map.entrySet().iterator();
                while (i.hasNext()) {
                    Map.Entry entry = i.next();
                    Object key = entry.getKey();
                    Object value = entry.getValue();
                    if (!other.containsKey(key)) {
                        i.remove();
                        continue;
                    }
                    Object v = other.get(key);
                    if (Objects.equals(v, value)) continue;
                    i.remove();
                }
                return this.size() != origSize;
            }

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                this.iter = CaseInsensitiveMap.this.map.entrySet().iterator();
                return new Iterator<Map.Entry<K, V>>(){

                    @Override
                    public boolean hasNext() {
                        return iter.hasNext();
                    }

                    @Override
                    public Map.Entry<K, V> next() {
                        return new CaseInsensitiveEntry(iter.next());
                    }

                    @Override
                    public void remove() {
                        iter.remove();
                    }
                };
            }
        };
    }

    public class CaseInsensitiveEntry
    extends AbstractMap.SimpleEntry<K, V> {
        public CaseInsensitiveEntry(Map.Entry<K, V> entry) {
            super(entry);
        }

        @Override
        public K getKey() {
            Object superKey = super.getKey();
            if (superKey instanceof CaseInsensitiveString) {
                return ((CaseInsensitiveString)superKey).original;
            }
            return superKey;
        }

        public K getOriginalKey() {
            return super.getKey();
        }

        @Override
        public V setValue(V value) {
            return CaseInsensitiveMap.this.map.put(super.getKey(), value);
        }
    }

    public static final class CaseInsensitiveString
    implements Comparable {
        private final String original;
        private final int hash;

        public CaseInsensitiveString(String string) {
            this.original = string;
            this.hash = StringUtilities.hashCodeIgnoreCase(string);
        }

        public String toString() {
            return this.original;
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (other instanceof CaseInsensitiveString) {
                return this.hash == ((CaseInsensitiveString)other).hash && this.original.equalsIgnoreCase(((CaseInsensitiveString)other).original);
            }
            if (other instanceof String) {
                return this.original.equalsIgnoreCase((String)other);
            }
            return false;
        }

        public int compareTo(Object o) {
            if (o instanceof CaseInsensitiveString) {
                CaseInsensitiveString other = (CaseInsensitiveString)o;
                return this.original.compareToIgnoreCase(other.original);
            }
            if (o instanceof String) {
                String other = (String)o;
                return this.original.compareToIgnoreCase(other);
            }
            return -1;
        }
    }
}

