/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.protocol.impl;

import ca.uhn.hl7v2.protocol.JMSDestination;
import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.TextMessage;

public class JMSQueueAdapter
implements JMSDestination {
    private QueueSession mySendingSession;
    private QueueSession myReceivingSession;
    private QueueSender mySender;
    private QueueReceiver myReceiver;
    private final QueueConnection myConnection;
    private final Queue myQueue;
    private boolean myIsConnected;

    public JMSQueueAdapter(QueueConnection theConnection, Queue theDestination) {
        this.myConnection = theConnection;
        this.myQueue = theDestination;
    }

    @Override
    public String getName() throws JMSException {
        return this.myQueue.getQueueName();
    }

    @Override
    public TextMessage createMessage() throws JMSException {
        return this.mySendingSession.createTextMessage();
    }

    @Override
    public void connect() throws JMSException {
        boolean transacted = false;
        int ackMode = 1;
        this.disconnect();
        this.mySendingSession = this.myConnection.createQueueSession(transacted, ackMode);
        this.mySender = this.mySendingSession.createSender(this.myQueue);
        this.myReceivingSession = this.myConnection.createQueueSession(transacted, ackMode);
        this.myReceiver = this.myReceivingSession.createReceiver(this.myQueue);
        this.myIsConnected = true;
    }

    @Override
    public void disconnect() throws JMSException {
        this.myIsConnected = false;
        if (this.mySendingSession != null) {
            this.mySendingSession.close();
        }
        if (this.myReceivingSession != null) {
            this.myReceivingSession.close();
        }
    }

    @Override
    public void send(Message theMessage) throws JMSException {
        this.mySender.send(theMessage);
    }

    @Override
    public Message receive() throws JMSException {
        return this.myReceiver.receive();
    }

    @Override
    public boolean isConnected() {
        return this.myIsConnected;
    }

    @Override
    public Connection getConnection() {
        return this.myConnection;
    }
}

