/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hl7;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.util.Terser;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.spi.annotations.Language;
import org.apache.camel.support.ExpressionAdapter;
import org.apache.camel.support.SingleInputTypedLanguageSupport;
import org.apache.camel.support.builder.ExpressionBuilder;
import org.apache.camel.util.ObjectHelper;

@Language(value="hl7terser")
public class Hl7TerserLanguage
extends SingleInputTypedLanguageSupport {
    public static Expression terser(String expression) {
        return Hl7TerserLanguage.terser(ExpressionBuilder.bodyExpression(), expression);
    }

    public static Expression terser(final Expression source, final String expression) {
        ObjectHelper.notNull(expression, "expression");
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                Message message = source.evaluate(exchange, Message.class);
                try {
                    return new Terser(message).get(expression.trim());
                }
                catch (HL7Exception e) {
                    throw RuntimeCamelException.wrapRuntimeCamelException(e);
                }
            }

            @Override
            public void init(CamelContext context) {
                source.init(context);
            }

            public String toString() {
                return "hl7terser(" + expression + ")";
            }
        };
    }

    @Override
    public Expression createExpression(Expression source, String expression, Object[] properties) {
        return Hl7TerserLanguage.terser(source, expression);
    }
}

