/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.http;

import org.apache.camel.component.http.HttpClientConfigurer;
import org.apache.camel.component.http.HttpCredentialsHelper;
import org.apache.camel.util.json.DeserializationException;
import org.apache.camel.util.json.JsonObject;
import org.apache.camel.util.json.Jsoner;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.entity.StringEntity;

public class OAuth2ClientConfigurer
implements HttpClientConfigurer {
    private final String clientId;
    private final String clientSecret;
    private final String tokenEndpoint;
    private final String scope;

    public OAuth2ClientConfigurer(String clientId, String clientSecret, String tokenEndpoint, String scope) {
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.tokenEndpoint = tokenEndpoint;
        this.scope = scope;
    }

    @Override
    public void configureHttpClient(HttpClientBuilder clientBuilder) {
        CloseableHttpClient httpClient = clientBuilder.build();
        clientBuilder.addRequestInterceptorFirst((request, entity, context) -> {
            Object url = this.tokenEndpoint;
            if (this.scope != null) {
                String sep = "?";
                if (((String)url).contains("?")) {
                    sep = "&";
                }
                url = (String)url + sep + "scope=" + this.scope;
            }
            HttpPost httpPost = new HttpPost((String)url);
            httpPost.addHeader("Authorization", HttpCredentialsHelper.generateBasicAuthHeader(this.clientId, this.clientSecret));
            httpPost.setEntity(new StringEntity("grant_type=client_credentials", ContentType.APPLICATION_FORM_URLENCODED));
            httpClient.execute((ClassicHttpRequest)httpPost, response -> {
                try {
                    String responseString = EntityUtils.toString(response.getEntity());
                    if (response.getCode() != 200) {
                        throw new HttpException("Received error response from token request with Status Code: " + response.getCode());
                    }
                    String accessToken = ((JsonObject)Jsoner.deserialize(responseString)).getString("access_token");
                    request.setHeader("Authorization", "Bearer " + accessToken);
                }
                catch (DeserializationException e) {
                    throw new HttpException("Something went wrong when reading token request response", e);
                }
                return null;
            });
        });
    }
}

