/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.http.base;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.http.base.HttpSendDynamicPostProcessor;
import org.apache.camel.http.base.HttpSendDynamicPreProcessor;
import org.apache.camel.spi.SendDynamicAware;
import org.apache.camel.support.ResourceHelper;
import org.apache.camel.support.component.SendDynamicAwareSupport;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.URISupport;
import org.apache.camel.util.UnsafeUriCharactersEncoder;

public class HttpSendDynamicAware
extends SendDynamicAwareSupport {
    private final Processor postProcessor = new HttpSendDynamicPostProcessor();

    @Override
    public boolean isLenientProperties() {
        return true;
    }

    @Override
    public SendDynamicAware.DynamicAwareEntry prepare(Exchange exchange, String uri, String originalUri) throws Exception {
        Map<String, Object> properties = this.endpointProperties(exchange, uri);
        Map<String, Object> lenient = this.endpointLenientProperties(exchange, uri);
        return new SendDynamicAware.DynamicAwareEntry(uri, originalUri, properties, lenient);
    }

    @Override
    public String resolveStaticUri(Exchange exchange, SendDynamicAware.DynamicAwareEntry entry) throws Exception {
        String[] hostAndPath = this.parseUri(entry);
        String host = hostAndPath[0];
        String path = hostAndPath[1];
        String auth = hostAndPath[2];
        if (path != null || !entry.getLenientProperties().isEmpty()) {
            Map<String, Object> params = entry.getProperties();
            for (String k : entry.getLenientProperties().keySet()) {
                params.remove(k);
            }
            if (path != null) {
                params.remove("httpUri");
                params.remove("httpURI");
                if ("netty-http".equals(this.getScheme())) {
                    params.remove("path");
                }
            }
            String url = auth != null && auth.contains("@") ? this.getScheme() + ":" + auth : this.getScheme() + ":" + host;
            if (!params.isEmpty()) {
                url = url + "?" + URISupport.createQueryString(params, false);
            }
            return url;
        }
        return null;
    }

    @Override
    public Processor createPreProcessor(Exchange exchange, SendDynamicAware.DynamicAwareEntry entry) throws Exception {
        String[] hostAndPath = this.parseUri(entry);
        String path = hostAndPath[1];
        String query = null;
        if (!entry.getLenientProperties().isEmpty()) {
            query = URISupport.createQueryString(new LinkedHashMap<String, Object>(entry.getLenientProperties()));
        }
        if ((path == null || path.isEmpty()) && ObjectHelper.isNotEmpty(exchange.getIn().getHeader("CamelHttpPath"))) {
            path = (String)exchange.getIn().getHeader("CamelHttpPath");
        }
        if (query == null && ObjectHelper.isNotEmpty(exchange.getIn().getHeader("CamelHttpQuery"))) {
            query = (String)exchange.getIn().getHeader("CamelHttpQuery");
        }
        if (path != null || query != null) {
            return new HttpSendDynamicPreProcessor(path, query);
        }
        return null;
    }

    @Override
    public Processor createPostProcessor(Exchange exchange, SendDynamicAware.DynamicAwareEntry entry) throws Exception {
        return this.postProcessor;
    }

    public String[] parseUri(SendDynamicAware.DynamicAwareEntry entry) {
        int colon;
        String scheme;
        Object u = entry.getUri();
        boolean httpComponent = "http".equals(this.getScheme()) || "https".equals(this.getScheme());
        boolean vertxHttpComponent = "vertx-http".equals(this.getScheme());
        if (!httpComponent && !vertxHttpComponent) {
            String prefix = this.getScheme() + "://";
            String prefix2 = this.getScheme() + ":";
            if (((String)u).startsWith(prefix)) {
                u = ((String)u).substring(prefix.length());
            } else if (((String)u).startsWith(prefix2)) {
                u = ((String)u).substring(prefix2.length());
            }
        }
        if (((String)u).contains("?")) {
            u = StringHelper.before((String)u, "?");
        }
        if (vertxHttpComponent && ((String)u).startsWith("vertx-http:") && (scheme = ResourceHelper.getScheme((String)(u = ((String)u).substring(11)))) == null) {
            u = "http://" + (String)u;
        }
        if ((colon = ((String)u).indexOf(58)) != -1) {
            String before = StringHelper.before((String)u, ":");
            String after = StringHelper.after((String)u, ":");
            if (!after.startsWith("//")) {
                u = before + "://" + after;
            }
        }
        try {
            String scheme2;
            u = UnsafeUriCharactersEncoder.encode((String)u);
            URI parse = new URI((String)u);
            Object host = parse.getHost();
            String path = parse.getPath();
            String authority = parse.getAuthority();
            int port = parse.getPort();
            if (port > 0 && port != 80 && port != 443) {
                host = (String)host + ":" + port;
            }
            if (path != null && path.length() > 1) {
                while (path.startsWith("//")) {
                    path = path.substring(1);
                }
            }
            if (!httpComponent && (scheme2 = parse.getScheme()) != null) {
                host = scheme2 + "://" + (String)host;
            }
            return new String[]{host, path, authority};
        }
        catch (URISyntaxException uRISyntaxException) {
            return new String[]{u, null, null};
        }
    }
}

