/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.core.auth;

import com.huaweicloud.sdk.core.HcClient;
import com.huaweicloud.sdk.core.auth.AKSKSignerFactory;
import com.huaweicloud.sdk.core.auth.AbstractCredentials;
import com.huaweicloud.sdk.core.auth.AuthCache;
import com.huaweicloud.sdk.core.auth.DerivedAKSKSigner;
import com.huaweicloud.sdk.core.auth.IAKSKSigner;
import com.huaweicloud.sdk.core.auth.ICredential;
import com.huaweicloud.sdk.core.exception.SdkException;
import com.huaweicloud.sdk.core.http.HttpClient;
import com.huaweicloud.sdk.core.http.HttpRequest;
import com.huaweicloud.sdk.core.internal.Iam;
import com.huaweicloud.sdk.core.internal.InnerIamMeta;
import com.huaweicloud.sdk.core.internal.model.CreateTokenWithIdTokenResponse;
import com.huaweicloud.sdk.core.internal.model.KeystoneListProjectsRequest;
import com.huaweicloud.sdk.core.internal.model.KeystoneListProjectsResponse;
import com.huaweicloud.sdk.core.internal.model.Project;
import com.huaweicloud.sdk.core.utils.StringUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicCredentials
extends AbstractCredentials<BasicCredentials> {
    private String projectId;

    public String getProjectId() {
        return this.projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    public BasicCredentials withProjectId(String projectId) {
        this.projectId = projectId;
        return this;
    }

    public Map<String, Object> getPathParams() {
        LinkedHashMap<String, Object> pathParam = new LinkedHashMap<String, Object>();
        if (!StringUtils.isEmpty(this.projectId)) {
            pathParam.put("project_id", this.projectId);
        }
        return pathParam;
    }

    @Override
    public CompletableFuture<ICredential> processAuthParams(HcClient hcClient, String regionId) {
        return CompletableFuture.supplyAsync(() -> {
            if (!StringUtils.isEmpty(this.getIdpId()) || !StringUtils.isEmpty(this.getIdTokenFile())) {
                if (StringUtils.isEmpty(this.getIdpId())) {
                    throw new SdkException("idpId is required when using idpId&idTokenFile");
                }
                if (StringUtils.isEmpty(this.getIdTokenFile())) {
                    throw new SdkException("idTokenFile is required when using idpId&idTokenFile");
                }
                if (StringUtils.isEmpty(this.projectId)) {
                    throw new SdkException("projectId is required when using idpId&idTokenFile");
                }
            }
            if (!StringUtils.isEmpty(this.projectId)) {
                return this;
            }
            String akWithName = this.getAk() + regionId;
            String cachedProjectId = AuthCache.getAuth(akWithName);
            if (!StringUtils.isEmpty(cachedProjectId)) {
                this.projectId = cachedProjectId;
                return this;
            }
            String iamEndpoint = this.getUsedIamEndpoint();
            HcClient inner = hcClient.overrideEndpoints(Collections.singletonList(iamEndpoint));
            Function<HttpRequest, Boolean> derivedPredicate = this.getDerivedPredicate();
            this.setDerivedPredicate(null);
            Logger logger = LoggerFactory.getLogger(hcClient.getClass());
            logger.info("project id of region '{}' not found in BasicCredentials, trying to get project id from IAM service automatically: {}", (Object)regionId, (Object)iamEndpoint);
            KeystoneListProjectsRequest request = new KeystoneListProjectsRequest().withName(regionId);
            KeystoneListProjectsResponse response = inner.syncInvokeHttp(request, InnerIamMeta.KEYSTONE_LIST_PROJECTS);
            if (Objects.isNull(response)) {
                throw new SdkException("Failed to get project id automatically, please confirm that the project exists in your account, or set project id manually: new BasicCredentials().withAk(ak).withSk(sk).withProjectId(projectId);");
            }
            List<Project> projects = response.getProjects();
            if (projects.size() != 1) {
                if (projects.size() < 1) {
                    throw new SdkException(String.format(Locale.ROOT, "Failed to get project id of region '%s' automatically, X-IAM-Trace-Id=%s.", regionId, response.getTraceId()) + " Confirm that the project exists in your account, or set project id manually: new BasicCredentials().withAk(ak).withSk(sk).withProjectId(projectId);");
                }
                String projectIds = projects.stream().map(Project::getId).collect(Collectors.joining(","));
                throw new SdkException(String.format(Locale.ROOT, "Multiple project ids found: [%s], X-IAM-Trace-Id=%s. ", projectIds, response.getTraceId()) + "Please select one when initializing the credentials: new BasicCredentials().withAk(ak).withSk(sk).withProjectId(projectId);");
            }
            this.projectId = projects.get(0).getId();
            logger.info("Success to get project id of region '{}': {}", (Object)regionId, (Object)this.projectId);
            AuthCache.putAuth(akWithName, this.projectId);
            this.setDerivedPredicate(derivedPredicate);
            return this;
        }, hcClient.getHttpConfig().getExecutorService());
    }

    @Override
    public CompletableFuture<HttpRequest> processAuthRequest(HttpRequest httpRequest, HttpClient httpClient) {
        return CompletableFuture.completedFuture(this.syncProcessAuthRequest(httpRequest, httpClient));
    }

    @Override
    public HttpRequest syncProcessAuthRequest(HttpRequest httpRequest, HttpClient httpClient) {
        Map<String, String> headers;
        HttpRequest.HttpRequestBuilder builder = httpRequest.builder().addAutoFilledPathParam(this.getPathParams());
        if (this.needUpdateAuthToken()) {
            this.updateAuthTokenByIdToken(httpClient);
        } else if (this.needUpdateSecurityToken()) {
            this.updateSecurityTokenFromMetadata();
        }
        if (!StringUtils.isEmpty(this.getProjectId())) {
            builder.addHeader("X-Project-Id", this.projectId);
        }
        if (!StringUtils.isEmpty(this.authToken)) {
            builder.addHeader("X-Auth-Token", this.authToken);
            return builder.build();
        }
        if (!StringUtils.isEmpty(this.getSecurityToken())) {
            builder.addHeader("X-Security-Token", this.getSecurityToken());
        }
        if (Objects.nonNull(httpRequest.getContentType()) && !httpRequest.getContentType().startsWith("application/json") && !httpRequest.getContentType().startsWith("application/bson")) {
            builder.addHeader("X-Sdk-Content-Sha256", "UNSIGNED-PAYLOAD");
        }
        if (this.isDerivedAuth(httpRequest)) {
            headers = DerivedAKSKSigner.getInstance().sign(builder.build(), this);
        } else {
            IAKSKSigner signer = AKSKSignerFactory.getSigner(httpRequest.getSigningAlgorithm());
            headers = signer.sign(builder.build(), this);
        }
        builder.addHeaders(headers);
        return builder.build();
    }

    @Override
    public void processDerivedAuthParams(String derivedAuthServiceName, String regionId) {
        if (this.derivedAuthServiceName == null) {
            this.derivedAuthServiceName = derivedAuthServiceName;
        }
        if (this.regionId == null) {
            this.regionId = regionId;
        }
    }

    @Override
    protected void updateAuthTokenByIdToken(HttpClient httpClient) {
        HttpRequest httpRequest = Iam.getProjectTokenWithIdTokenRequest(this.getUsedIamEndpoint(), this.getIdpId(), this.getIdToken(), this.projectId);
        CreateTokenWithIdTokenResponse response = Iam.createTokenWithIdToken(httpClient, httpRequest);
        this.authToken = response.getSubjectToken();
        try {
            String expiredTime = response.getToken().getExpiresAt().replace("000Z", "Z");
            this.expiredAt = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'").parse(expiredTime).getTime();
        }
        catch (ParseException e) {
            throw new SdkException(e);
        }
    }

    @Override
    public BasicCredentials deepClone() {
        BasicCredentials credentials = (BasicCredentials)((BasicCredentials)((BasicCredentials)((BasicCredentials)((BasicCredentials)((BasicCredentials)((BasicCredentials)new BasicCredentials().withProjectId(this.projectId).withAk(this.getAk())).withSk(this.getSk())).withIdpId(this.getIdpId())).withIdTokenFile(this.getIdTokenFile())).withDerivedPredicate(this.getDerivedPredicate())).withIamEndpoint(this.getIamEndpoint())).withSecurityToken(this.getSecurityToken());
        credentials.processDerivedAuthParams(this.derivedAuthServiceName, this.regionId);
        return credentials;
    }
}

