/*
 * Decompiled with CFR 0.152.
 */
package org.openeuler.sm4;

import java.security.AlgorithmParameterGeneratorSpi;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.IvParameterSpec;

public class SM4ParameterGenerator
extends AlgorithmParameterGeneratorSpi {
    private SecureRandom random;
    private AlgorithmParameterSpec param;
    private AlgorithmParameters parameters;

    @Override
    protected void engineInit(int size, SecureRandom random) {
        this.random = random;
    }

    @Override
    protected void engineInit(AlgorithmParameterSpec genParamSpec, SecureRandom random) throws InvalidAlgorithmParameterException {
        if (genParamSpec.getClass().equals(IvParameterSpec.class)) {
            this.param = genParamSpec;
        } else if (genParamSpec.getClass().equals(GCMParameterSpec.class)) {
            this.param = genParamSpec;
        } else {
            throw new InvalidAlgorithmParameterException();
        }
    }

    @Override
    protected AlgorithmParameters engineGenerateParameters() {
        try {
            this.parameters = AlgorithmParameters.getInstance("SM4");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        if (this.param == null) {
            byte[] iv = new byte[16];
            if (this.random == null) {
                this.random = new SecureRandom();
            }
            this.random.nextBytes(iv);
            this.param = new IvParameterSpec(iv);
            try {
                this.parameters.init(this.param);
            }
            catch (InvalidParameterSpecException e) {
                e.printStackTrace();
            }
        }
        try {
            this.parameters.init(this.param);
        }
        catch (InvalidParameterSpecException e) {
            e.printStackTrace();
        }
        return this.parameters;
    }
}

