/*
 * Decompiled with CFR 0.152.
 */
package org.openeuler.sm4.mode;

import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.ShortBufferException;
import org.openeuler.sm4.SM4BaseCipher;
import org.openeuler.sm4.SM4Util;

public class ECB
extends SM4BaseCipher {
    @Override
    public void engineInit(int opmode, Key key, SecureRandom random) throws InvalidKeyException {
        this.init(opmode, key);
        this.isInitialized = true;
    }

    @Override
    public void engineInit(int opmode, Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (params != null) {
            throw new InvalidAlgorithmParameterException("ECB mode cannot use an AlgorithmParameterSpec");
        }
        this.engineInit(opmode, key, random);
    }

    @Override
    public void engineInit(int opmode, Key key, AlgorithmParameters params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (params != null) {
            throw new InvalidAlgorithmParameterException("ECB mode cannot use an AlgorithmParameters");
        }
        this.engineInit(opmode, key, random);
    }

    @Override
    public byte[] engineUpdate(byte[] input, int inputOffset, int inputLen) {
        byte[] res;
        block9: {
            block8: {
                if (!this.isInitialized) {
                    throw new IllegalStateException("cipher uninitialized");
                }
                if (input == null || inputLen == 0) {
                    return null;
                }
                this.inputUpdate = input;
                this.inputLenUpdate = inputLen;
                this.inputOffsetUpdate = inputOffset;
                res = null;
                if (this.padding.getPadding().toUpperCase().equals("NOPADDING")) {
                    if (inputLen < 16) {
                        this.len = 0;
                        return null;
                    }
                    this.len = inputLen - inputLen % 16;
                } else {
                    if (inputLen <= 16) {
                        this.len = 0;
                        return null;
                    }
                    this.len = inputLen % 16 == 0 ? inputLen - 16 : inputLen - inputLen % 16;
                }
                res = new byte[this.len];
                if (this.opmode != 1) break block8;
                int i = inputOffset;
                while (i + 16 <= this.len + inputOffset) {
                    this.sm4.encrypt(this.rk, input, i, res, i - inputOffset);
                    i += 16;
                }
                break block9;
            }
            if (this.opmode != 2) break block9;
            int i = inputOffset;
            while (i + 16 <= this.len + inputOffset) {
                this.sm4.decrypt(this.rk, input, i, res, i - inputOffset);
                i += 16;
            }
        }
        return res;
    }

    @Override
    public int engineUpdate(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException {
        block9: {
            block8: {
                if (!this.isInitialized) {
                    throw new IllegalStateException("cipher uninitialized");
                }
                if (input == null || inputLen == 0) {
                    return 0;
                }
                this.inputUpdate = input;
                this.inputLenUpdate = inputLen;
                this.inputOffsetUpdate = inputOffset;
                if (this.padding.getPadding().toUpperCase().equals("NOPADDING")) {
                    if (inputLen < 16) {
                        this.len = 0;
                        return 0;
                    }
                    this.len = inputLen - inputLen % 16;
                } else {
                    if (inputLen <= 16) {
                        this.len = 0;
                        return 0;
                    }
                    this.len = inputLen % 16 == 0 ? inputLen - 16 : inputLen - inputLen % 16;
                }
                if (this.opmode != 1) break block8;
                int i = inputOffset;
                while (i + 16 <= this.len + inputOffset) {
                    this.sm4.encrypt(this.rk, input, i, output, outputOffset + i - inputOffset);
                    i += 16;
                }
                break block9;
            }
            if (this.opmode != 2) break block9;
            int i = inputOffset;
            while (i + 16 <= this.len + inputOffset) {
                this.sm4.decrypt(this.rk, input, i, output, outputOffset + i - inputOffset);
                i += 16;
            }
        }
        return this.len;
    }

    @Override
    public byte[] engineDoFinal(byte[] input, int inputOffset, int inputLen) throws IllegalBlockSizeException, BadPaddingException {
        if (!this.isInitialized) {
            throw new IllegalStateException("cipher uninitialized");
        }
        byte[] res = null;
        int restLen = this.inputLenUpdate - this.len;
        if (this.opmode == 1) {
            if (this.padding.getPadding().toUpperCase().equals("NOPADDING") && (this.inputLenUpdate - this.len + inputLen) % 16 != 0) {
                throw new IllegalBlockSizeException();
            }
            int length = this.engineGetOutputSize(this.inputLenUpdate - this.len + inputLen);
            res = new byte[length];
            if (restLen == 0) {
                this.encrypt(input, inputOffset, inputLen, res, 0);
            } else if (restLen == 16) {
                this.sm4.encrypt(this.rk, this.inputUpdate, this.inputOffsetUpdate + this.inputLenUpdate - 16, res, 0);
                this.encrypt(input, inputOffset, inputLen, res, 16);
            } else if (16 - restLen > inputLen) {
                byte[] block = new byte[inputLen + restLen];
                SM4Util.copyArray(this.inputUpdate, this.inputOffsetUpdate + this.len, restLen, block, 0);
                SM4Util.copyArray(input, inputOffset, inputLen, block, restLen);
                byte[] fill = this.padding.fill(block);
                this.sm4.encrypt(this.rk, fill, 0, res, res.length - 16);
            } else {
                byte[] block = new byte[16];
                SM4Util.copyArray(this.inputUpdate, this.inputOffsetUpdate + this.len, restLen, block, 0);
                SM4Util.copyArray(input, inputOffset, 16 - restLen, block, restLen);
                this.sm4.encrypt(this.rk, block, 0, res, 0);
                this.encrypt(input, inputOffset + 16 - restLen, inputLen - 16 + restLen, res, 16);
            }
        } else if (this.opmode == 2) {
            if ((inputLen + this.inputLenUpdate - this.len) % 16 != 0) {
                throw new IllegalBlockSizeException();
            }
            if (restLen == 0) {
                if (inputLen == 0) {
                    return res;
                }
                res = this.decryptLastBlock(input, inputOffset, inputLen, 0);
                this.decrypt(input, inputOffset, inputLen - 16, res, 0);
            } else if (restLen == 16) {
                if (inputLen == 0) {
                    res = this.decryptLastBlock(this.inputUpdate, this.inputOffsetUpdate + this.inputLenUpdate - 16, 16, 0);
                } else {
                    res = this.decryptLastBlock(input, inputOffset, inputLen, 16);
                    this.decrypt(this.inputUpdate, this.inputOffsetUpdate + this.len, 16, res, 0);
                    this.decrypt(input, inputOffset, inputLen - 16, res, 16);
                }
            } else {
                byte[] block = new byte[16];
                SM4Util.copyArray(this.inputUpdate, this.inputOffsetUpdate + this.len, restLen, block, 0);
                SM4Util.copyArray(input, inputOffset, 16 - restLen, block, restLen);
                if (inputLen == 16 - restLen) {
                    res = this.decryptLastBlock(block, 0, 16, 0);
                } else {
                    res = this.decryptLastBlock(input, inputOffset + 16 - restLen, inputLen - 16 + restLen, 16);
                    this.decrypt(block, 0, 16, res, 0);
                    this.decrypt(input, inputOffset + 16 - restLen, inputLen - 32 + restLen, res, 16);
                }
            }
        }
        this.reset();
        return res;
    }

    @Override
    public int engineDoFinal(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        if (!this.isInitialized) {
            throw new IllegalStateException("cipher uninitialized");
        }
        int need = 0;
        int restLen = this.inputLenUpdate - this.len;
        if (this.opmode == 1) {
            if (this.padding.getPadding().toUpperCase().equals("NOPADDING") && (this.inputLenUpdate - this.len + inputLen) % 16 != 0) {
                throw new IllegalBlockSizeException();
            }
            need = this.engineGetOutputSize(this.inputLenUpdate - this.len + inputLen);
            if (outputOffset + need > output.length) {
                throw new ShortBufferException();
            }
            if (restLen == 0) {
                this.encrypt(input, inputOffset, inputLen, output, outputOffset);
            } else if (restLen == 16) {
                this.sm4.encrypt(this.rk, this.inputUpdate, this.inputOffsetUpdate + this.inputLenUpdate - 16, output, outputOffset);
                this.encrypt(input, inputOffset, inputLen, output, outputOffset + 16);
            } else if (16 - restLen > inputLen) {
                byte[] block = new byte[inputLen + restLen];
                SM4Util.copyArray(this.inputUpdate, this.inputOffsetUpdate + this.len, restLen, block, 0);
                SM4Util.copyArray(input, inputOffset, inputLen, block, restLen);
                byte[] fill = this.padding.fill(block);
                this.sm4.encrypt(this.rk, fill, 0, output, outputOffset + need - 16);
            } else {
                byte[] block = new byte[16];
                SM4Util.copyArray(this.inputUpdate, this.inputOffsetUpdate + this.len, restLen, block, 0);
                SM4Util.copyArray(input, inputOffset, 16 - restLen, block, restLen);
                this.sm4.encrypt(this.rk, block, 0, output, outputOffset);
                this.encrypt(input, inputOffset + 16 - restLen, inputLen - 16 + restLen, output, outputOffset + 16);
            }
        } else if (this.opmode == 2) {
            if ((inputLen + this.inputLenUpdate - this.len) % 16 != 0) {
                throw new IllegalBlockSizeException();
            }
            if (restLen == 0) {
                if (inputLen == 0) {
                    return need;
                }
                need = this.decryptLastBlock(input, inputOffset, inputLen, 0, output, outputOffset);
                this.decrypt(input, inputOffset, inputLen - 16, output, outputOffset);
            } else if (restLen == 16) {
                if (inputLen == 0) {
                    need = this.decryptLastBlock(this.inputUpdate, this.inputOffsetUpdate + this.inputLenUpdate - 16, 16, 0, output, outputOffset);
                } else {
                    need = this.decryptLastBlock(input, inputOffset, inputLen, 16, output, outputOffset);
                    this.decrypt(this.inputUpdate, this.inputOffsetUpdate + this.len, 16, output, outputOffset);
                    this.decrypt(input, inputOffset, inputLen - 16, output, outputOffset + 16);
                }
            } else {
                byte[] block = new byte[16];
                SM4Util.copyArray(this.inputUpdate, this.inputOffsetUpdate + this.len, restLen, block, 0);
                SM4Util.copyArray(input, inputOffset, 16 - restLen, block, restLen);
                if (inputLen == 16 - restLen) {
                    need = this.decryptLastBlock(block, 0, 16, 0, output, outputOffset);
                } else {
                    need = this.decryptLastBlock(input, inputOffset + 16 - restLen, inputLen - 16 + restLen, 16, output, outputOffset);
                    this.decrypt(block, 0, 16, output, outputOffset);
                    this.decrypt(input, inputOffset + 16 - restLen, inputLen - 32 + restLen, output, outputOffset + 16);
                }
            }
        }
        this.reset();
        return need;
    }

    private void decrypt(byte[] input, int inputOffset, int inputLen, byte[] res, int offset) throws BadPaddingException {
        int i = inputOffset;
        while (i + 16 <= inputLen + inputOffset) {
            this.sm4.decrypt(this.rk, input, i, res, offset + i - inputOffset);
            i += 16;
        }
    }

    private byte[] decryptLastBlock(byte[] input, int inputOffset, int inputLen, int extra) throws BadPaddingException {
        byte[] res;
        byte[] last = this.sm4.decrypt(this.rk, input, inputOffset + inputLen - 16);
        if (!this.padding.getPadding().toUpperCase().equals("NOPADDING")) {
            byte[] recover = this.padding.recover(last);
            res = new byte[inputLen - 16 + recover.length + extra];
            SM4Util.copyArray(recover, 0, recover.length, res, res.length - recover.length);
        } else {
            res = new byte[inputLen + extra];
            SM4Util.copyArray(last, 0, last.length, res, res.length - last.length);
        }
        return res;
    }

    private int decryptLastBlock(byte[] input, int inputOffset, int inputLen, int extra, byte[] output, int outputOffset) throws BadPaddingException, ShortBufferException {
        int need;
        byte[] last = this.sm4.decrypt(this.rk, input, inputOffset + inputLen - 16);
        if (!this.padding.getPadding().toUpperCase().equals("NOPADDING")) {
            byte[] recover = this.padding.recover(last);
            need = inputLen - 16 + recover.length + extra;
            if (need + outputOffset > output.length) {
                throw new ShortBufferException();
            }
            SM4Util.copyArray(recover, 0, recover.length, output, outputOffset + need - recover.length);
        } else {
            need = inputLen + extra;
            if (need + outputOffset > output.length) {
                throw new ShortBufferException();
            }
            SM4Util.copyArray(last, 0, last.length, output, outputOffset + need - last.length);
        }
        return need;
    }

    private void encrypt(byte[] input, int inputOffset, int inputLen, byte[] res, int offset) {
        int i = inputOffset;
        while (i + 16 <= inputOffset + inputLen) {
            this.sm4.encrypt(this.rk, input, i, res, offset + (i - inputOffset));
            i += 16;
        }
        if (inputLen % 16 != 0) {
            byte[] fill = this.padding.fill(input, i, inputLen % 16);
            this.sm4.encrypt(this.rk, fill, 0, res, offset + (i - inputOffset));
        }
        if (inputLen % 16 == 0 && !this.padding.getPadding().equals("NOPADDING")) {
            byte[] block = new byte[16];
            Arrays.fill(block, (byte)16);
            this.sm4.encrypt(this.rk, block, 0, res, offset + i - inputOffset);
        }
    }
}

