/*
 * Decompiled with CFR 0.152.
 */
package org.openeuler.sun.security.ssl;

import java.nio.ByteBuffer;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import org.openeuler.sun.security.ssl.CipherSuite;
import org.openeuler.sun.security.ssl.JsseJce;
import org.openeuler.sun.security.ssl.ProtocolVersion;

abstract class Authenticator {
    protected final byte[] block;

    private Authenticator(byte[] block) {
        this.block = block;
    }

    static Authenticator valueOf(ProtocolVersion protocolVersion) {
        if (protocolVersion.useGMTLSSpec()) {
            return new GMTLSAuthenticator(protocolVersion);
        }
        if (protocolVersion.useTLS13PlusSpec()) {
            return new TLS13Authenticator(protocolVersion);
        }
        if (protocolVersion.useTLS10PlusSpec()) {
            return new TLS10Authenticator(protocolVersion);
        }
        return new SSL30Authenticator();
    }

    static <T extends Authenticator> T valueOf(ProtocolVersion protocolVersion, CipherSuite.MacAlg macAlg, SecretKey key) throws NoSuchAlgorithmException, InvalidKeyException {
        if (protocolVersion.useGMTLSSpec()) {
            return (T)new GMTLSMac(protocolVersion, macAlg, key);
        }
        if (protocolVersion.useTLS13PlusSpec()) {
            throw new RuntimeException("No MacAlg used in TLS 1.3");
        }
        if (protocolVersion.useTLS10PlusSpec()) {
            return (T)new TLS10Mac(protocolVersion, macAlg, key);
        }
        return (T)new SSL30Mac(protocolVersion, macAlg, key);
    }

    static Authenticator nullTlsMac() {
        return new SSLNullMac();
    }

    abstract boolean seqNumOverflow();

    abstract boolean seqNumIsHuge();

    final byte[] sequenceNumber() {
        return Arrays.copyOf(this.block, 8);
    }

    final void increaseSequenceNumber() {
        int k = 7;
        while (k >= 0) {
            int n = k--;
            this.block[n] = (byte)(this.block[n] + 1);
            if (this.block[n] == 0) continue;
        }
    }

    byte[] acquireAuthenticationBytes(byte type, int length, byte[] sequence2) {
        throw new UnsupportedOperationException("Used by AEAD algorithms only");
    }

    static final long toLong(byte[] recordEnS) {
        if (recordEnS != null && recordEnS.length == 8) {
            return ((long)recordEnS[0] & 0xFFL) << 56 | ((long)recordEnS[1] & 0xFFL) << 48 | ((long)recordEnS[2] & 0xFFL) << 40 | ((long)recordEnS[3] & 0xFFL) << 32 | ((long)recordEnS[4] & 0xFFL) << 24 | ((long)recordEnS[5] & 0xFFL) << 16 | ((long)recordEnS[6] & 0xFFL) << 8 | (long)recordEnS[7] & 0xFFL;
        }
        return -1L;
    }

    private static final class GMTLSMac
    extends GMTLSAuthenticator
    implements MAC {
        private final MacImpl macImpl;

        public GMTLSMac(ProtocolVersion protocolVersion, CipherSuite.MacAlg macAlg, SecretKey key) throws NoSuchAlgorithmException, InvalidKeyException {
            super(protocolVersion);
            this.macImpl = new MacImpl(protocolVersion, macAlg, key);
        }

        @Override
        public CipherSuite.MacAlg macAlg() {
            return this.macImpl.macAlg;
        }

        @Override
        public byte[] compute(byte type, ByteBuffer bb, byte[] sequence2, boolean isSimulated) {
            return this.macImpl.compute(type, bb, sequence2, isSimulated);
        }
    }

    private static final class TLS10Mac
    extends TLS10Authenticator
    implements MAC {
        private final MacImpl macImpl;

        public TLS10Mac(ProtocolVersion protocolVersion, CipherSuite.MacAlg macAlg, SecretKey key) throws NoSuchAlgorithmException, InvalidKeyException {
            super(protocolVersion);
            this.macImpl = new MacImpl(protocolVersion, macAlg, key);
        }

        @Override
        public CipherSuite.MacAlg macAlg() {
            return this.macImpl.macAlg;
        }

        @Override
        public byte[] compute(byte type, ByteBuffer bb, byte[] sequence2, boolean isSimulated) {
            return this.macImpl.compute(type, bb, sequence2, isSimulated);
        }
    }

    private static final class SSL30Mac
    extends SSL30Authenticator
    implements MAC {
        private final MacImpl macImpl;

        public SSL30Mac(ProtocolVersion protocolVersion, CipherSuite.MacAlg macAlg, SecretKey key) throws NoSuchAlgorithmException, InvalidKeyException {
            this.macImpl = new MacImpl(protocolVersion, macAlg, key);
        }

        @Override
        public CipherSuite.MacAlg macAlg() {
            return this.macImpl.macAlg;
        }

        @Override
        public byte[] compute(byte type, ByteBuffer bb, byte[] sequence2, boolean isSimulated) {
            return this.macImpl.compute(type, bb, sequence2, isSimulated);
        }
    }

    private static final class SSLNullMac
    extends SSLNullAuthenticator
    implements MAC {
        private final MacImpl macImpl = new MacImpl();

        @Override
        public CipherSuite.MacAlg macAlg() {
            return this.macImpl.macAlg;
        }

        @Override
        public byte[] compute(byte type, ByteBuffer bb, byte[] sequence2, boolean isSimulated) {
            return this.macImpl.compute(type, bb, sequence2, isSimulated);
        }
    }

    private class MacImpl
    implements MAC {
        private final CipherSuite.MacAlg macAlg;
        private final Mac mac;

        private MacImpl() {
            this.macAlg = CipherSuite.MacAlg.M_NULL;
            this.mac = null;
        }

        private MacImpl(ProtocolVersion protocolVersion, CipherSuite.MacAlg macAlg, SecretKey key) throws NoSuchAlgorithmException, InvalidKeyException {
            String algorithm;
            if (macAlg == null) {
                throw new RuntimeException("Null MacAlg");
            }
            boolean useSSLMac = protocolVersion.id < ProtocolVersion.TLS10.id;
            switch (macAlg) {
                case M_MD5: {
                    algorithm = useSSLMac ? "SslMacMD5" : "HmacMD5";
                    break;
                }
                case M_SHA: {
                    algorithm = useSSLMac ? "SslMacSHA1" : "HmacSHA1";
                    break;
                }
                case M_SHA256: {
                    algorithm = "HmacSHA256";
                    break;
                }
                case M_SHA384: {
                    algorithm = "HmacSHA384";
                    break;
                }
                case M_SM3: {
                    algorithm = "HmacSM3";
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown MacAlg " + (Object)((Object)macAlg));
                }
            }
            Mac m = JsseJce.getMac(algorithm);
            m.init(key);
            this.macAlg = macAlg;
            this.mac = m;
        }

        @Override
        public CipherSuite.MacAlg macAlg() {
            return this.macAlg;
        }

        @Override
        public byte[] compute(byte type, ByteBuffer bb, byte[] sequence2, boolean isSimulated) {
            if (this.macAlg.size == 0) {
                return new byte[0];
            }
            if (!isSimulated) {
                byte[] additional = Authenticator.this.acquireAuthenticationBytes(type, bb.remaining(), sequence2);
                this.mac.update(additional);
            }
            this.mac.update(bb);
            return this.mac.doFinal();
        }
    }

    static interface MAC {
        public CipherSuite.MacAlg macAlg();

        public byte[] compute(byte var1, ByteBuffer var2, byte[] var3, boolean var4);

        default public byte[] compute(byte type, ByteBuffer bb, boolean isSimulated) {
            return this.compute(type, bb, null, isSimulated);
        }
    }

    private static final class TLS13Authenticator
    extends SSLAuthenticator {
        private static final int BLOCK_SIZE = 13;

        private TLS13Authenticator(ProtocolVersion protocolVersion) {
            super(new byte[13]);
            this.block[9] = ProtocolVersion.TLS12.major;
            this.block[10] = ProtocolVersion.TLS12.minor;
        }

        @Override
        byte[] acquireAuthenticationBytes(byte type, int length, byte[] sequence2) {
            byte[] ad = Arrays.copyOfRange(this.block, 8, 13);
            this.increaseSequenceNumber();
            ad[0] = type;
            ad[3] = (byte)(length >> 8);
            ad[4] = (byte)(length & 0xFF);
            return ad;
        }
    }

    private static class GMTLSAuthenticator
    extends SSLAuthenticator {
        private static final int BLOCK_SIZE = 13;

        private GMTLSAuthenticator(ProtocolVersion protocolVersion) {
            super(new byte[13]);
            this.block[9] = protocolVersion.major;
            this.block[10] = protocolVersion.minor;
        }

        @Override
        byte[] acquireAuthenticationBytes(byte type, int length, byte[] sequence2) {
            byte[] ad = (byte[])this.block.clone();
            if (sequence2 != null) {
                if (sequence2.length != 8) {
                    throw new RuntimeException("Insufficient explicit sequence number bytes");
                }
                System.arraycopy(sequence2, 0, ad, 0, sequence2.length);
            } else {
                this.increaseSequenceNumber();
            }
            ad[8] = type;
            ad[11] = (byte)(length >> 8);
            ad[12] = (byte)length;
            return ad;
        }
    }

    private static class TLS10Authenticator
    extends SSLAuthenticator {
        private static final int BLOCK_SIZE = 13;

        private TLS10Authenticator(ProtocolVersion protocolVersion) {
            super(new byte[13]);
            this.block[9] = protocolVersion.major;
            this.block[10] = protocolVersion.minor;
        }

        @Override
        byte[] acquireAuthenticationBytes(byte type, int length, byte[] sequence2) {
            byte[] ad = (byte[])this.block.clone();
            if (sequence2 != null) {
                if (sequence2.length != 8) {
                    throw new RuntimeException("Insufficient explicit sequence number bytes");
                }
                System.arraycopy(sequence2, 0, ad, 0, sequence2.length);
            } else {
                this.increaseSequenceNumber();
            }
            ad[8] = type;
            ad[11] = (byte)(length >> 8);
            ad[12] = (byte)length;
            return ad;
        }
    }

    private static class SSL30Authenticator
    extends SSLAuthenticator {
        private static final int BLOCK_SIZE = 11;

        private SSL30Authenticator() {
            super(new byte[11]);
        }

        @Override
        byte[] acquireAuthenticationBytes(byte type, int length, byte[] sequence2) {
            byte[] ad = (byte[])this.block.clone();
            this.increaseSequenceNumber();
            ad[8] = type;
            ad[9] = (byte)(length >> 8);
            ad[10] = (byte)length;
            return ad;
        }
    }

    private static class SSLNullAuthenticator
    extends SSLAuthenticator {
        private SSLNullAuthenticator() {
            super(new byte[8]);
        }
    }

    private static class SSLAuthenticator
    extends Authenticator {
        private SSLAuthenticator(byte[] block) {
            super(block);
        }

        @Override
        boolean seqNumOverflow() {
            return this.block.length != 0 && this.block[0] == -1 && this.block[1] == -1 && this.block[2] == -1 && this.block[3] == -1 && this.block[4] == -1 && this.block[5] == -1 && this.block[6] == -1;
        }

        @Override
        boolean seqNumIsHuge() {
            return this.block.length != 0 && this.block[0] == -1 && this.block[1] == -1 && this.block[2] == -1 && this.block[3] == -1;
        }
    }
}

