/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.core;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.huaweicloud.sdk.core.CustomizationConfigure;
import com.huaweicloud.sdk.core.SdkResponse;
import com.huaweicloud.sdk.core.SdkSerializable;
import com.huaweicloud.sdk.core.SdkStreamRequest;
import com.huaweicloud.sdk.core.SdkStreamResponse;
import com.huaweicloud.sdk.core.auth.ICredential;
import com.huaweicloud.sdk.core.exception.DefaultExceptionHandler;
import com.huaweicloud.sdk.core.exception.ExceptionHandler;
import com.huaweicloud.sdk.core.exception.HostUnreachableException;
import com.huaweicloud.sdk.core.exception.SdkException;
import com.huaweicloud.sdk.core.exception.ServerResponseException;
import com.huaweicloud.sdk.core.exception.ServiceResponseException;
import com.huaweicloud.sdk.core.exchange.ApiReference;
import com.huaweicloud.sdk.core.exchange.SdkExchange;
import com.huaweicloud.sdk.core.exchange.SdkExchangeCache;
import com.huaweicloud.sdk.core.http.Field;
import com.huaweicloud.sdk.core.http.HttpClient;
import com.huaweicloud.sdk.core.http.HttpConfig;
import com.huaweicloud.sdk.core.http.HttpMethod;
import com.huaweicloud.sdk.core.http.HttpRequest;
import com.huaweicloud.sdk.core.http.HttpRequestDef;
import com.huaweicloud.sdk.core.http.HttpResponse;
import com.huaweicloud.sdk.core.http.LocationType;
import com.huaweicloud.sdk.core.http.SdkFormDataBody;
import com.huaweicloud.sdk.core.impl.DefaultHttpClient;
import com.huaweicloud.sdk.core.progress.ProgressInputStream;
import com.huaweicloud.sdk.core.progress.ProgressRequest;
import com.huaweicloud.sdk.core.progress.SimpleProgressManager;
import com.huaweicloud.sdk.core.utils.CastUtils;
import com.huaweicloud.sdk.core.utils.HttpUtils;
import com.huaweicloud.sdk.core.utils.JsonUtils;
import com.huaweicloud.sdk.core.utils.StringUtils;
import java.io.BufferedInputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Stack;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HcClient
implements CustomizationConfigure {
    private static final Logger logger = LoggerFactory.getLogger(HcClient.class);
    private final HttpClient httpClient;
    private final AtomicInteger endpointIndex = new AtomicInteger(0);
    private ExceptionHandler exceptionHandler = new DefaultExceptionHandler();
    private List<String> endpoints;
    private ICredential credential;
    private final HttpConfig httpConfig;
    private Map<String, String> extraHeaders;

    public List<String> getEndpoints() {
        return this.endpoints;
    }

    private HcClient(HcClient hcClient) {
        this.extraHeaders = hcClient.extraHeaders;
        this.httpClient = hcClient.httpClient;
        this.endpoints = hcClient.endpoints;
        this.credential = hcClient.credential;
        this.httpConfig = hcClient.httpConfig;
        this.exceptionHandler = hcClient.exceptionHandler;
    }

    HcClient(HttpConfig httpConfig, HttpClient httpClient) {
        this.httpConfig = httpConfig;
        this.httpClient = httpClient;
    }

    public HcClient(HttpConfig httpConfig) {
        this.httpConfig = httpConfig;
        this.httpClient = new DefaultHttpClient(this.httpConfig);
    }

    public HcClient withEndpoints(List<String> endpoints) {
        this.endpoints = endpoints;
        return this;
    }

    public HcClient withCredential(ICredential credential) {
        this.credential = credential;
        return this;
    }

    public HcClient withExtraHeaders(Map<String, String> extraHeaders) {
        this.extraHeaders = extraHeaders;
        return this;
    }

    protected HcClient withExceptionHandler(ExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
        return this;
    }

    public ICredential getCredential() {
        return this.credential;
    }

    public HttpConfig getHttpConfig() {
        return this.httpConfig;
    }

    public HcClient overrideEndpoints(List<String> endpoints) {
        return new HcClient(this).withEndpoints(endpoints);
    }

    public HcClient overrideCredential(ICredential credential) {
        return new HcClient(this).withCredential(credential);
    }

    @Deprecated
    public HcClient preInvoke(Map<String, String> extraHeaders) {
        HcClient client = new HcClient(this);
        client.extraHeaders = extraHeaders;
        return client;
    }

    public <R, S> S syncInvokeHttp(R request, HttpRequestDef<R, S> reqDef) throws ServiceResponseException {
        return this.syncInvokeHttp(request, reqDef, new SdkExchange());
    }

    public <R, S> S syncInvokeHttp(R request, HttpRequestDef<R, S> reqDef, SdkExchange exchange) throws ServiceResponseException {
        return this.syncInvokeHttp(request, reqDef, exchange, this.extraHeaders);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R, S> S syncInvokeHttp(R request, HttpRequestDef<R, S> reqDef, SdkExchange exchange, Map<String, String> extraHeaders) throws ServiceResponseException {
        if (Objects.isNull(exchange)) {
            throw new IllegalArgumentException("SdkExchange is null");
        }
        exchange.setApiReference(new ApiReference().withName(reqDef.getName()).withMethod(reqDef.getMethod().toString()).withUri(reqDef.getUri()));
        String exchangeId = SdkExchangeCache.putExchange(exchange);
        try {
            HttpResponse httpResponse;
            HttpRequest httpRequest;
            while (true) {
                try {
                    httpRequest = this.buildRequest(request, reqDef, extraHeaders);
                    if (StringUtils.isEmpty(httpRequest.getHeader("Authorization")) && Objects.nonNull(this.credential)) {
                        httpRequest = this.credential.syncProcessAuthRequest(httpRequest, this.httpClient);
                    }
                    httpRequest = httpRequest.builder().addHeader("SDK_EXCHANGE", exchangeId).build();
                    httpResponse = this.httpClient.syncInvokeHttp(httpRequest);
                }
                catch (HostUnreachableException unreachableException) {
                    if (this.endpointIndex.intValue() < this.endpoints.size() - 1) {
                        this.endpointIndex.incrementAndGet();
                        continue;
                    }
                    this.endpointIndex.set(0);
                    throw unreachableException;
                }
                break;
            }
            this.printAccessLog(httpRequest, httpResponse, exchange);
            this.exceptionHandler.handleException(httpRequest, httpResponse);
            S s = this.extractResponse(httpRequest, httpResponse, reqDef);
            return s;
        }
        finally {
            SdkExchangeCache.removeExchange(exchangeId);
        }
    }

    public <R, S> CompletableFuture<S> asyncInvokeHttp(R request, HttpRequestDef<R, S> reqDef) {
        return this.asyncInvokeHttp(request, reqDef, new SdkExchange());
    }

    public <R, S> CompletableFuture<S> asyncInvokeHttp(R request, HttpRequestDef<R, S> reqDef, SdkExchange exchange) {
        return this.asyncInvokeHttp(request, reqDef, exchange, this.extraHeaders);
    }

    public <R, S> CompletableFuture<S> asyncInvokeHttp(R request, HttpRequestDef<R, S> reqDef, SdkExchange exchange, Map<String, String> extraHeaders) {
        HttpRequest httpRequest;
        if (Objects.isNull(exchange)) {
            return CompletableFuture.supplyAsync(() -> {
                throw new IllegalArgumentException("SdkExchange is null");
            }, this.httpConfig.getExecutorService());
        }
        exchange.setApiReference(new ApiReference().withName(reqDef.getName()).withMethod(reqDef.getMethod().toString()).withUri(reqDef.getUri()));
        AtomicReference exchangeIdRef = new AtomicReference();
        try {
            httpRequest = this.buildRequest(request, reqDef, extraHeaders);
        }
        catch (SdkException e) {
            CompletableFuture future = new CompletableFuture();
            future.completeExceptionally(e);
            return future;
        }
        HttpRequest finalHttpRequest = httpRequest;
        CompletableFuture<HttpRequest> validHttpRequestStage = CompletableFuture.supplyAsync(() -> finalHttpRequest, this.httpConfig.getExecutorService());
        if (StringUtils.isEmpty(httpRequest.getHeader("Authorization")) && Objects.nonNull(this.credential)) {
            validHttpRequestStage = this.credential.processAuthRequest(httpRequest, this.httpClient);
        }
        return validHttpRequestStage.thenComposeAsync(validHttpRequest -> {
            String id = SdkExchangeCache.putExchange(exchange);
            exchangeIdRef.set(id);
            HttpRequest finalValidHttpRequest = validHttpRequest = validHttpRequest.builder().addHeader("SDK_EXCHANGE", id).build();
            return ((CompletableFuture)this.httpClient.asyncInvokeHttp((HttpRequest)validHttpRequest).thenApplyAsync(httpResponse -> {
                this.printAccessLog(finalValidHttpRequest, (HttpResponse)httpResponse, exchange);
                this.exceptionHandler.handleException(finalValidHttpRequest, (HttpResponse)httpResponse);
                return this.extractResponse(finalValidHttpRequest, (HttpResponse)httpResponse, reqDef);
            }, (Executor)this.httpConfig.getExecutorService())).whenCompleteAsync((r, e) -> SdkExchangeCache.removeExchange((String)exchangeIdRef.get()), (Executor)this.httpConfig.getExecutorService());
        }, (Executor)this.httpConfig.getExecutorService());
    }

    protected <R, S> HttpRequest buildRequest(R request, HttpRequestDef<R, S> reqDef) {
        return this.buildRequest(request, reqDef, null);
    }

    protected <R, S> HttpRequest buildRequest(R request, HttpRequestDef<R, S> reqDef, Map<String, String> extraHeaders) {
        String endpoint = this.endpoints.get(this.endpointIndex.intValue());
        HttpRequest.HttpRequestBuilder httpRequestBuilder = HttpRequest.newBuilder();
        httpRequestBuilder.withMethod(reqDef.getMethod()).withEndpoint(endpoint).withPath(reqDef.getUri());
        boolean hasBody = false;
        for (Field<R, ?> field : reqDef.getRequestFields()) {
            Optional<?> reqValueOption;
            Optional<?> optional = reqValueOption = this.httpConfig.isIgnoreRequiredValidation() ? field.readValueNoValidation(request) : field.readValue(request);
            if (!reqValueOption.isPresent()) continue;
            Object reqValue = reqValueOption.get();
            switch (field.getLocation()) {
                case Header: {
                    httpRequestBuilder.addHeader(field.getName(), this.convertToStringParams(reqValue));
                    break;
                }
                case Query: {
                    this.buildQueryParams(httpRequestBuilder, field.getName(), reqValue);
                    break;
                }
                case Path: {
                    httpRequestBuilder.addPathParam(field.getName(), this.convertToStringParams(reqValue));
                    break;
                }
                case Body: {
                    this.buildRequestBody(httpRequestBuilder, reqValue);
                    hasBody = true;
                    break;
                }
                case Cname: {
                    this.buildCname(httpRequestBuilder, endpoint, reqValue);
                    break;
                }
            }
        }
        if (!this.httpConfig.isIgnoreContentTypeForGetRequest() || reqDef.getMethod() != HttpMethod.GET || hasBody) {
            httpRequestBuilder.withContentType(reqDef.getContentType());
        }
        this.processStreamRequest(httpRequestBuilder, request);
        this.processExtraHeaders(httpRequestBuilder, extraHeaders);
        if (Objects.nonNull((Object)this.httpConfig.getSigningAlgorithm())) {
            httpRequestBuilder.withSigningAlgorithm(this.httpConfig.getSigningAlgorithm());
        }
        return httpRequestBuilder.build();
    }

    private <R> void processStreamRequest(HttpRequest.HttpRequestBuilder builder, R request) {
        if (request instanceof SdkStreamRequest) {
            builder.withBody(((SdkStreamRequest)request).extractBody());
        }
        if (!(request instanceof ProgressRequest)) {
            return;
        }
        ProgressRequest progressRequest = (ProgressRequest)request;
        long progressInterval = progressRequest.getProgressInterval() > 0L ? progressRequest.getProgressInterval() : 102400L;
        builder.withProgressListener(progressRequest.getProgressListener()).withProgressInterval(progressInterval);
    }

    private void processExtraHeaders(HttpRequest.HttpRequestBuilder builder, Map<String, String> extraHeaders) {
        HashMap<String, String> headers = new HashMap<String, String>();
        if (Objects.nonNull(this.extraHeaders)) {
            headers.putAll(this.extraHeaders);
        }
        if (Objects.nonNull(extraHeaders)) {
            headers.putAll(extraHeaders);
        }
        String userAgent = headers.containsKey("User-Agent") ? "huaweicloud-usdk-java/3.0;" + (String)headers.get("User-Agent") : "huaweicloud-usdk-java/3.0";
        headers.put("User-Agent", userAgent);
        builder.addHeaders(headers);
    }

    private void buildCname(HttpRequest.HttpRequestBuilder httpRequestBuilder, String endpoint, Object reqValue) {
        try {
            URL url = new URL(endpoint.replace("\r", "").replace("\n", ""));
            StringBuilder endpointBuilder = new StringBuilder();
            endpointBuilder.append(url.getProtocol()).append("://").append(reqValue).append(".").append(url.getAuthority());
            if (!StringUtils.isEmpty(url.getPath())) {
                endpointBuilder.append("/").append(url.getPath());
            }
            httpRequestBuilder.withEndpoint(endpointBuilder.toString());
        }
        catch (MalformedURLException e) {
            throw new SdkException("Failed to parse endpoint");
        }
    }

    private void buildRequestBody(HttpRequest.HttpRequestBuilder httpRequestBuilder, Object reqValue) {
        if (reqValue instanceof SdkFormDataBody) {
            httpRequestBuilder.withFormDataPart(((SdkFormDataBody)reqValue).buildFormData());
        } else if (reqValue instanceof SdkSerializable) {
            httpRequestBuilder.withBodyAsString(((SdkSerializable)reqValue).serialize());
        } else {
            String bodyString = reqValue instanceof String ? (String)reqValue : JsonUtils.toJSON(reqValue);
            httpRequestBuilder.withBodyAsString(bodyString);
        }
    }

    private void buildQueryParams(HttpRequest.HttpRequestBuilder httpRequestBuilder, String fieldName, Object reqValue) {
        if (reqValue instanceof Collection) {
            httpRequestBuilder.addQueryParam(fieldName, this.buildCollectionQueryParams(reqValue));
        } else if (reqValue instanceof Map) {
            Map<String, List<String>> params = this.buildMapQueryParamsLoop(fieldName, (Map)reqValue);
            for (Map.Entry<String, List<String>> entry : params.entrySet()) {
                httpRequestBuilder.addQueryParam(entry.getKey(), entry.getValue());
            }
        } else {
            httpRequestBuilder.addQueryParam(fieldName, Collections.singletonList(this.convertToStringParams(reqValue)));
        }
    }

    private String convertToStringParams(Object reqValue) {
        if (reqValue instanceof OffsetDateTime) {
            return ((OffsetDateTime)reqValue).format(DateTimeFormatter.ISO_OFFSET_DATE_TIME);
        }
        return reqValue.toString();
    }

    private List<String> buildCollectionQueryParams(Object reqValue) {
        return ((List)reqValue).stream().map(this::convertToStringParams).collect(Collectors.toList());
    }

    private Map<String, List<String>> buildMapQueryParamsLoop(String key, Map<?, ?> reqValue) {
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        Stack stack = new Stack();
        reqValue.forEach((k, v) -> stack.push(this.buildMapQueryParams(key, k.toString(), v)));
        while (!stack.isEmpty()) {
            Map temp = (Map)stack.pop();
            result.putAll(temp);
        }
        return result;
    }

    private Map<String, List<String>> buildMapQueryParams(String key, String entryKey, Object entryValue) {
        HashMap<String, List<String>> res = new HashMap<String, List<String>>();
        if (entryValue instanceof Map) {
            ((Map)entryValue).forEach((k, v) -> res.putAll(this.buildMapQueryParams(key + "[" + entryKey + "]", k.toString(), v)));
        } else if (entryValue instanceof Collection) {
            res.put(key + "[" + entryKey + "]", this.buildCollectionQueryParams(entryValue));
        } else {
            res.put(key + "[" + entryKey + "]", Collections.singletonList(this.convertToStringParams(entryValue)));
        }
        return res;
    }

    private <S> S processTextBasedType(HttpResponse httpResponse, HttpRequestDef<?, S> reqDef) throws InstantiationException, IllegalAccessException {
        S response;
        String stringResult = httpResponse.getBodyAsString();
        int statusCode = httpResponse.getStatusCode();
        if (SdkSerializable.class.isAssignableFrom(reqDef.getResponseType())) {
            response = this.deserializeSerializableResponse(reqDef.getResponseType(), stringResult);
        } else if (!reqDef.hasResponseField("body")) {
            response = JsonUtils.toObjectIgnoreUnknown(stringResult, reqDef.getResponseType());
            if (Objects.isNull(response)) {
                response = reqDef.getResponseType().newInstance();
            }
            if (reqDef.hasResponseField(String.valueOf(statusCode))) {
                Field<S, ?> resTField = reqDef.getResponseField(String.valueOf(statusCode));
                resTField.writeValueSafe(response, JsonUtils.toObjectIgnoreUnknown(stringResult, resTField.getFieldType()), resTField.getFieldType());
            }
        } else {
            response = reqDef.getResponseType().newInstance();
            Field<S, ?> responseField = reqDef.getResponseField("body");
            Object obj = this.responseToObject(stringResult, responseField);
            responseField.writeValueSafe(response, obj, responseField.getFieldType());
            if (reqDef.hasResponseField(String.valueOf(statusCode))) {
                Field<S, ?> resTField = reqDef.getResponseField(String.valueOf(statusCode));
                resTField.writeValueSafe(response, obj, resTField.getFieldType());
            }
        }
        return response;
    }

    private <S> S processStreamType(HttpRequest httpRequest, HttpResponse httpResponse, HttpRequestDef<?, S> reqDef) throws InstantiationException, IllegalAccessException {
        Object response = reqDef.getResponseType().newInstance();
        if (response instanceof SdkStreamResponse) {
            if (Objects.nonNull(httpRequest.getProgressListener())) {
                SimpleProgressManager progressManager = new SimpleProgressManager(httpResponse.getContentLength(), 0L, httpRequest.getProgressListener(), httpRequest.getProgressInterval());
                ((SdkStreamResponse)response).parseBody(new BufferedInputStream(new ProgressInputStream(httpResponse.getBody(), progressManager), 8192));
            } else {
                response = Objects.nonNull(httpResponse.getContentType()) && HttpUtils.isBsonContentType(httpResponse.getContentType()) ? CastUtils.cast(((SdkStreamResponse)response).parseBody(httpResponse.getBodyAsBytes())) : CastUtils.cast(((SdkStreamResponse)response).parseBody(httpResponse.getBody()));
            }
        }
        return response;
    }

    private <R, S> S extractResponse(HttpRequest httpRequest, HttpResponse httpResponse, HttpRequestDef<R, S> reqDef) {
        try {
            Object finalResT = HttpUtils.isTextBasedContentType(httpResponse.getContentType()) ? this.processTextBasedType(httpResponse, reqDef) : this.processStreamType(httpRequest, httpResponse, reqDef);
            reqDef.getResponseFields().forEach(resTField -> {
                if (resTField.getLocation() == LocationType.Header) {
                    this.fillHeaderField(httpResponse, finalResT, (Field)resTField);
                }
            });
            if (finalResT instanceof SdkResponse) {
                ((SdkResponse)finalResT).setHttpStatusCode(httpResponse.getStatusCode());
            }
            return finalResT;
        }
        catch (IllegalAccessException | InstantiationException e) {
            logger.error("Can not create response instance", (Throwable)e);
            return null;
        }
        catch (SdkException e) {
            logger.error("can not parse json result to response object", (Throwable)e);
            throw new ServerResponseException(httpResponse.getStatusCode(), null, "json parse error: " + e.getMessage(), httpResponse.getHeader("X-Request-Id"));
        }
    }

    private <S> S deserializeSerializableResponse(Class<S> clazz, String string) throws InstantiationException, IllegalAccessException {
        S instance = clazz.newInstance();
        return (S)((SdkSerializable)instance).deserialize(string);
    }

    public <S> Object responseToObject(String respBody, Field<S, ?> responseField) {
        Class<?> fieldType = responseField.getFieldType();
        if (String.class.isAssignableFrom(fieldType)) {
            return respBody;
        }
        if (List.class.isAssignableFrom(fieldType)) {
            return JsonUtils.toListObject(respBody, responseField.getInnerContainerType());
        }
        if (Map.class.isAssignableFrom(fieldType)) {
            return JsonUtils.toMapObject(respBody, responseField.getInnerContainerType());
        }
        return JsonUtils.toObject(respBody, fieldType);
    }

    private <S> void fillHeaderField(HttpResponse httpResponse, S wrapperResponse, Field<S, ?> field) {
        List<String> infos = httpResponse.getHeaders().get(field.getName());
        if (Objects.nonNull(infos) && infos.size() > 0) {
            if (field.getFieldType().isAssignableFrom(List.class)) {
                field.writeValueSafe(wrapperResponse, infos, List.class);
            } else {
                field.writeValueSafe(wrapperResponse, infos.get(0), String.class);
                if (infos.size() > 1) {
                    logger.error("field {} passed list {}, but configured as single value", (Object)field.getName(), (Object)String.join((CharSequence)",", infos));
                }
            }
        } else {
            logger.warn("field {} in header read response value is empty", (Object)field.getName());
        }
    }

    @Override
    public void configJson(Consumer<ObjectMapper> func) {
        func.accept(JsonUtils.getDefaultMapper());
    }

    public void printAccessLog(HttpRequest httpRequest, HttpResponse httpResponse, SdkExchange exchange) {
        String requestId = Objects.isNull(httpResponse.getHeader("X-Request-Id")) ? "null" : httpResponse.getHeader("X-Request-Id");
        AccessLog.get().info("\"{} {}\" {} {} {} {}", new Object[]{httpRequest.getMethod(), httpRequest.getUrl(), httpResponse.getStatusCode(), httpResponse.getContentLength(), requestId, Objects.nonNull(exchange) && Objects.nonNull(exchange.getApiTimer()) ? Long.valueOf(exchange.getApiTimer().getDurationMs()) : ""});
    }

    public static class AccessLog {
        private static final Logger logger = LoggerFactory.getLogger((String)"HuaweiCloud-SDK-Access");

        public static Logger get() {
            return logger;
        }
    }
}

