/*
 * Decompiled with CFR 0.152.
 */
package org.openeuler;

import java.security.InvalidAlgorithmParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KeyGeneratorSpi;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.openeuler.BGMJCEProvider;

public class HmacSM3KeyGenerator
extends KeyGeneratorSpi {
    private SecureRandom random = null;
    private int keysize = 32;

    @Override
    protected void engineInit(SecureRandom random) {
        this.random = random;
    }

    @Override
    protected void engineInit(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        throw new InvalidAlgorithmParameterException("HMAC-SM3 key generation does not take any parameters");
    }

    @Override
    protected void engineInit(int keysize, SecureRandom random) {
        this.keysize = (keysize + 7) / 8;
        this.engineInit(random);
    }

    @Override
    protected SecretKey engineGenerateKey() {
        if (this.random == null) {
            this.random = BGMJCEProvider.getRandom();
        }
        byte[] keyBytes = new byte[this.keysize];
        this.random.nextBytes(keyBytes);
        return new SecretKeySpec(keyBytes, "HmacSM3");
    }
}

