/*
 * Decompiled with CFR 0.152.
 */
package org.openeuler;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.ProviderException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import org.openeuler.org.bouncycastle.SM2ParameterSpec;
import org.openeuler.sun.security.ec.ECKeyFactory;
import org.openeuler.util.GMUtil;
import org.openeuler.util.Util;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.util.ECUtil;

public class SM2SignatureSpi
extends SignatureSpi {
    private final MessageDigest digest;
    private ECPrivateKey privateKey;
    private ECPublicKey publicKey;
    private SM2ParameterSpec sigParams;
    private ECPoint pubPoint;
    private ByteArrayOutputStream byteBuf = new ByteArrayOutputStream();
    private byte[] z;

    public SM2SignatureSpi() throws NoSuchAlgorithmException {
        this(MessageDigest.getInstance("SM3"));
    }

    public SM2SignatureSpi(MessageDigest digest) {
        this.digest = digest;
    }

    @Override
    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        this.publicKey = (ECPublicKey)ECKeyFactory.toECKey(publicKey);
        if (!SM2SignatureSpi.isCompatible(this.sigParams, this.publicKey.getParams())) {
            throw new InvalidKeyException("Key params does not match signature params");
        }
        byte[] ID2 = this.getID();
        byte[] entLen = new byte[]{(byte)(ID2.length * 8 >> 8 & 0xFF), (byte)(ID2.length * 8 & 0xFF)};
        this.pubPoint = ((ECPublicKey)publicKey).getW();
        ECParameterSpec ecParams = this.publicKey.getParams();
        this.z = this.getZ(ecParams, entLen, ID2);
        this.byteBuf.reset();
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        this.privateKey = (ECPrivateKey)ECKeyFactory.toECKey(privateKey);
        if (!SM2SignatureSpi.isCompatible(this.sigParams, this.privateKey.getParams())) {
            throw new InvalidKeyException("Key params does not match signature params");
        }
        byte[] ID2 = this.getID();
        byte[] entLen = new byte[]{(byte)(ID2.length * 8 >> 8 & 0xFF), (byte)(ID2.length * 8 & 0xFF)};
        ECParameterSpec ecParams = this.privateKey.getParams();
        this.pubPoint = GMUtil.multiply(ecParams.getGenerator(), this.privateKey.getS(), ecParams.getCurve());
        this.z = this.getZ(ecParams, entLen, ID2);
        this.byteBuf.reset();
    }

    protected byte[] getID() {
        byte[] ID2;
        if (this.appRandom == null) {
            this.appRandom = new SecureRandom();
        }
        if (this.sigParams == null || this.sigParams.getId() == null) {
            ID2 = "1234567812345678".getBytes(StandardCharsets.UTF_8);
        } else {
            ID2 = this.sigParams.getId();
            if (ID2.length >= 8192) {
                throw new IllegalArgumentException("SM2 user ID must be less than 2^16 bits long");
            }
        }
        return ID2;
    }

    @Override
    protected void engineUpdate(byte b) throws SignatureException {
        this.byteBuf.write(b);
    }

    @Override
    protected void engineUpdate(byte[] b, int off, int len) throws SignatureException {
        this.byteBuf.write(b, off, len);
    }

    @Override
    protected byte[] engineSign() throws SignatureException {
        try {
            BigInteger s;
            BigInteger x1;
            BigInteger r;
            int nBitLen;
            BigInteger k;
            byte[] m = this.byteBuf.toByteArray();
            this.byteBuf.reset();
            this.digest.update(this.z);
            this.digest.update(m);
            byte[] eHash = this.digest.digest();
            BigInteger e = new BigInteger(1, eHash);
            ECParameterSpec ecParams = this.privateKey.getParams();
            BigInteger n = ecParams.getOrder();
            BigInteger d = this.privateKey.getS();
            while ((k = Util.createRandomBigInteger(nBitLen = n.bitLength(), this.appRandom)).compareTo(BigInteger.ONE) < 0 || k.compareTo(n) >= 0 || (r = e.add(x1 = GMUtil.multiply(ecParams.getGenerator(), k, ecParams.getCurve()).getAffineX()).mod(n)).equals(BigInteger.ZERO) || r.add(k).equals(n) || (s = d.add(BigInteger.ONE).modInverse(n).multiply(k.subtract(r.multiply(d).mod(n)).mod(n)).mod(n)).equals(BigInteger.ZERO)) {
            }
            try {
                return this.encodeSignature(n, r, s);
            }
            catch (Exception ex) {
                throw new SignatureException("unable to encode signature: " + ex.getMessage(), ex);
            }
        }
        catch (SignatureException e) {
            throw new SignatureException("unable to create signature: " + e.getMessage());
        }
    }

    @Override
    protected boolean engineVerify(byte[] sigBytes) throws SignatureException {
        try {
            ECParameterSpec ecParams = this.publicKey.getParams();
            BigInteger n = ecParams.getOrder();
            BigInteger[] rs = this.decodeSignature(n, sigBytes);
            BigInteger r = rs[0];
            BigInteger s = rs[1];
            if (r.compareTo(BigInteger.ZERO) <= 0 || r.compareTo(n) >= 0) {
                return false;
            }
            if (s.compareTo(BigInteger.ZERO) <= 0 || s.compareTo(n) >= 0) {
                return false;
            }
            byte[] m = this.byteBuf.toByteArray();
            this.byteBuf.reset();
            this.digest.update(this.z);
            this.digest.update(m);
            byte[] eHash = this.digest.digest();
            BigInteger e = new BigInteger(1, eHash);
            BigInteger t = r.add(s).mod(n);
            if (t.equals(BigInteger.ZERO)) {
                return false;
            }
            ECPoint x1y1 = GMUtil.add(GMUtil.multiply(ecParams.getGenerator(), s, ecParams.getCurve()), GMUtil.multiply(this.pubPoint, t, ecParams.getCurve()));
            if (x1y1.equals(ECPoint.POINT_INFINITY)) {
                return false;
            }
            BigInteger R = e.add(x1y1.getAffineX()).mod(n);
            return R.equals(r);
        }
        catch (Exception e) {
            throw new SignatureException(e.getMessage());
        }
    }

    @Override
    @Deprecated
    protected void engineSetParameter(String param, Object value) throws InvalidParameterException {
        throw new UnsupportedOperationException("setParameter() not supported");
    }

    @Override
    protected void engineSetParameter(AlgorithmParameterSpec params) throws InvalidAlgorithmParameterException {
        if (params == null || !(params instanceof SM2ParameterSpec)) {
            throw new InvalidAlgorithmParameterException("only SM2ParameterSpec supported");
        }
        this.sigParams = (SM2ParameterSpec)params;
    }

    @Override
    @Deprecated
    protected Object engineGetParameter(String param) throws InvalidParameterException {
        throw new UnsupportedOperationException("getParameter() not supported");
    }

    @Override
    protected AlgorithmParameters engineGetParameters() {
        if (this.sigParams == null || this.sigParams.getParams() == null) {
            return null;
        }
        try {
            AlgorithmParameters ap = AlgorithmParameters.getInstance("EC");
            ap.init(this.sigParams.getParams());
            return ap;
        }
        catch (Exception e) {
            throw new ProviderException("Error retrieving EC parameters", e);
        }
    }

    private byte[] getZ(ECParameterSpec ecParams, byte[] entLen, byte[] ID2) {
        this.digest.reset();
        int curveLen = (ecParams.getCurve().getField().getFieldSize() + 7) / 8;
        this.digest.update(entLen);
        this.digest.update(ID2);
        this.digest.update(Util.asUnsignedByteArray(curveLen, ecParams.getCurve().getA()));
        this.digest.update(Util.asUnsignedByteArray(curveLen, ecParams.getCurve().getB()));
        this.digest.update(Util.asUnsignedByteArray(curveLen, ecParams.getGenerator().getAffineX()));
        this.digest.update(Util.asUnsignedByteArray(curveLen, ecParams.getGenerator().getAffineY()));
        this.digest.update(Util.asUnsignedByteArray(curveLen, this.pubPoint.getAffineX()));
        this.digest.update(Util.asUnsignedByteArray(curveLen, this.pubPoint.getAffineY()));
        return this.digest.digest();
    }

    private byte[] encodeSignature(BigInteger n, BigInteger r, BigInteger s) throws IOException {
        DerOutputStream out = new DerOutputStream();
        out.putInteger(r);
        out.putInteger(s);
        DerValue result = new DerValue(48, out.toByteArray());
        return result.toByteArray();
    }

    private BigInteger[] decodeSignature(BigInteger n, byte[] sig) throws SignatureException {
        try {
            DerInputStream in = new DerInputStream(sig, 0, sig.length, false);
            DerValue[] values2 = in.getSequence(2);
            if (values2.length != 2 || in.available() != 0) {
                throw new IOException("Invalid encoding for signature");
            }
            BigInteger r = values2[0].getPositiveBigInteger();
            BigInteger s = values2[1].getPositiveBigInteger();
            if (r.signum() < 0 || null != n && r.compareTo(n) >= 0) {
                throw new IllegalArgumentException("Value out of range");
            }
            if (s.signum() < 0 || null != n && s.compareTo(n) >= 0) {
                throw new IllegalArgumentException("Value out of range");
            }
            return new BigInteger[]{r, s};
        }
        catch (Exception e) {
            throw new SignatureException("Invalid encoding for signature", e);
        }
    }

    private static boolean isCompatible(SM2ParameterSpec sigParams, ECParameterSpec keyParams) {
        if (sigParams == null || sigParams.getParams() == null) {
            return true;
        }
        return ECUtil.equals(sigParams.getParams(), keyParams);
    }

    public static class sm3WithSM2
    extends SM2SignatureSpi {
        public sm3WithSM2() throws NoSuchAlgorithmException {
            super(MessageDigest.getInstance("SM3"));
        }
    }
}

