/*
 * Decompiled with CFR 0.152.
 */
package org.openeuler.gm;

import java.lang.reflect.Field;
import sun.security.util.Debug;

public class PKCS12KeyStoreHandler {
    private static final Debug debug = Debug.getInstance("compatible");
    private static final String LEGACY_CERT_PBE_ALGORITHM = "PBEWithSHA1AndRC2_40";
    private static final String LEGACY_KEY_PBE_ALGORITHM = "PBEWithSHA1AndDESede";
    private static final String LEGACY_MAC_ALGORITHM = "HmacPBESHA1";
    private static final int LEGACY_PBE_ITERATION_COUNT = 50000;
    private static final int LEGACY_MAC_ITERATION_COUNT = 100000;
    private static Class<?> pkcs12KeyStoreClass;

    private static void init() {
        block2: {
            try {
                pkcs12KeyStoreClass = Class.forName("sun.security.pkcs12.PKCS12KeyStore");
            }
            catch (ClassNotFoundException e) {
                if (debug == null) break block2;
                debug.println("The sun.security.pkcs12.PKCS12KeyStore class does not exist");
            }
        }
    }

    public static String getDefaultCertPBEAlgorithm() {
        return PKCS12KeyStoreHandler.getFieldValue("DEFAULT_CERT_PBE_ALGORITHM", LEGACY_CERT_PBE_ALGORITHM);
    }

    public static int getDefaultCertPBEIterationCount() {
        return PKCS12KeyStoreHandler.getFieldValue("DEFAULT_CERT_PBE_ITERATION_COUNT", 50000);
    }

    public static String getDefaultKeyPBEAlgorithm() {
        return PKCS12KeyStoreHandler.getFieldValue("DEFAULT_KEY_PBE_ALGORITHM", LEGACY_KEY_PBE_ALGORITHM);
    }

    public static int getDefaultKeyPBEIterationCount() {
        return PKCS12KeyStoreHandler.getFieldValue("DEFAULT_KEY_PBE_ITERATION_COUNT", 50000);
    }

    public static String getDefaultMacAlgorithm() {
        return PKCS12KeyStoreHandler.getFieldValue("DEFAULT_MAC_ALGORITHM", LEGACY_MAC_ALGORITHM);
    }

    public static int getDefaultMacIterationCount() {
        return PKCS12KeyStoreHandler.getFieldValue("DEFAULT_MAC_ITERATION_COUNT", 100000);
    }

    private static <T> T getFieldValue(String fieldName, T defaultValue) {
        Field field;
        if (pkcs12KeyStoreClass == null) {
            return defaultValue;
        }
        try {
            field = pkcs12KeyStoreClass.getDeclaredField(fieldName);
            field.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            if (debug != null) {
                debug.println("Field " + fieldName + " does not exist");
            }
            return defaultValue;
        }
        try {
            return (T)field.get(null);
        }
        catch (IllegalAccessException e) {
            if (debug != null) {
                debug.println(e.getMessage());
            }
            return defaultValue;
        }
    }

    static {
        PKCS12KeyStoreHandler.init();
    }
}

