/*
 * Decompiled with CFR 0.152.
 */
package org.openeuler.gm;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import sun.security.util.Debug;
import sun.security.x509.X509CertImpl;

public class X509CertImplHandler {
    private static final Debug debug = Debug.getInstance("compatible");
    private static final Debug certPathDebug = Debug.getInstance("certpath");
    private static boolean useHighVersionNoStaticMethod;
    private static boolean useHighVersionStaticMethod;
    private static Method nonStatic_getFingerprint_method;
    private static Method static_getFingerprint_method;

    private static void init() {
        X509CertImplHandler.initNonStaticGetFingerprintMethod();
        X509CertImplHandler.initStaticGetFingerprintMethod();
    }

    private static void initNonStaticGetFingerprintMethod() {
        nonStatic_getFingerprint_method = X509CertImplHandler.getMethod("getFingerprint", new Class[]{String.class});
        if (nonStatic_getFingerprint_method != null) {
            return;
        }
        nonStatic_getFingerprint_method = X509CertImplHandler.getMethod("getFingerprint", new Class[]{String.class, Debug.class});
        if (nonStatic_getFingerprint_method != null) {
            useHighVersionNoStaticMethod = true;
        }
    }

    private static void initStaticGetFingerprintMethod() {
        static_getFingerprint_method = X509CertImplHandler.getMethod("getFingerprint", new Class[]{String.class, X509Certificate.class});
        if (static_getFingerprint_method != null) {
            return;
        }
        static_getFingerprint_method = X509CertImplHandler.getMethod("getFingerprint", new Class[]{String.class, X509Certificate.class, Debug.class});
        if (static_getFingerprint_method != null) {
            useHighVersionStaticMethod = true;
        }
    }

    private static Method getMethod(String name, Class<?>[] parameterTypes) {
        Method method;
        block3: {
            method = null;
            try {
                method = X509CertImpl.class.getDeclaredMethod(name, parameterTypes);
                method.setAccessible(true);
                if (debug != null) {
                    String params = Arrays.toString(parameterTypes);
                    params = params.substring(1, params.length() - 1);
                    debug.println("Try get method (" + params + ") success");
                }
            }
            catch (NoSuchMethodException e) {
                if (debug == null) break block3;
                debug.println("NoSuchMethodException :" + e.getMessage());
            }
        }
        return method;
    }

    public static String getFingerprint(String algorithm, X509CertImpl cert) {
        if (nonStatic_getFingerprint_method == null) {
            throw new IllegalStateException("getFingerprint(String) or getFingerprint(String,Debug) method not found");
        }
        Object[] args2 = useHighVersionNoStaticMethod ? new Object[]{algorithm, certPathDebug} : new Object[]{algorithm};
        try {
            return (String)nonStatic_getFingerprint_method.invoke((Object)cert, args2);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            if (debug != null) {
                debug.println(e.getMessage());
            }
            return "";
        }
    }

    public static String getFingerprint(String algorithm, X509Certificate cert) {
        if (static_getFingerprint_method == null) {
            throw new IllegalStateException("getFingerprint(String,X509Certificate) or getFingerprint(String,X509Certificate,Debug) method not found");
        }
        Object[] args2 = useHighVersionStaticMethod ? new Object[]{algorithm, cert, certPathDebug} : new Object[]{algorithm, cert};
        try {
            return (String)static_getFingerprint_method.invoke(null, args2);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            if (debug != null) {
                debug.println(e.getMessage());
            }
            return "";
        }
    }

    static {
        X509CertImplHandler.init();
    }
}

