/*
 * Decompiled with CFR 0.152.
 */
package org.openeuler.sm4;

import java.util.Arrays;
import org.openeuler.sm4.SM4Util;

public class GMacUtil {
    private static SM4Util sm4 = new SM4Util();

    public static byte[] getCounter0(byte[] iv, byte[] H) {
        byte[] counter = null;
        if (iv.length == 12) {
            counter = new byte[16];
            for (int i = 0; i < iv.length; ++i) {
                counter[i] = iv[i];
            }
            counter[15] = 1;
        } else {
            int s = 16 - iv.length;
            counter = new byte[iv.length + s + 16];
            SM4Util.copyArray(iv, 0, iv.length, counter, 0);
            counter[counter.length - 1] = (byte)(iv.length * 8);
            counter = GMacUtil.GHASH(counter, H);
        }
        return counter;
    }

    public static byte[] GHASH(byte[] x, byte[] H) {
        byte[] y = new byte[16];
        for (int i = 0; i < x.length; i += 16) {
            y = sm4.xor(y, Arrays.copyOfRange(x, i, i + 16));
            y = GMacUtil.mult(y, H);
        }
        return y;
    }

    public static byte[] mult(byte[] x, byte[] y) {
        byte[] Z = new byte[16];
        byte[] V = new byte[16];
        byte[] R = new byte[16];
        R[0] = -31;
        SM4Util.copyArray(y, 0, y.length, V, 0);
        for (int i = 0; i < 128; ++i) {
            if ((x[i / 8] & 1 << 7 - i % 8) != 0) {
                Z = sm4.xor(Z, V);
            }
            V = (V[15] & 1) != 0 ? sm4.xor(GMacUtil.moveRightOneBit(V), R) : GMacUtil.moveRightOneBit(V);
        }
        return Z;
    }

    public static byte[] moveRightOneBit(byte[] input) {
        byte[] res = new byte[input.length];
        for (int i = 0; i < input.length; ++i) {
            boolean lsb;
            res[i] = (byte)(input[i] >> 1);
            if (i == 0) {
                int n = i;
                res[n] = (byte)(res[n] & 0x7F);
                continue;
            }
            boolean bl = lsb = (input[i - 1] & 1) == 1;
            if (lsb) {
                int n = i;
                res[n] = (byte)(res[n] | 0xFFFFFF80);
                continue;
            }
            int n = i;
            res[n] = (byte)(res[n] & 0x7F);
        }
        return res;
    }
}

