/*
 * Decompiled with CFR 0.152.
 */
package org.openeuler.sm4;

import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;
import org.openeuler.BGMJCEProvider;
import org.openeuler.sm4.SM4BaseCipher;
import org.openeuler.sm4.SM4Util;

public class StreamModeBaseCipher
extends SM4BaseCipher {
    protected byte[] iv;
    protected byte[] counter = new byte[16];

    @Override
    public void engineInit(int opmode, Key key, SecureRandom random) throws InvalidKeyException {
        try {
            this.engineInit(opmode, key, (AlgorithmParameterSpec)null, random);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new InvalidKeyException(e.getMessage());
        }
    }

    @Override
    public void engineInit(int opmode, Key key, AlgorithmParameters params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        IvParameterSpec spec = null;
        String paramType = null;
        if (params != null) {
            try {
                paramType = "IV";
                spec = params.getParameterSpec(IvParameterSpec.class);
            }
            catch (InvalidParameterSpecException e) {
                throw new InvalidAlgorithmParameterException("Wrong parameter type: " + paramType + " expected");
            }
        }
        this.engineInit(opmode, key, spec, random);
    }

    @Override
    public void engineInit(int opmode, Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        super.engineInit(opmode, key, params, random);
        if (params == null) {
            if (this.opmode == 1) {
                this.iv = new byte[16];
                if (random == null) {
                    random = BGMJCEProvider.getRandom();
                }
                random.nextBytes(this.iv);
            } else if (this.opmode == 2) {
                throw new InvalidAlgorithmParameterException("need an IV");
            }
        } else {
            if (!(params instanceof IvParameterSpec)) {
                throw new InvalidAlgorithmParameterException();
            }
            IvParameterSpec param = (IvParameterSpec)params;
            if (param.getIV().length != 16) {
                throw new InvalidAlgorithmParameterException("IV must be 16 bytes long.");
            }
            this.iv = param.getIV();
        }
        SM4Util.copyArray(this.iv, 0, this.iv.length, this.counter, 0);
        this.isInitialized = true;
    }

    @Override
    public byte[] engineDoFinal(byte[] input, int inputOffset, int inputLen) throws IllegalBlockSizeException, BadPaddingException {
        return null;
    }

    @Override
    public int engineDoFinal(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        return 0;
    }

    @Override
    public byte[] engineGetIV() {
        return this.iv;
    }

    @Override
    public AlgorithmParameters engineGetParameters() {
        AlgorithmParameters parameters = null;
        try {
            parameters = AlgorithmParameters.getInstance("SM4");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        try {
            parameters.init(new IvParameterSpec(this.iv));
        }
        catch (InvalidParameterSpecException e) {
            e.printStackTrace();
        }
        return parameters;
    }

    @Override
    public void reset() {
        super.reset();
    }
}

