/*
 * Decompiled with CFR 0.152.
 */
package org.openeuler.sm4.mode;

import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.IvParameterSpec;
import org.openeuler.BGMJCEProvider;
import org.openeuler.sm4.GMacUtil;
import org.openeuler.sm4.SM4Util;
import org.openeuler.sm4.StreamModeBaseCipher;

public class GCM
extends StreamModeBaseCipher {
    private byte[] T;
    private byte[] aad;
    private byte[] H;
    private byte[] g;
    private final int defaultIvLen = 12;
    private int tLen = 128;
    private byte[] counter0;
    private int aLen;
    private int cLen;
    private byte[] updateData;
    private boolean requireReinit;
    private byte[] lastEncIv;
    private byte[] lastEncKey;

    @Override
    public void engineInit(int opmode, Key key, SecureRandom random) throws InvalidKeyException {
        try {
            this.engineInit(opmode, key, (AlgorithmParameterSpec)null, random);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new InvalidKeyException(e.getMessage());
        }
    }

    @Override
    public void engineInit(int opmode, Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.init(opmode, key);
        if (params == null) {
            if (this.opmode == 1) {
                this.iv = new byte[12];
                if (random == null) {
                    random = BGMJCEProvider.getRandom();
                }
                random.nextBytes(this.iv);
            } else if (this.opmode == 2) {
                throw new InvalidAlgorithmParameterException("need an IV");
            }
        } else if (!(params instanceof GCMParameterSpec)) {
            if (!(params instanceof IvParameterSpec)) {
                throw new InvalidAlgorithmParameterException();
            }
            IvParameterSpec param = (IvParameterSpec)params;
            if (param.getIV() == null || param.getIV().length < 1) {
                throw new InvalidAlgorithmParameterException("IV at least 1 byte long.");
            }
            if (Arrays.equals(this.iv, param.getIV()) && opmode == 1) {
                throw new InvalidAlgorithmParameterException("cannot reuse nonce for GCM encryption");
            }
            this.iv = param.getIV();
        } else {
            GCMParameterSpec gcmParam = (GCMParameterSpec)params;
            this.checkTagLen(gcmParam);
            if (gcmParam.getIV() == null || gcmParam.getIV().length < 1) {
                throw new InvalidAlgorithmParameterException("IV at least 1 byte long.");
            }
            this.tLen = gcmParam.getTLen();
            this.iv = gcmParam.getIV();
        }
        if (this.opmode == 1) {
            byte[] keyBytes = key.getEncoded();
            boolean bl = this.requireReinit = Arrays.equals(this.iv, this.lastEncIv) && MessageDigest.isEqual(keyBytes, this.lastEncKey);
            if (this.requireReinit) {
                throw new InvalidAlgorithmParameterException("Cannot reuse iv for GCM encryption");
            }
            this.lastEncIv = this.iv;
            this.lastEncKey = keyBytes;
        }
        this.H = this.sm4.encrypt(this.rk, new byte[16], 0);
        this.counter0 = GMacUtil.getCounter0(this.iv, this.H);
        SM4Util.copyArray(this.counter0, 0, this.counter0.length, this.counter, 0);
        this.inc32();
        this.isInitialized = true;
        this.requireReinit = false;
    }

    @Override
    public void engineInit(int opmode, Key key, AlgorithmParameters params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        AlgorithmParameterSpec spec = null;
        String paramType = null;
        if (params != null) {
            try {
                paramType = "GCM or IV";
                spec = params.getParameterSpec(GCMParameterSpec.class);
            }
            catch (InvalidParameterSpecException e) {
                try {
                    spec = params.getParameterSpec(IvParameterSpec.class);
                }
                catch (InvalidParameterSpecException ex) {
                    throw new InvalidAlgorithmParameterException("Wrong parameter type: " + paramType + " expected");
                }
            }
        }
        this.engineInit(opmode, key, spec, random);
    }

    @Override
    public int engineGetOutputSize(int inputLen) {
        if (this.opmode == 1) {
            return inputLen + this.tLen / 8;
        }
        if (this.opmode == 2) {
            return inputLen - this.tLen / 8;
        }
        return 0;
    }

    @Override
    public AlgorithmParameters engineGetParameters() {
        AlgorithmParameters sm4Paraeters = null;
        try {
            sm4Paraeters = AlgorithmParameters.getInstance("SM4");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        try {
            sm4Paraeters.init(new GCMParameterSpec(this.tLen, this.iv));
        }
        catch (InvalidParameterSpecException e) {
            e.printStackTrace();
        }
        return sm4Paraeters;
    }

    @Override
    public void engineSetPadding(String padding) throws NoSuchPaddingException {
        if (!padding.toUpperCase().equals("NOPADDING")) {
            throw new NoSuchPaddingException("only nopadding can be used in this mode");
        }
        super.engineSetPadding(padding);
    }

    @Override
    public byte[] engineUpdate(byte[] input, int inputOffset, int inputLen) {
        if (!this.isInitialized) {
            throw new IllegalStateException("cipher uninitialized");
        }
        this.checkReinit();
        if (input == null || inputLen == 0) {
            return null;
        }
        this.inputUpdate = input;
        this.inputLenUpdate = inputLen;
        this.inputOffsetUpdate = inputOffset;
        byte[] res = null;
        if (this.opmode == 1) {
            this.len = inputLen - inputLen % 16;
            if (this.len == 0) {
                return null;
            }
        } else if (this.opmode == 2) {
            this.len = inputLen - this.tLen / 8;
            this.len -= this.len % 16;
            if (this.len <= 0) {
                this.len = 0;
                return null;
            }
        }
        this.cLen += this.len * 8;
        res = new byte[this.len];
        this.processGCM(input, inputOffset, this.len, res, 0);
        if (this.opmode == 1) {
            this.updateData = res;
        }
        return res;
    }

    @Override
    public int engineUpdate(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException {
        if (!this.isInitialized) {
            throw new IllegalStateException("cipher uninitialized");
        }
        this.checkReinit();
        byte[] res = this.engineUpdate(input, inputOffset, inputLen);
        if (res == null) {
            return 0;
        }
        if (res.length + outputOffset > output.length) {
            throw new ShortBufferException("buffer is too short");
        }
        SM4Util.copyArray(res, 0, res.length, output, outputOffset);
        return res.length;
    }

    @Override
    public int engineDoFinal(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        if (!this.isInitialized) {
            throw new IllegalStateException("cipher uninitialized");
        }
        this.checkReinit();
        int need = 0;
        int restLen = this.inputLenUpdate - this.len;
        if (this.opmode == 1) {
            int i;
            need = restLen + inputLen + this.tLen / 8;
            if (outputOffset + need > output.length) {
                throw new ShortBufferException();
            }
            boolean first = false;
            if (this.aad == null) {
                if (this.updateData == null) {
                    first = true;
                } else {
                    i = 0;
                    while (i + 16 <= this.updateData.length) {
                        if (i == 0) {
                            this.processG(Arrays.copyOfRange(this.updateData, i, i + 16), true);
                        } else {
                            this.processG(Arrays.copyOfRange(this.updateData, i, i + 16), false);
                        }
                        i += 16;
                    }
                }
            } else if (this.updateData != null) {
                i = 0;
                while (i + 16 <= this.updateData.length) {
                    this.processG(Arrays.copyOfRange(this.updateData, i, i + 16), false);
                    i += 16;
                }
            }
            if (restLen == 0) {
                this.encrypt(input, inputOffset, inputLen, output, outputOffset, first);
            } else {
                byte[] allInput = new byte[restLen + inputLen];
                SM4Util.copyArray(this.inputUpdate, this.inputOffsetUpdate + this.len, restLen, allInput, 0);
                SM4Util.copyArray(input, inputOffset, inputLen, allInput, restLen);
                this.encrypt(allInput, 0, allInput.length, output, outputOffset, first);
            }
        } else if (this.opmode == 2) {
            int i;
            if (restLen + inputLen < this.tLen / 8) {
                throw new IllegalBlockSizeException();
            }
            boolean first = false;
            if (this.aad == null) {
                if (this.len == 0) {
                    first = true;
                } else {
                    i = this.inputOffsetUpdate;
                    while (i + 16 <= this.len + this.inputOffsetUpdate) {
                        if (i == this.inputOffsetUpdate) {
                            this.processG(Arrays.copyOfRange(this.inputUpdate, i, i + 16), true);
                        } else {
                            this.processG(Arrays.copyOfRange(this.inputUpdate, i, i + 16), false);
                        }
                        i += 16;
                    }
                }
            } else if (this.len != 0) {
                i = this.inputOffsetUpdate;
                while (i + 16 <= this.len + this.inputOffsetUpdate) {
                    this.processG(Arrays.copyOfRange(this.inputUpdate, i, i + 16), false);
                    i += 16;
                }
            }
            if (restLen == 0) {
                need = inputLen - this.tLen / 8;
                if (outputOffset + need > output.length) {
                    throw new ShortBufferException();
                }
                this.decrypt(input, inputOffset, inputLen, output, outputOffset, first);
            } else {
                byte[] allInput = new byte[restLen + inputLen];
                need = inputLen + restLen - this.tLen / 8;
                if (outputOffset + need > output.length) {
                    throw new ShortBufferException();
                }
                SM4Util.copyArray(this.inputUpdate, this.inputOffsetUpdate + this.len, restLen, allInput, 0);
                SM4Util.copyArray(input, inputOffset, inputLen, allInput, restLen);
                this.decrypt(allInput, 0, allInput.length, output, outputOffset, first);
            }
        }
        this.reset();
        if (this.opmode == 1) {
            this.requireReinit = true;
        }
        return need;
    }

    @Override
    public byte[] engineDoFinal(byte[] input, int inputOffset, int inputLen) throws IllegalBlockSizeException, BadPaddingException {
        if (!this.isInitialized) {
            throw new IllegalStateException("cipher uninitialized");
        }
        this.checkReinit();
        int restLen = this.inputLenUpdate - this.len;
        byte[] res = null;
        if (this.opmode == 1) {
            int i;
            res = new byte[restLen + inputLen + this.tLen / 8];
            boolean first = false;
            if (this.aad == null) {
                if (this.updateData == null) {
                    first = true;
                } else {
                    i = 0;
                    while (i + 16 <= this.updateData.length) {
                        if (i == 0) {
                            this.processG(Arrays.copyOfRange(this.updateData, i, i + 16), true);
                        } else {
                            this.processG(Arrays.copyOfRange(this.updateData, i, i + 16), false);
                        }
                        i += 16;
                    }
                }
            } else if (this.updateData != null) {
                i = 0;
                while (i + 16 <= this.updateData.length) {
                    this.processG(Arrays.copyOfRange(this.updateData, i, i + 16), false);
                    i += 16;
                }
            }
            if (restLen == 0) {
                this.encrypt(input, inputOffset, inputLen, res, 0, first);
            } else {
                byte[] allInput = new byte[restLen + inputLen];
                SM4Util.copyArray(this.inputUpdate, this.inputOffsetUpdate + this.len, restLen, allInput, 0);
                SM4Util.copyArray(input, inputOffset, inputLen, allInput, restLen);
                this.encrypt(allInput, 0, allInput.length, res, 0, first);
            }
        } else if (this.opmode == 2) {
            int i;
            if (restLen + inputLen < this.tLen / 8) {
                throw new IllegalBlockSizeException();
            }
            boolean first = false;
            if (this.aad == null) {
                if (this.len == 0) {
                    first = true;
                } else {
                    i = this.inputOffsetUpdate;
                    while (i + 16 <= this.len + this.inputOffsetUpdate) {
                        if (i == this.inputOffsetUpdate) {
                            this.processG(Arrays.copyOfRange(this.inputUpdate, i, i + 16), true);
                        } else {
                            this.processG(Arrays.copyOfRange(this.inputUpdate, i, i + 16), false);
                        }
                        i += 16;
                    }
                }
            } else if (this.len != 0) {
                i = this.inputOffsetUpdate;
                while (i + 16 <= this.len + this.inputOffsetUpdate) {
                    this.processG(Arrays.copyOfRange(this.inputUpdate, i, i + 16), false);
                    i += 16;
                }
            }
            if (restLen == 0) {
                res = new byte[inputLen - this.tLen / 8];
                this.decrypt(input, inputOffset, inputLen, res, 0, first);
            } else {
                byte[] allInput = new byte[restLen + inputLen];
                res = new byte[inputLen + restLen - this.tLen / 8];
                SM4Util.copyArray(this.inputUpdate, this.inputOffsetUpdate + this.len, restLen, allInput, 0);
                SM4Util.copyArray(input, inputOffset, inputLen, allInput, restLen);
                this.decrypt(allInput, 0, allInput.length, res, 0, first);
            }
        }
        this.reset();
        if (this.opmode == 1) {
            this.requireReinit = true;
        }
        return res;
    }

    @Override
    protected void engineUpdateAAD(byte[] src, int offset, int len) {
        if (!this.isInitialized) {
            throw new IllegalStateException("cipher uninitiallized");
        }
        this.aLen = len;
        this.aad = new byte[len];
        SM4Util.copyArray(src, offset, len, this.aad, 0);
        this.processG(this.aad, true);
    }

    private boolean checkTagLen(GCMParameterSpec spec) throws InvalidAlgorithmParameterException {
        int len = spec.getTLen();
        if (len != 96 && len != 104 && len != 112 && len != 120 && len != 128) {
            throw new InvalidAlgorithmParameterException("invalid mac size " + len);
        }
        return true;
    }

    private boolean checkMac(byte[] T, byte[] _T) {
        if (!Arrays.equals(T, _T)) {
            throw new RuntimeException("mac check in GCM failed");
        }
        return true;
    }

    private void processGCM(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) {
        int i = inputOffset;
        while (i + 16 <= inputLen + inputOffset) {
            byte[] encrypt = this.sm4.encrypt(this.rk, this.counter, 0);
            this.inc32();
            byte[] xor = this.sm4.xor(encrypt, 0, 16, input, i, 16);
            SM4Util.copyArray(xor, 0, xor.length, output, outputOffset + i - inputOffset);
            i += 16;
        }
    }

    private void encrypt(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset, boolean first) {
        if (inputLen == 0) {
            byte[] AC = new byte[16];
            this.aLen *= 8;
            this.sm4.intToBigEndian(AC, this.aLen, 4);
            this.sm4.intToBigEndian(AC, this.cLen, 12);
            byte[] encrypt0 = this.sm4.encrypt(this.rk, this.counter0, 0);
            if (this.aad == null && this.updateData == null) {
                this.processG(AC, true);
            } else {
                this.processG(AC, false);
            }
            this.T = this.sm4.xor16Byte(this.g, encrypt0);
            SM4Util.copyArray(this.T, 0, this.tLen / 8, output, outputOffset + inputLen);
        } else if (inputLen < 16) {
            byte[] xor = null;
            byte[] encrypt = this.sm4.encrypt(this.rk, this.counter, 0);
            this.inc32();
            xor = this.sm4.xor(encrypt, 0, 16, input, inputOffset, inputLen);
            this.processG(xor, first);
            byte[] AC = new byte[16];
            this.aLen *= 8;
            this.cLen += xor.length * 8;
            this.sm4.intToBigEndian(AC, this.aLen, 4);
            this.sm4.intToBigEndian(AC, this.cLen, 12);
            byte[] encrypt0 = this.sm4.encrypt(this.rk, this.counter0, 0);
            this.processG(AC, false);
            this.T = this.sm4.xor16Byte(this.g, encrypt0);
            SM4Util.copyArray(xor, 0, xor.length, output, outputOffset);
            SM4Util.copyArray(this.T, 0, this.tLen / 8, output, outputOffset + inputLen);
        } else {
            int i = inputOffset;
            while (i + 16 <= inputLen + inputOffset) {
                byte[] encrypt = null;
                byte[] xor = null;
                encrypt = this.sm4.encrypt(this.rk, this.counter, 0);
                this.inc32();
                xor = this.sm4.xor(encrypt, 0, 16, input, i, 16);
                if (i == inputOffset) {
                    this.processG(xor, first);
                } else {
                    this.processG(xor, false);
                }
                SM4Util.copyArray(xor, 0, xor.length, output, outputOffset + i - inputOffset);
                if (inputLen % 16 == 0 && i + 16 >= inputLen + inputOffset) {
                    byte[] AC = new byte[16];
                    this.aLen *= 8;
                    this.cLen += inputLen * 8;
                    this.sm4.intToBigEndian(AC, this.aLen, 4);
                    this.sm4.intToBigEndian(AC, this.cLen, 12);
                    byte[] encrypt0 = this.sm4.encrypt(this.rk, this.counter0, 0);
                    this.processG(AC, false);
                    this.T = this.sm4.xor16Byte(this.g, encrypt0);
                    SM4Util.copyArray(this.T, 0, this.tLen / 8, output, outputOffset + inputLen);
                }
                i += 16;
            }
            if (inputLen % 16 != 0) {
                byte[] encrypt = this.sm4.encrypt(this.rk, this.counter, 0);
                this.inc32();
                byte[] xor = this.sm4.xor(encrypt, 0, 16, input, inputLen + inputOffset - inputLen % 16, inputLen % 16);
                SM4Util.copyArray(xor, 0, xor.length, output, outputOffset + inputLen - inputLen % 16);
                this.processG(xor, false);
                byte[] AC = new byte[16];
                this.aLen *= 8;
                this.cLen += inputLen * 8;
                this.sm4.intToBigEndian(AC, this.aLen, 4);
                this.sm4.intToBigEndian(AC, this.cLen, 12);
                byte[] encrypt0 = this.sm4.encrypt(this.rk, this.counter0, 0);
                this.processG(AC, false);
                this.T = this.sm4.xor16Byte(this.g, encrypt0);
                SM4Util.copyArray(this.T, 0, this.tLen / 8, output, outputOffset + inputLen);
            }
        }
    }

    private void decrypt(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset, boolean first) {
        if (inputLen - this.tLen / 8 < 16) {
            byte[] cipher = Arrays.copyOfRange(input, inputOffset, inputOffset + inputLen - this.tLen / 8);
            byte[] _T = Arrays.copyOfRange(input, inputOffset + inputLen - this.tLen / 8, inputOffset + inputLen);
            if (cipher.length > 0) {
                this.processG(cipher, first);
            }
            byte[] AC = new byte[16];
            this.aLen *= 8;
            this.cLen += cipher.length * 8;
            this.sm4.intToBigEndian(AC, this.aLen, 4);
            this.sm4.intToBigEndian(AC, this.cLen, 12);
            byte[] encrypt0 = this.sm4.encrypt(this.rk, this.counter0, 0);
            this.processG(AC, false);
            this.T = this.sm4.xor16Byte(this.g, encrypt0);
            this.T = Arrays.copyOfRange(this.T, 0, _T.length);
            this.checkMac(this.T, _T);
            byte[] encrypt = this.sm4.encrypt(this.rk, this.counter, 0);
            this.inc32();
            byte[] xor = this.sm4.xor(encrypt, cipher);
            SM4Util.copyArray(xor, 0, xor.length, output, outputOffset);
        } else {
            byte[] cipherText = Arrays.copyOfRange(input, inputOffset, inputOffset + inputLen - this.tLen / 8);
            byte[] _T = Arrays.copyOfRange(input, inputOffset + inputLen - this.tLen / 8, inputLen + inputOffset);
            int i = 0;
            while (i + 16 <= cipherText.length) {
                byte[] curBlock = Arrays.copyOfRange(cipherText, i, i + 16);
                byte[] encrypt = null;
                byte[] xor = null;
                encrypt = this.sm4.encrypt(this.rk, this.counter, 0);
                this.inc32();
                if (i == 0) {
                    this.processG(curBlock, first);
                } else {
                    this.processG(curBlock, false);
                }
                xor = this.sm4.xor(encrypt, curBlock);
                SM4Util.copyArray(xor, 0, xor.length, output, outputOffset + i);
                if (cipherText.length % 16 == 0 && i + 16 >= cipherText.length) {
                    byte[] AC = new byte[16];
                    this.aLen *= 8;
                    this.cLen += cipherText.length * 8;
                    this.sm4.intToBigEndian(AC, this.aLen, 4);
                    this.sm4.intToBigEndian(AC, this.cLen, 12);
                    byte[] encrypt0 = this.sm4.encrypt(this.rk, this.counter0, 0);
                    this.processG(AC, false);
                    this.T = this.sm4.xor16Byte(this.g, encrypt0);
                    this.T = Arrays.copyOfRange(this.T, 0, _T.length);
                    this.checkMac(this.T, _T);
                }
                i += 16;
            }
            if (cipherText.length % 16 != 0) {
                byte[] curBlock = Arrays.copyOfRange(cipherText, cipherText.length - cipherText.length % 16, cipherText.length);
                byte[] encrypt = this.sm4.encrypt(this.rk, this.counter, 0);
                this.inc32();
                byte[] xor = this.sm4.xor(encrypt, curBlock);
                SM4Util.copyArray(xor, 0, xor.length, output, outputOffset + inputLen - this.tLen / 8 - cipherText.length % 16);
                this.processG(curBlock, false);
                byte[] AC = new byte[16];
                this.aLen *= 8;
                this.cLen += (inputLen - this.tLen / 8) * 8;
                this.sm4.intToBigEndian(AC, this.aLen, 4);
                this.sm4.intToBigEndian(AC, this.cLen, 12);
                byte[] encrypt0 = this.sm4.encrypt(this.rk, this.counter0, 0);
                this.processG(AC, false);
                this.T = this.sm4.xor16Byte(this.g, encrypt0);
                this.T = Arrays.copyOfRange(this.T, 0, _T.length);
                this.checkMac(this.T, _T);
            }
        }
    }

    private void inc32() {
        int r;
        for (r = this.counter.length - 1; r >= 12; --r) {
            try {
                this.counter[r] = this.increment(r);
                break;
            }
            catch (Exception e) {
                continue;
            }
        }
        if (r == 11) {
            for (int i = 12; i < this.counter.length; ++i) {
                this.counter[i] = 0;
            }
        }
    }

    private byte increment(int index) throws Exception {
        int i;
        for (i = 0; i < 8 && (1 << i & this.counter[index]) != 0; ++i) {
        }
        if (i == 8) {
            throw new Exception();
        }
        this.counter[index] = (byte)(1 << i | this.counter[index]);
        int t = 0;
        for (int j = 7; j >= i; --j) {
            t |= 1 << j;
        }
        for (int k = index + 1; k < this.counter.length; ++k) {
            this.counter[k] = 0;
        }
        return (byte)(t & this.counter[index]);
    }

    private void processG(byte[] cipherText, boolean first) {
        byte[] arr;
        if (cipherText.length < 16) {
            arr = new byte[16];
            SM4Util.copyArray(cipherText, 0, cipherText.length, arr, 0);
            cipherText = arr;
        }
        if (first) {
            if (cipherText.length > 16) {
                arr = null;
                if (cipherText.length % 16 != 0) {
                    arr = new byte[cipherText.length + 16 - cipherText.length % 16];
                    SM4Util.copyArray(cipherText, 0, cipherText.length, arr, 0);
                } else {
                    arr = cipherText;
                }
                int i = 0;
                while (i + 16 <= arr.length) {
                    if (i == 0) {
                        this.g = GMacUtil.mult(this.H, Arrays.copyOfRange(arr, i, i + 16));
                    } else {
                        this.g = this.sm4.xor16Byte(this.g, Arrays.copyOfRange(arr, i, i + 16));
                        this.g = GMacUtil.mult(this.g, this.H);
                    }
                    i += 16;
                }
            } else {
                this.g = GMacUtil.mult(this.H, cipherText);
            }
        } else {
            this.g = this.sm4.xor16Byte(this.g, cipherText);
            this.g = GMacUtil.mult(this.g, this.H);
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.T = null;
        this.aad = null;
        this.cLen = 0;
        this.aLen = 0;
        this.g = null;
        this.updateData = null;
        if (this.opmode == 2) {
            this.H = this.sm4.encrypt(this.rk, new byte[16], 0);
            this.counter0 = GMacUtil.getCounter0(this.iv, this.H);
            SM4Util.copyArray(this.counter0, 0, this.counter0.length, this.counter, 0);
            this.inc32();
        }
    }

    private void checkReinit() {
        if (this.requireReinit) {
            throw new IllegalStateException("Must use either different key or iv for GCM encryption");
        }
    }
}

