/*
 * Decompiled with CFR 0.152.
 */
package org.openeuler.sm4.mode;

import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.ShortBufferException;
import org.openeuler.sm4.SM4Util;
import org.openeuler.sm4.StreamModeBaseCipher;

public class OFB
extends StreamModeBaseCipher {
    @Override
    public byte[] engineUpdate(byte[] input, int inputOffset, int inputLen) {
        if (!this.isInitialized) {
            throw new IllegalStateException("cipher uninitialized");
        }
        if (input == null || inputLen == 0) {
            return null;
        }
        this.inputUpdate = input;
        this.inputLenUpdate = inputLen;
        this.inputOffsetUpdate = inputOffset;
        byte[] res = null;
        if (this.padding.getPadding().toUpperCase().equals("NOPADDING")) {
            if (inputLen < 16) {
                this.len = 0;
                return null;
            }
            this.len = inputLen - inputLen % 16;
        } else {
            if (inputLen <= 16) {
                this.len = 0;
                return null;
            }
            this.len = inputLen % 16 == 0 ? inputLen - 16 : inputLen - inputLen % 16;
        }
        res = new byte[this.len];
        this.processOFB(input, inputOffset, this.len, res, 0);
        return res;
    }

    @Override
    public int engineUpdate(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException {
        if (!this.isInitialized) {
            throw new IllegalStateException("cipher uninitialized");
        }
        if (input == null || inputLen == 0) {
            return 0;
        }
        this.inputUpdate = input;
        this.inputLenUpdate = inputLen;
        this.inputOffsetUpdate = inputOffset;
        if (this.padding.getPadding().toUpperCase().equals("NOPADDING")) {
            if (inputLen < 16) {
                this.len = 0;
                return 0;
            }
            this.len = inputLen - inputLen % 16;
        } else {
            if (inputLen <= 16) {
                this.len = 0;
                return 0;
            }
            this.len = inputLen % 16 == 0 ? inputLen - 16 : inputLen - inputLen % 16;
        }
        if (outputOffset + this.len > output.length) {
            throw new ShortBufferException();
        }
        this.processOFB(input, inputOffset, this.len, output, outputOffset);
        return this.len;
    }

    @Override
    public byte[] engineDoFinal(byte[] input, int inputOffset, int inputLen) throws IllegalBlockSizeException, BadPaddingException {
        if (!this.isInitialized) {
            throw new IllegalStateException("cipher uninitialized");
        }
        byte[] res = null;
        int restLen = this.inputLenUpdate - this.len;
        if (this.opmode == 1) {
            if (this.padding.getPadding().toUpperCase().equals("NOPADDING") && (this.inputLenUpdate - this.len + inputLen) % 16 != 0) {
                throw new IllegalBlockSizeException();
            }
            int length = this.engineGetOutputSize(this.inputLenUpdate - this.len + inputLen);
            res = new byte[length];
            if (restLen == 0) {
                this.encrypt(input, inputOffset, inputLen, res, 0);
            } else if (restLen == 16) {
                this.processOFB(this.inputUpdate, this.inputOffsetUpdate + this.inputLenUpdate - 16, 16, res, 0);
                this.encrypt(input, inputOffset, inputLen, res, 16);
            } else if (16 - restLen > inputLen) {
                byte[] block = new byte[inputLen + restLen];
                SM4Util.copyArray(this.inputUpdate, this.inputOffsetUpdate + this.len, restLen, block, 0);
                SM4Util.copyArray(input, inputOffset, inputLen, block, restLen);
                this.encrypt(block, 0, block.length, res, 0);
            } else {
                byte[] block = new byte[16];
                SM4Util.copyArray(this.inputUpdate, this.inputOffsetUpdate + this.len, restLen, block, 0);
                SM4Util.copyArray(input, inputOffset, 16 - restLen, block, restLen);
                this.processOFB(block, 0, 16, res, 0);
                this.encrypt(input, inputOffset + 16 - restLen, inputLen - 16 + restLen, res, 16);
            }
        } else if (this.opmode == 2) {
            if ((inputLen + this.inputLenUpdate - this.len) % 16 != 0) {
                throw new IllegalBlockSizeException();
            }
            byte[] tem = new byte[inputLen + this.inputLenUpdate - this.len];
            if (restLen == 0) {
                if (inputLen == 0) {
                    this.reset();
                    return res;
                }
                this.processOFB(input, inputOffset, inputLen, tem, 0);
            } else if (restLen == 16) {
                if (inputLen == 0) {
                    this.processOFB(this.inputUpdate, this.inputOffsetUpdate + this.inputLenUpdate - 16, 16, tem, 0);
                } else {
                    this.processOFB(this.inputUpdate, this.inputOffsetUpdate + this.len, 16, tem, 0);
                    this.processOFB(input, inputOffset, inputLen, tem, 16);
                }
            } else {
                byte[] block = new byte[16];
                SM4Util.copyArray(this.inputUpdate, this.inputOffsetUpdate + this.len, restLen, block, 0);
                SM4Util.copyArray(input, inputOffset, 16 - restLen, block, restLen);
                if (inputLen == 16 - restLen) {
                    this.processOFB(block, 0, 16, tem, 0);
                } else {
                    this.processOFB(block, 0, 16, tem, 0);
                    this.processOFB(input, inputOffset + 16 - restLen, inputLen - 16 + restLen, tem, 16);
                }
            }
            res = this.padding.getPadding().toUpperCase().equals("NOPADDING") ? tem : this.padding.recover(tem);
        }
        this.reset();
        return res;
    }

    @Override
    public int engineDoFinal(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        if (!this.isInitialized) {
            throw new IllegalStateException("cipher uninitialized");
        }
        byte[] bytes = this.engineDoFinal(input, inputOffset, inputLen);
        if (bytes != null) {
            if (outputOffset + bytes.length > output.length) {
                throw new ShortBufferException("buffer is too short.");
            }
            SM4Util.copyArray(bytes, 0, bytes.length, output, outputOffset);
            return bytes.length;
        }
        return 0;
    }

    private void processOFB(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) {
        int i = inputOffset;
        while (i + 16 <= inputLen + inputOffset) {
            this.counter = this.sm4.encrypt(this.rk, this.counter, 0);
            byte[] xor = this.sm4.xor(this.counter, 0, 16, input, i, 16);
            SM4Util.copyArray(xor, 0, xor.length, output, outputOffset + i - inputOffset);
            i += 16;
        }
    }

    private void encrypt(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) {
        byte[] xor;
        int i = inputOffset;
        while (i + 16 <= inputLen + inputOffset) {
            this.counter = this.sm4.encrypt(this.rk, this.counter, 0);
            byte[] xor2 = this.sm4.xor(this.counter, 0, 16, input, i, 16);
            SM4Util.copyArray(xor2, 0, xor2.length, output, outputOffset + i - inputOffset);
            i += 16;
        }
        if (inputLen % 16 != 0) {
            byte[] fill = this.padding.fill(input, i, inputLen % 16);
            this.counter = this.sm4.encrypt(this.rk, this.counter, 0);
            xor = this.sm4.xor(this.counter, fill);
            SM4Util.copyArray(xor, 0, xor.length, output, outputOffset + i - inputOffset);
        }
        if (inputLen % 16 == 0 && !this.padding.getPadding().toUpperCase().equals("NOPADDING")) {
            byte[] block = new byte[16];
            Arrays.fill(block, (byte)16);
            this.counter = this.sm4.encrypt(this.rk, this.counter, 0);
            xor = this.sm4.xor(this.counter, block);
            SM4Util.copyArray(xor, 0, xor.length, output, outputOffset + i - inputOffset);
        }
    }

    @Override
    public void reset() {
        this.inputUpdate = null;
        this.inputLenUpdate = 0;
        this.len = 0;
        SM4Util.copyArray(this.iv, 0, this.iv.length, this.counter, 0);
    }
}

