/*
 * Decompiled with CFR 0.152.
 */
package org.openeuler.sun.security.ssl;

import java.io.IOException;
import java.security.AlgorithmConstraints;
import java.security.CryptoPrimitive;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.interfaces.ECPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;
import java.util.EnumSet;
import javax.crypto.KeyAgreement;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import javax.net.ssl.SSLHandshakeException;
import org.openeuler.sun.security.ssl.Alert;
import org.openeuler.sun.security.ssl.CipherSuite;
import org.openeuler.sun.security.ssl.ClientHandshakeContext;
import org.openeuler.sun.security.ssl.HKDF;
import org.openeuler.sun.security.ssl.HandshakeContext;
import org.openeuler.sun.security.ssl.JsseJce;
import org.openeuler.sun.security.ssl.SSLCredentials;
import org.openeuler.sun.security.ssl.SSLKeyAgreementGenerator;
import org.openeuler.sun.security.ssl.SSLKeyDerivation;
import org.openeuler.sun.security.ssl.SSLMasterKeyDerivation;
import org.openeuler.sun.security.ssl.SSLPossession;
import org.openeuler.sun.security.ssl.SSLPossessionGenerator;
import org.openeuler.sun.security.ssl.SSLSecretDerivation;
import org.openeuler.sun.security.ssl.ServerHandshakeContext;
import org.openeuler.sun.security.ssl.SupportedGroupsExtension;
import org.openeuler.sun.security.ssl.X509Authentication;
import sun.security.util.ECUtil;

final class ECDHKeyExchange {
    static final SSLPossessionGenerator poGenerator = new ECDHEPossessionGenerator();
    static final SSLKeyAgreementGenerator ecdheKAGenerator = new ECDHEKAGenerator();
    static final SSLKeyAgreementGenerator ecdhKAGenerator = new ECDHKAGenerator();

    ECDHKeyExchange() {
    }

    private static final class ECDHEKAKeyDerivation
    implements SSLKeyDerivation {
        private final HandshakeContext context;
        private final PrivateKey localPrivateKey;
        private final PublicKey peerPublicKey;

        ECDHEKAKeyDerivation(HandshakeContext context, PrivateKey localPrivateKey, PublicKey peerPublicKey) {
            this.context = context;
            this.localPrivateKey = localPrivateKey;
            this.peerPublicKey = peerPublicKey;
        }

        @Override
        public SecretKey deriveKey(String algorithm, AlgorithmParameterSpec params) throws IOException {
            if (!this.context.negotiatedProtocol.useTLS13PlusSpec()) {
                return this.t12DeriveKey(algorithm, params);
            }
            return this.t13DeriveKey(algorithm, params);
        }

        private SecretKey t12DeriveKey(String algorithm, AlgorithmParameterSpec params) throws IOException {
            try {
                KeyAgreement ka = JsseJce.getKeyAgreement("ECDH");
                ka.init(this.localPrivateKey);
                ka.doPhase(this.peerPublicKey, true);
                SecretKey preMasterSecret = ka.generateSecret("TlsPremasterSecret");
                SSLMasterKeyDerivation mskd = SSLMasterKeyDerivation.valueOf(this.context.negotiatedProtocol);
                if (mskd == null) {
                    throw new SSLHandshakeException("No expected master key derivation for protocol: " + this.context.negotiatedProtocol.name);
                }
                SSLKeyDerivation kd = mskd.createKeyDerivation(this.context, preMasterSecret);
                return kd.deriveKey("MasterSecret", params);
            }
            catch (GeneralSecurityException gse) {
                throw (SSLHandshakeException)new SSLHandshakeException("Could not generate secret").initCause(gse);
            }
        }

        private SecretKey t13DeriveKey(String algorithm, AlgorithmParameterSpec params) throws IOException {
            try {
                KeyAgreement ka = JsseJce.getKeyAgreement("ECDH");
                ka.init(this.localPrivateKey);
                ka.doPhase(this.peerPublicKey, true);
                SecretKey sharedSecret = ka.generateSecret("TlsPremasterSecret");
                CipherSuite.HashAlg hashAlg = this.context.negotiatedCipherSuite.hashAlg;
                SSLKeyDerivation kd = this.context.handshakeKeyDerivation;
                HKDF hkdf = new HKDF(hashAlg.name);
                if (kd == null) {
                    byte[] zeros = new byte[hashAlg.hashLength];
                    SecretKeySpec ikm = new SecretKeySpec(zeros, "TlsPreSharedSecret");
                    SecretKey earlySecret = hkdf.extract(zeros, (SecretKey)ikm, "TlsEarlySecret");
                    kd = new SSLSecretDerivation(this.context, earlySecret);
                }
                SecretKey saltSecret = kd.deriveKey("TlsSaltSecret", null);
                return hkdf.extract(saltSecret, sharedSecret, algorithm);
            }
            catch (GeneralSecurityException gse) {
                throw (SSLHandshakeException)new SSLHandshakeException("Could not generate secret").initCause(gse);
            }
        }
    }

    private static final class ECDHEKAGenerator
    implements SSLKeyAgreementGenerator {
        private ECDHEKAGenerator() {
        }

        @Override
        public SSLKeyDerivation createKeyDerivation(HandshakeContext context) throws IOException {
            ECDHEPossession ecdhePossession = null;
            ECDHECredentials ecdheCredentials = null;
            for (SSLPossession poss : context.handshakePossessions) {
                if (!(poss instanceof ECDHEPossession)) continue;
                SupportedGroupsExtension.NamedGroup ng = ((ECDHEPossession)poss).namedGroup;
                for (SSLCredentials cred : context.handshakeCredentials) {
                    if (!(cred instanceof ECDHECredentials) || !ng.equals((Object)((ECDHECredentials)cred).namedGroup)) continue;
                    ecdheCredentials = (ECDHECredentials)cred;
                    break;
                }
                if (ecdheCredentials == null) continue;
                ecdhePossession = (ECDHEPossession)poss;
                break;
            }
            if (ecdhePossession == null || ecdheCredentials == null) {
                throw context.conContext.fatal(Alert.HANDSHAKE_FAILURE, "No sufficient ECDHE key agreement parameters negotiated");
            }
            return new ECDHEKAKeyDerivation(context, ecdhePossession.privateKey, ecdheCredentials.popPublicKey);
        }
    }

    private static final class ECDHKAGenerator
    implements SSLKeyAgreementGenerator {
        private ECDHKAGenerator() {
        }

        @Override
        public SSLKeyDerivation createKeyDerivation(HandshakeContext context) throws IOException {
            if (context instanceof ServerHandshakeContext) {
                return this.createServerKeyDerivation((ServerHandshakeContext)context);
            }
            return this.createClientKeyDerivation((ClientHandshakeContext)context);
        }

        private SSLKeyDerivation createServerKeyDerivation(ServerHandshakeContext shc) throws IOException {
            X509Authentication.X509Possession x509Possession = null;
            ECDHECredentials ecdheCredentials = null;
            for (SSLPossession poss : shc.handshakePossessions) {
                ECParameterSpec params;
                if (!(poss instanceof X509Authentication.X509Possession) || (params = ((X509Authentication.X509Possession)poss).getECParameterSpec()) == null) continue;
                SupportedGroupsExtension.NamedGroup ng = SupportedGroupsExtension.NamedGroup.valueOf(params);
                if (ng == null) {
                    throw shc.conContext.fatal(Alert.ILLEGAL_PARAMETER, "Unsupported EC server cert for ECDH key exchange");
                }
                for (SSLCredentials cred : shc.handshakeCredentials) {
                    if (!(cred instanceof ECDHECredentials) || !ng.equals((Object)((ECDHECredentials)cred).namedGroup)) continue;
                    ecdheCredentials = (ECDHECredentials)cred;
                    break;
                }
                if (ecdheCredentials == null) continue;
                x509Possession = (X509Authentication.X509Possession)poss;
                break;
            }
            if (x509Possession == null || ecdheCredentials == null) {
                throw shc.conContext.fatal(Alert.HANDSHAKE_FAILURE, "No sufficient ECDHE key agreement parameters negotiated");
            }
            return new ECDHEKAKeyDerivation(shc, x509Possession.popPrivateKey, ecdheCredentials.popPublicKey);
        }

        private SSLKeyDerivation createClientKeyDerivation(ClientHandshakeContext chc) throws IOException {
            ECDHEPossession ecdhePossession = null;
            X509Authentication.X509Credentials x509Credentials = null;
            for (SSLPossession poss : chc.handshakePossessions) {
                if (!(poss instanceof ECDHEPossession)) continue;
                SupportedGroupsExtension.NamedGroup ng = ((ECDHEPossession)poss).namedGroup;
                for (SSLCredentials cred : chc.handshakeCredentials) {
                    PublicKey publicKey;
                    if (!(cred instanceof X509Authentication.X509Credentials) || !(publicKey = ((X509Authentication.X509Credentials)cred).popPublicKey).getAlgorithm().equals("EC")) continue;
                    ECParameterSpec params = ((ECPublicKey)publicKey).getParams();
                    SupportedGroupsExtension.NamedGroup namedGroup = SupportedGroupsExtension.NamedGroup.valueOf(params);
                    if (namedGroup == null) {
                        throw chc.conContext.fatal(Alert.ILLEGAL_PARAMETER, "Unsupported EC server cert for ECDH key exchange");
                    }
                    if (!ng.equals((Object)namedGroup)) continue;
                    x509Credentials = (X509Authentication.X509Credentials)cred;
                    break;
                }
                if (x509Credentials == null) continue;
                ecdhePossession = (ECDHEPossession)poss;
                break;
            }
            if (ecdhePossession == null || x509Credentials == null) {
                throw chc.conContext.fatal(Alert.HANDSHAKE_FAILURE, "No sufficient ECDH key agreement parameters negotiated");
            }
            return new ECDHEKAKeyDerivation(chc, ecdhePossession.privateKey, x509Credentials.popPublicKey);
        }
    }

    private static final class ECDHEPossessionGenerator
    implements SSLPossessionGenerator {
        private ECDHEPossessionGenerator() {
        }

        @Override
        public SSLPossession createPossession(HandshakeContext context) {
            SupportedGroupsExtension.NamedGroup preferableNamedGroup = null;
            preferableNamedGroup = context.clientRequestedNamedGroups != null && !context.clientRequestedNamedGroups.isEmpty() ? SupportedGroupsExtension.SupportedGroups.getPreferredGroup(context.negotiatedProtocol, context.algorithmConstraints, SupportedGroupsExtension.NamedGroupType.NAMED_GROUP_ECDHE, context.clientRequestedNamedGroups) : SupportedGroupsExtension.SupportedGroups.getPreferredGroup(context.negotiatedProtocol, context.algorithmConstraints, SupportedGroupsExtension.NamedGroupType.NAMED_GROUP_ECDHE);
            if (preferableNamedGroup != null) {
                return new ECDHEPossession(preferableNamedGroup, context.sslContext.getSecureRandom());
            }
            return null;
        }
    }

    static final class ECDHEPossession
    implements SSLPossession {
        final PrivateKey privateKey;
        final ECPublicKey publicKey;
        final SupportedGroupsExtension.NamedGroup namedGroup;

        ECDHEPossession(SupportedGroupsExtension.NamedGroup namedGroup, SecureRandom random) {
            try {
                KeyPairGenerator kpg = JsseJce.getKeyPairGenerator("EC");
                ECGenParameterSpec params = (ECGenParameterSpec)namedGroup.getParameterSpec();
                kpg.initialize(params, random);
                KeyPair kp = kpg.generateKeyPair();
                this.privateKey = kp.getPrivate();
                this.publicKey = (ECPublicKey)kp.getPublic();
            }
            catch (GeneralSecurityException e) {
                throw new RuntimeException("Could not generate ECDH keypair", e);
            }
            this.namedGroup = namedGroup;
        }

        ECDHEPossession(ECDHECredentials credentials, SecureRandom random) {
            ECParameterSpec params = credentials.popPublicKey.getParams();
            try {
                KeyPairGenerator kpg = JsseJce.getKeyPairGenerator("EC");
                kpg.initialize(params, random);
                KeyPair kp = kpg.generateKeyPair();
                this.privateKey = kp.getPrivate();
                this.publicKey = (ECPublicKey)kp.getPublic();
            }
            catch (GeneralSecurityException e) {
                throw new RuntimeException("Could not generate ECDH keypair", e);
            }
            this.namedGroup = credentials.namedGroup;
        }

        @Override
        public byte[] encode() {
            return ECUtil.encodePoint(this.publicKey.getW(), this.publicKey.getParams().getCurve());
        }

        SecretKey getAgreedSecret(PublicKey peerPublicKey) throws SSLHandshakeException {
            try {
                KeyAgreement ka = JsseJce.getKeyAgreement("ECDH");
                ka.init(this.privateKey);
                ka.doPhase(peerPublicKey, true);
                return ka.generateSecret("TlsPremasterSecret");
            }
            catch (GeneralSecurityException e) {
                throw (SSLHandshakeException)new SSLHandshakeException("Could not generate secret").initCause(e);
            }
        }

        SecretKey getAgreedSecret(byte[] encodedPoint) throws SSLHandshakeException {
            try {
                ECParameterSpec params = this.publicKey.getParams();
                ECPoint point = JsseJce.decodePoint(encodedPoint, params.getCurve());
                KeyFactory kf = JsseJce.getKeyFactory("EC");
                ECPublicKeySpec spec = new ECPublicKeySpec(point, params);
                PublicKey peerPublicKey = kf.generatePublic(spec);
                return this.getAgreedSecret(peerPublicKey);
            }
            catch (IOException | GeneralSecurityException e) {
                throw (SSLHandshakeException)new SSLHandshakeException("Could not generate secret").initCause(e);
            }
        }

        void checkConstraints(AlgorithmConstraints constraints, byte[] encodedPoint) throws SSLHandshakeException {
            try {
                ECParameterSpec params = this.publicKey.getParams();
                ECPoint point = JsseJce.decodePoint(encodedPoint, params.getCurve());
                ECPublicKeySpec spec = new ECPublicKeySpec(point, params);
                KeyFactory kf = JsseJce.getKeyFactory("EC");
                ECPublicKey pubKey = (ECPublicKey)kf.generatePublic(spec);
                if (!constraints.permits(EnumSet.of(CryptoPrimitive.KEY_AGREEMENT), pubKey)) {
                    throw new SSLHandshakeException("ECPublicKey does not comply to algorithm constraints");
                }
            }
            catch (IOException | GeneralSecurityException e) {
                throw (SSLHandshakeException)new SSLHandshakeException("Could not generate ECPublicKey").initCause(e);
            }
        }
    }

    static final class ECDHECredentials
    implements SSLCredentials {
        final ECPublicKey popPublicKey;
        final SupportedGroupsExtension.NamedGroup namedGroup;

        ECDHECredentials(ECPublicKey popPublicKey, SupportedGroupsExtension.NamedGroup namedGroup) {
            this.popPublicKey = popPublicKey;
            this.namedGroup = namedGroup;
        }

        static ECDHECredentials valueOf(SupportedGroupsExtension.NamedGroup namedGroup, byte[] encodedPoint) throws IOException, GeneralSecurityException {
            if (namedGroup.type != SupportedGroupsExtension.NamedGroupType.NAMED_GROUP_ECDHE) {
                throw new RuntimeException("Credentials decoding:  Not ECDHE named group");
            }
            if (encodedPoint == null || encodedPoint.length == 0) {
                return null;
            }
            ECParameterSpec parameters = JsseJce.getECParameterSpec(namedGroup.oid);
            if (parameters == null) {
                return null;
            }
            ECPoint point = JsseJce.decodePoint(encodedPoint, parameters.getCurve());
            KeyFactory factory2 = JsseJce.getKeyFactory("EC");
            ECPublicKey publicKey = (ECPublicKey)factory2.generatePublic(new ECPublicKeySpec(point, parameters));
            return new ECDHECredentials(publicKey, namedGroup);
        }
    }
}

