/*
 * Decompiled with CFR 0.152.
 */
package org.openeuler.sun.security.ssl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.SocketException;
import java.nio.ByteBuffer;
import javax.net.ssl.SSLHandshakeException;
import org.openeuler.sun.security.ssl.Alert;
import org.openeuler.sun.security.ssl.ContentType;
import org.openeuler.sun.security.ssl.HandshakeHash;
import org.openeuler.sun.security.ssl.OutputRecord;
import org.openeuler.sun.security.ssl.ProtocolVersion;
import org.openeuler.sun.security.ssl.Record;
import org.openeuler.sun.security.ssl.SSLCipher;
import org.openeuler.sun.security.ssl.SSLHandshake;
import org.openeuler.sun.security.ssl.SSLLogger;
import org.openeuler.sun.security.ssl.SSLRecord;
import org.openeuler.sun.security.ssl.TransportContext;

final class SSLSocketOutputRecord
extends OutputRecord
implements SSLRecord {
    private OutputStream deliverStream = null;

    SSLSocketOutputRecord(HandshakeHash handshakeHash) {
        this(handshakeHash, (TransportContext)null);
    }

    SSLSocketOutputRecord(HandshakeHash handshakeHash, TransportContext tc) {
        super(handshakeHash, SSLCipher.SSLWriteCipher.nullTlsWriteCipher());
        this.tc = tc;
        this.packetSize = 16709;
        this.protocolVersion = ProtocolVersion.NONE;
    }

    @Override
    synchronized void encodeAlert(byte level, byte description) throws IOException {
        int position;
        if (this.isClosed()) {
            if (SSLLogger.isOn && SSLLogger.isOn("ssl")) {
                SSLLogger.warning("outbound has closed, ignore outbound alert message: " + Alert.nameOf(description), new Object[0]);
            }
            return;
        }
        this.count = position = 5 + this.writeCipher.getExplicitNonceSize();
        this.write(level);
        this.write(description);
        if (SSLLogger.isOn && SSLLogger.isOn("record")) {
            SSLLogger.fine("WRITE: " + (Object)((Object)this.protocolVersion) + " " + ContentType.ALERT.name + "(" + Alert.nameOf(description) + "), length = " + (this.count - 5), new Object[0]);
        }
        this.encrypt(this.writeCipher, ContentType.ALERT.id, 5);
        this.deliverStream.write(this.buf, 0, this.count);
        this.deliverStream.flush();
        if (SSLLogger.isOn && SSLLogger.isOn("packet")) {
            SSLLogger.fine("Raw write", new ByteArrayInputStream(this.buf, 0, this.count));
        }
        this.count = 0;
    }

    @Override
    synchronized void encodeHandshake(byte[] source2, int offset, int length) throws IOException {
        byte handshakeType;
        if (this.isClosed()) {
            if (SSLLogger.isOn && SSLLogger.isOn("ssl")) {
                SSLLogger.warning("outbound has closed, ignore outbound handshake message", ByteBuffer.wrap(source2, offset, length));
            }
            return;
        }
        if (this.firstMessage) {
            this.firstMessage = false;
            if (this.helloVersion == ProtocolVersion.SSL20Hello && source2[offset] == SSLHandshake.CLIENT_HELLO.id && source2[offset + 4 + 2 + 32] == 0) {
                ByteBuffer v2ClientHello = SSLSocketOutputRecord.encodeV2ClientHello(source2, offset + 4, length - 4);
                byte[] record = v2ClientHello.array();
                int limit = v2ClientHello.limit();
                this.handshakeHash.deliver(record, 2, limit - 2);
                if (SSLLogger.isOn && SSLLogger.isOn("record")) {
                    SSLLogger.fine("WRITE: SSLv2 ClientHello message, length = " + limit, new Object[0]);
                }
                this.deliverStream.write(record, 0, limit);
                this.deliverStream.flush();
                if (SSLLogger.isOn && SSLLogger.isOn("packet")) {
                    SSLLogger.fine("Raw write", new ByteArrayInputStream(record, 0, limit));
                }
                return;
            }
        }
        if (this.handshakeHash.isHashable(handshakeType = source2[0])) {
            this.handshakeHash.deliver(source2, offset, length);
        }
        int fragLimit = this.getFragLimit();
        int position = 5 + this.writeCipher.getExplicitNonceSize();
        if (this.count == 0) {
            this.count = position;
        }
        if (this.count - position < fragLimit - length) {
            this.write(source2, offset, length);
            return;
        }
        int limit = offset + length;
        while (offset < limit) {
            int remains = limit - offset + (this.count - position);
            int fragLen = Math.min(fragLimit, remains);
            this.write(source2, offset, fragLen);
            if (remains < fragLimit) {
                return;
            }
            if (SSLLogger.isOn && SSLLogger.isOn("record")) {
                SSLLogger.fine("WRITE: " + (Object)((Object)this.protocolVersion) + " " + ContentType.HANDSHAKE.name + ", length = " + (this.count - 5), new Object[0]);
            }
            this.encrypt(this.writeCipher, ContentType.HANDSHAKE.id, 5);
            this.deliverStream.write(this.buf, 0, this.count);
            this.deliverStream.flush();
            if (SSLLogger.isOn && SSLLogger.isOn("packet")) {
                SSLLogger.fine("Raw write", new ByteArrayInputStream(this.buf, 0, this.count));
            }
            offset += fragLen;
            this.count = position;
        }
    }

    @Override
    synchronized void encodeChangeCipherSpec() throws IOException {
        int position;
        if (this.isClosed()) {
            if (SSLLogger.isOn && SSLLogger.isOn("ssl")) {
                SSLLogger.warning("outbound has closed, ignore outbound change_cipher_spec message", new Object[0]);
            }
            return;
        }
        this.count = position = 5 + this.writeCipher.getExplicitNonceSize();
        this.write(1);
        this.encrypt(this.writeCipher, ContentType.CHANGE_CIPHER_SPEC.id, 5);
        this.deliverStream.write(this.buf, 0, this.count);
        if (SSLLogger.isOn && SSLLogger.isOn("packet")) {
            SSLLogger.fine("Raw write", new ByteArrayInputStream(this.buf, 0, this.count));
        }
        this.count = 0;
    }

    @Override
    public synchronized void flush() throws IOException {
        int position = 5 + this.writeCipher.getExplicitNonceSize();
        if (this.count <= position) {
            return;
        }
        if (SSLLogger.isOn && SSLLogger.isOn("record")) {
            SSLLogger.fine("WRITE: " + (Object)((Object)this.protocolVersion) + " " + ContentType.HANDSHAKE.name + ", length = " + (this.count - 5), new Object[0]);
        }
        this.encrypt(this.writeCipher, ContentType.HANDSHAKE.id, 5);
        this.deliverStream.write(this.buf, 0, this.count);
        this.deliverStream.flush();
        if (SSLLogger.isOn && SSLLogger.isOn("packet")) {
            SSLLogger.fine("Raw write", new ByteArrayInputStream(this.buf, 0, this.count));
        }
        this.count = 0;
    }

    @Override
    synchronized void deliver(byte[] source2, int offset, int length) throws IOException {
        if (this.isClosed()) {
            throw new SocketException("Connection or outbound has been closed");
        }
        if (this.writeCipher.authenticator.seqNumOverflow()) {
            if (SSLLogger.isOn && SSLLogger.isOn("ssl")) {
                SSLLogger.fine("sequence number extremely close to overflow (2^64-1 packets). Closing connection.", new Object[0]);
            }
            throw new SSLHandshakeException("sequence number overflow");
        }
        boolean isFirstRecordOfThePayload = true;
        int limit = offset + length;
        while (offset < limit) {
            int position;
            int fragLen;
            if (this.packetSize > 0) {
                fragLen = Math.min(16709, this.packetSize);
                fragLen = this.writeCipher.calculateFragmentSize(fragLen, 5);
                fragLen = Math.min(fragLen, 16384);
            } else {
                fragLen = 16384;
            }
            fragLen = this.calculateFragmentSize(fragLen);
            if (isFirstRecordOfThePayload && this.needToSplitPayload()) {
                fragLen = 1;
                isFirstRecordOfThePayload = false;
            } else {
                fragLen = Math.min(fragLen, limit - offset);
            }
            this.count = position = 5 + this.writeCipher.getExplicitNonceSize();
            this.write(source2, offset, fragLen);
            if (SSLLogger.isOn && SSLLogger.isOn("record")) {
                SSLLogger.fine("WRITE: " + (Object)((Object)this.protocolVersion) + " " + ContentType.APPLICATION_DATA.name + ", length = " + (this.count - position), new Object[0]);
            }
            this.encrypt(this.writeCipher, ContentType.APPLICATION_DATA.id, 5);
            this.deliverStream.write(this.buf, 0, this.count);
            this.deliverStream.flush();
            if (SSLLogger.isOn && SSLLogger.isOn("packet")) {
                SSLLogger.fine("Raw write", new ByteArrayInputStream(this.buf, 0, this.count));
            }
            this.count = 0;
            if (this.isFirstAppOutputRecord) {
                this.isFirstAppOutputRecord = false;
            }
            offset += fragLen;
        }
    }

    @Override
    synchronized void setDeliverStream(OutputStream outputStream2) {
        this.deliverStream = outputStream2;
    }

    private boolean needToSplitPayload() {
        return !this.protocolVersion.useTLS11PlusSpec() && !this.protocolVersion.useGMTLSSpec() && this.writeCipher.isCBCMode() && !this.isFirstAppOutputRecord && Record.enableCBCProtection;
    }

    private int getFragLimit() {
        int fragLimit;
        if (this.packetSize > 0) {
            fragLimit = Math.min(16709, this.packetSize);
            fragLimit = this.writeCipher.calculateFragmentSize(fragLimit, 5);
            fragLimit = Math.min(fragLimit, 16384);
        } else {
            fragLimit = 16384;
        }
        fragLimit = this.calculateFragmentSize(fragLimit);
        return fragLimit;
    }
}

