/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.core.impl;

import com.huaweicloud.sdk.core.exception.ConnectionException;
import com.huaweicloud.sdk.core.exception.HostUnreachableException;
import com.huaweicloud.sdk.core.exception.SdkException;
import com.huaweicloud.sdk.core.exception.SslHandShakeException;
import com.huaweicloud.sdk.core.http.FormDataFilePart;
import com.huaweicloud.sdk.core.http.FormDataPart;
import com.huaweicloud.sdk.core.http.HttpClient;
import com.huaweicloud.sdk.core.http.HttpConfig;
import com.huaweicloud.sdk.core.http.HttpRequest;
import com.huaweicloud.sdk.core.http.HttpResponse;
import com.huaweicloud.sdk.core.impl.DefaultHttpListener;
import com.huaweicloud.sdk.core.impl.DefaultHttpResponse;
import com.huaweicloud.sdk.core.progress.ProgressInputStream;
import com.huaweicloud.sdk.core.progress.RepeatableRequestEntity;
import com.huaweicloud.sdk.core.progress.SimpleProgressManager;
import com.huaweicloud.sdk.core.ssl.IgnoreSSLVerificationFactory;
import com.huaweicloud.sdk.core.utils.ExceptionUtils;
import com.huaweicloud.sdk.core.utils.StringUtils;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLHandshakeException;
import okhttp3.Authenticator;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Credentials;
import okhttp3.FormBody;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.internal.http.HttpMethod;
import okio.BufferedSink;
import okio.Okio;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultHttpClient
implements HttpClient {
    private static final Logger logger = LoggerFactory.getLogger(DefaultHttpClient.class);
    private static final String OKHTTP_PREEMPTIVE = "OkHttp-Preemptive";
    private static final String PROXY_AUTHENTICATE = "Proxy-Authenticate";
    private static final String PROXY_AUTHORIZATION = "Proxy-Authorization";
    private static final int PROXY_AUTHENTICATION_REQUIRED = 407;
    private OkHttpClient client;
    private HttpConfig httpConfig;

    public DefaultHttpClient(HttpConfig httpConfig) {
        this.withHttpConfig(httpConfig);
    }

    public HttpConfig getHttpConfig() {
        return this.httpConfig;
    }

    public DefaultHttpClient withHttpConfig(HttpConfig httpConfig) {
        this.httpConfig = httpConfig;
        OkHttpClient.Builder clientBuilder = new OkHttpClient.Builder().followRedirects(httpConfig.isAllowRedirects());
        clientBuilder.connectionPool(httpConfig.getConnectionPool());
        if (Objects.nonNull(httpConfig.getDispatcher())) {
            clientBuilder.dispatcher(httpConfig.getDispatcher());
        }
        clientBuilder.connectTimeout(httpConfig.getConnectionTimeout(), TimeUnit.SECONDS).readTimeout(httpConfig.getReadTimeout(), TimeUnit.SECONDS);
        if (Objects.nonNull(httpConfig.getSSLSocketFactory()) && Objects.nonNull(httpConfig.getX509TrustManager())) {
            clientBuilder.sslSocketFactory(httpConfig.getSSLSocketFactory(), httpConfig.getX509TrustManager());
        }
        if (Objects.nonNull(httpConfig.getHostnameVerifier())) {
            clientBuilder.hostnameVerifier(httpConfig.getHostnameVerifier());
        }
        if (httpConfig.isIgnoreSSLVerification()) {
            clientBuilder.hostnameVerifier(IgnoreSSLVerificationFactory.getHostnameVerifier()).sslSocketFactory(IgnoreSSLVerificationFactory.getSSLContext(httpConfig.getSecureRandom()).getSocketFactory(), IgnoreSSLVerificationFactory.getTrustAllManager());
        }
        clientBuilder.protocols(Collections.singletonList(Protocol.HTTP_1_1));
        if (!StringUtils.isEmpty(httpConfig.getProxyHost())) {
            Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(httpConfig.getProxyHost(), httpConfig.getProxyPort()));
            clientBuilder.proxy(proxy);
        }
        if (!StringUtils.isEmpty(httpConfig.getProxyUsername())) {
            Authenticator proxyAuthenticator = (route, response) -> {
                if (!OKHTTP_PREEMPTIVE.equals(response.header(PROXY_AUTHENTICATE)) && response.code() == 407) {
                    return null;
                }
                String credential = Credentials.basic(httpConfig.getProxyUsername(), httpConfig.getProxyPassword());
                return response.request().newBuilder().header(PROXY_AUTHORIZATION, credential).build();
            };
            clientBuilder.proxyAuthenticator(proxyAuthenticator);
        }
        this.client = clientBuilder.addInterceptor(new DefaultHttpListener(httpConfig)).build();
        return this;
    }

    private Request buildOkHttpRequest(HttpRequest httpRequest) {
        Request.Builder requestBuilder = new Request.Builder();
        String url = httpRequest.getEndpoint() + httpRequest.getPathParamsString();
        HttpUrl httpUrl = Optional.ofNullable(HttpUrl.parse(url)).orElseThrow(() -> new SdkException("failed to parse url from " + url));
        HttpUrl.Builder urlBuilder = httpUrl.newBuilder();
        httpRequest.getQueryParams().forEach((key, values2) -> {
            if (values2.size() == 0) {
                urlBuilder.addQueryParameter((String)key, null);
            } else {
                values2.forEach(value -> urlBuilder.addQueryParameter((String)key, (String)value));
            }
        });
        requestBuilder.url(urlBuilder.build());
        httpRequest.getHeaders().forEach((key, values2) -> values2.forEach(value -> requestBuilder.header((String)key, (String)value)));
        if (Objects.nonNull(httpRequest.getBodyAsString())) {
            return this.buildOkHttpRequestWithTextBody(httpRequest, requestBuilder);
        }
        if (httpRequest.getContentType().startsWith("multipart/form-data")) {
            return this.buildOkHttpRequestWithFormData(httpRequest, requestBuilder);
        }
        if (httpRequest.getContentType().startsWith("application/x-www-form-urlencoded")) {
            return this.buildOkHttpRequestWithUrlEncoded(httpRequest, requestBuilder);
        }
        return this.buildOkHttpRequestWithoutTextBody(httpRequest, requestBuilder);
    }

    private Request buildOkHttpRequestWithUrlEncoded(HttpRequest httpRequest, Request.Builder requestBuilder) {
        FormBody.Builder bodyBuilder = new FormBody.Builder();
        for (Map.Entry<String, FormDataPart<?>> entry : httpRequest.getFormData().entrySet()) {
            bodyBuilder.addEncoded(entry.getKey(), entry.getValue().toString());
        }
        return requestBuilder.method(httpRequest.getMethod().toString(), bodyBuilder.build()).build();
    }

    private Request buildOkHttpRequestWithFormData(HttpRequest httpRequest, Request.Builder requestBuilder) {
        MultipartBody.Builder bodyBuilder = new MultipartBody.Builder();
        MediaType mediaType = Optional.ofNullable(MediaType.parse(httpRequest.getContentType())).orElseThrow(() -> new SdkException("failed to parse request Content-Type from " + httpRequest.getContentType()));
        bodyBuilder.setType(mediaType);
        httpRequest.getFormData().forEach((name, part) -> {
            if (part instanceof FormDataFilePart) {
                final FormDataFilePart filePart = (FormDataFilePart)part;
                bodyBuilder.addFormDataPart((String)name, filePart.getFilename(), new RequestBody(){

                    @Override
                    public MediaType contentType() {
                        return Objects.isNull(filePart.getContentType()) ? null : MediaType.parse(filePart.getContentType());
                    }

                    @Override
                    public void writeTo(@NotNull BufferedSink bufferedSink) throws IOException {
                        try (Source source2 = Okio.source(filePart.getInputStream());){
                            bufferedSink.writeAll(source2);
                        }
                    }
                });
            } else {
                bodyBuilder.addFormDataPart((String)name, part.toString());
            }
        });
        requestBuilder.method(httpRequest.getMethod().toString(), bodyBuilder.build());
        return requestBuilder.build();
    }

    private Request buildOkHttpRequestWithTextBody(final HttpRequest httpRequest, Request.Builder requestBuilder) {
        requestBuilder.method(httpRequest.getMethod().toString(), new RequestBody(){

            @Override
            public MediaType contentType() {
                return MediaType.parse(httpRequest.getContentType());
            }

            @Override
            public void writeTo(@NotNull BufferedSink bufferedSink) throws IOException {
                bufferedSink.writeUtf8(httpRequest.getBodyAsString());
            }

            @Override
            public long contentLength() throws IOException {
                if (httpRequest.haveHeader("Content-Length").booleanValue()) {
                    return Long.parseLong(httpRequest.getHeader("Content-Length"));
                }
                return super.contentLength();
            }
        });
        return requestBuilder.build();
    }

    private Request buildOkHttpRequestWithoutTextBody(HttpRequest httpRequest, Request.Builder requestBuilder) {
        if (Objects.isNull(httpRequest.getBody())) {
            if (HttpMethod.requiresRequestBody(httpRequest.getMethod().toString())) {
                requestBuilder.method(httpRequest.getMethod().toString(), this.createRequestBody(new byte[0], null));
            } else {
                requestBuilder.method(httpRequest.getMethod().toString(), null);
            }
        } else {
            this.buildStreamRequestBody(httpRequest, requestBuilder);
        }
        return requestBuilder.build();
    }

    private RequestBody createRequestBody(byte[] content, MediaType contentType) {
        try {
            return RequestBody.create(content, contentType);
        }
        catch (NoSuchMethodError e) {
            return RequestBody.create(contentType, content);
        }
    }

    private void buildStreamRequestBody(final HttpRequest httpRequest, Request.Builder requestBuilder) {
        RequestBody requestBody;
        if (Objects.isNull(httpRequest.getProgressListener())) {
            requestBody = new RequestBody(){

                @Override
                public MediaType contentType() {
                    return MediaType.parse(httpRequest.getContentType());
                }

                @Override
                public void writeTo(@NotNull BufferedSink bufferedSink) throws IOException {
                    try (Source source2 = Okio.source(httpRequest.getBody());){
                        bufferedSink.writeAll(source2);
                    }
                }
            };
        } else {
            long contentLength;
            try {
                contentLength = httpRequest.haveHeader("Content-Length") != false ? Long.parseLong(httpRequest.getHeader("Content-Length")) : (long)httpRequest.getBody().available();
            }
            catch (IOException | NumberFormatException ignore) {
                contentLength = -1L;
            }
            SimpleProgressManager progressManager = new SimpleProgressManager(contentLength, 0L, httpRequest.getProgressListener(), httpRequest.getProgressInterval());
            ProgressInputStream inputStream2 = new ProgressInputStream(httpRequest.getBody(), progressManager);
            requestBody = new RepeatableRequestEntity(inputStream2, httpRequest.getHeader("Content-Type"), contentLength);
        }
        requestBuilder.method(httpRequest.getMethod().toString(), requestBody);
    }

    public Callback toCallback(final CompletableFuture<Response> future) {
        return new Callback(){

            @Override
            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(e);
            }

            @Override
            public void onResponse(@NotNull Call call, @NotNull Response response) {
                future.complete(response);
            }
        };
    }

    @Override
    public CompletableFuture<HttpResponse> asyncInvokeHttp(HttpRequest httpRequest) {
        Request request = this.buildOkHttpRequest(httpRequest);
        CompletableFuture<Response> asyncHttpResponse = new CompletableFuture<Response>();
        this.client.newCall(request).enqueue(this.toCallback(asyncHttpResponse));
        return asyncHttpResponse.handleAsync((response, throwable) -> {
            if (Objects.nonNull(request.body()) && request.body() instanceof Closeable) {
                this.closeStream((Closeable)((Object)request.body()));
            }
            if (throwable != null) {
                if (throwable instanceof SSLHandshakeException) {
                    logger.error("DefaultHttpClient SslHandShakeException", throwable);
                    throw new SslHandShakeException("DefaultHttpClient SslHandShakeException", (Throwable)throwable);
                }
                if (throwable instanceof UnknownHostException) {
                    logger.error("DefaultHttpClient HostUnreachableException", throwable);
                    throw new HostUnreachableException("DefaultHttpClient HostUnreachableException", (Throwable)throwable);
                }
                if (throwable instanceof SocketTimeoutException) {
                    logger.error("DefaultHttpClient RequestTimeoutException", throwable);
                    ExceptionUtils.mapSocketTimeoutException("DefaultHttpClient RequestTimeoutException", throwable);
                } else {
                    logger.error("DefaultHttpClient ConnectionException", throwable);
                    throw new ConnectionException("DefaultHttpClient ConnectionException", (Throwable)throwable);
                }
            }
            return DefaultHttpResponse.wrap(response);
        }, (Executor)this.httpConfig.getExecutorService());
    }

    @Override
    public HttpResponse syncInvokeHttp(HttpRequest httpRequest) throws ConnectionException {
        Request request = this.buildOkHttpRequest(httpRequest);
        Response response = null;
        try {
            response = this.client.newCall(request).execute();
        }
        catch (SSLHandshakeException e) {
            logger.error("DefaultHttpClient SslHandShakeException", (Throwable)e);
            throw new SslHandShakeException("DefaultHttpClient SslHandShakeException", e);
        }
        catch (UnknownHostException e) {
            logger.error("DefaultHttpClient HostUnreachableException", (Throwable)e);
            throw new HostUnreachableException("DefaultHttpClient HostUnreachableException", e);
        }
        catch (SocketTimeoutException e) {
            logger.error("DefaultHttpClient RequestTimeout", (Throwable)e);
            ExceptionUtils.mapSocketTimeoutException("DefaultHttpClient RequestTimeout", e);
        }
        catch (IOException e) {
            logger.error("DefaultHttpClient ConnectionException", (Throwable)e);
            throw new ConnectionException("DefaultHttpClient ConnectionException", e);
        }
        finally {
            if (Objects.nonNull(request.body()) && request.body() instanceof Closeable) {
                this.closeStream((Closeable)((Object)request.body()));
            }
        }
        return DefaultHttpResponse.wrap(response);
    }

    private void closeStream(Closeable closeable) {
        try {
            closeable.close();
        }
        catch (IOException e) {
            logger.warn("close failed.", (Throwable)e);
        }
    }
}

