/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.core.impl;

import com.huaweicloud.sdk.core.http.HttpResponse;
import com.huaweicloud.sdk.core.impl.DefaultHttpUtils;
import com.huaweicloud.sdk.core.utils.HttpUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultHttpResponse
implements HttpResponse {
    private static final Logger logger = LoggerFactory.getLogger(DefaultHttpResponse.class);
    private final Response response;
    private String strBody;
    private byte[] byteBody;

    private DefaultHttpResponse(Response response) {
        this.response = response;
        try {
            if (this.shouldReadBody()) {
                this.strBody = response.body().string();
            } else if (this.shouldReadBodyAsByte()) {
                this.byteBody = response.body().bytes();
            }
        }
        catch (IOException e) {
            logger.error("Read http response body error!", (Throwable)e);
        }
    }

    private boolean shouldReadBody() {
        if (Objects.isNull(this.response.body())) {
            return false;
        }
        if (Objects.isNull(this.response.body().contentType()) && this.response.body().contentLength() <= 0L) {
            return false;
        }
        return HttpUtils.isTextBasedContentType(this.response.body().contentType().toString());
    }

    private boolean shouldReadBodyAsByte() {
        if (Objects.isNull(this.response.body())) {
            return false;
        }
        if (Objects.isNull(this.response.body().contentType()) && this.response.body().contentLength() <= 0L) {
            return false;
        }
        return HttpUtils.isBsonContentType(this.response.body().contentType().toString());
    }

    static DefaultHttpResponse wrap(Response response) {
        return new DefaultHttpResponse(response);
    }

    @Override
    public int getStatusCode() {
        return this.response.code();
    }

    @Override
    public String getContentType() {
        return Objects.isNull(this.response.body()) || Objects.isNull(this.response.body().contentType()) ? null : this.response.body().contentType().toString();
    }

    @Override
    public long getContentLength() {
        return Objects.isNull(this.response.body()) || this.response.body().contentLength() < 0L ? 0L : this.response.body().contentLength();
    }

    @Override
    public Map<String, List<String>> getHeaders() {
        return DefaultHttpUtils.headersToMap(this.response.headers());
    }

    @Override
    public String getBodyAsString() {
        return this.strBody;
    }

    @Override
    public byte[] getBodyAsBytes() {
        return this.byteBody;
    }

    @Override
    public InputStream getBody() {
        return this.response.body().byteStream();
    }

    @Override
    public String getHeader(String name) {
        return this.response.header(name);
    }
}

