/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.core.utils;

import com.huaweicloud.sdk.core.exception.SdkException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SignUtils {
    private static final String DEFAULT_ENCODING = "UTF-8";
    private static final Pattern ENCODED_CHARACTERS_PATTERN;

    private SignUtils() {
    }

    public static String urlEncode(String value, boolean path) {
        String encoded;
        if (value == null) {
            return "";
        }
        try {
            encoded = URLEncoder.encode(value, DEFAULT_ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            throw new SdkException(e);
        }
        Matcher matcher = ENCODED_CHARACTERS_PATTERN.matcher(encoded);
        StringBuffer buffer = new StringBuffer(encoded.length());
        while (matcher.find()) {
            String replacement = matcher.group(0);
            if ("+".equals(replacement)) {
                replacement = "%20";
            } else if ("*".equals(replacement)) {
                replacement = "%2A";
            } else if ("%7E".equals(replacement)) {
                replacement = "~";
            } else if (path && "%2F".equals(replacement)) {
                replacement = "/";
            }
            matcher.appendReplacement(buffer, replacement);
        }
        matcher.appendTail(buffer);
        return buffer.toString();
    }

    public static String convertSortedMap2QueryString(SortedMap<String, List<String>> sortedMap) {
        StringBuilder builder = new StringBuilder();
        Iterator<Map.Entry<String, List<String>>> itr = sortedMap.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry<String, List<String>> pair = itr.next();
            for (int i = 0; i < pair.getValue().size(); ++i) {
                builder.append(pair.getKey());
                builder.append("=");
                builder.append(pair.getValue().get(i));
                if (i >= pair.getValue().size() - 1) continue;
                builder.append("&");
            }
            if (pair.getValue().size() == 0) {
                builder.append(pair.getKey()).append("=");
            }
            if (!itr.hasNext()) continue;
            builder.append("&");
        }
        return builder.toString();
    }

    public static SortedMap<String, List<String>> convertQuery2SortedMap(String query) {
        String[] splitArr;
        TreeMap<String, List<String>> sorted2 = new TreeMap<String, List<String>>();
        if (query == null || query.isEmpty()) {
            return sorted2;
        }
        for (String split : splitArr = query.split("&")) {
            String[] kv = split.split("=");
            if (kv.length != 2) continue;
            if (!sorted2.containsKey(kv[0])) {
                ArrayList<String> values2 = new ArrayList<String>();
                values2.add(kv[1]);
                sorted2.put(kv[0], values2);
                continue;
            }
            ((List)sorted2.get(kv[0])).add(kv[1]);
        }
        return sorted2;
    }

    static {
        StringBuilder pattern = new StringBuilder();
        pattern.append(Pattern.quote("+")).append("|").append(Pattern.quote("*")).append("|").append(Pattern.quote("%7E")).append("|").append(Pattern.quote("%2F"));
        ENCODED_CHARACTERS_PATTERN = Pattern.compile(pattern.toString());
    }
}

