/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider.keystore.util;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.Date;
import java.util.Enumeration;
import org.bouncycastle.jcajce.provider.keystore.pkcs12.PKCS12KeyStoreSpi;
import org.bouncycastle.jcajce.provider.keystore.util.JKSKeyStoreSpi;
import org.bouncycastle.jcajce.util.JcaJceHelper;
import org.bouncycastle.util.Properties;

public class AdaptingKeyStoreSpi
extends KeyStoreSpi {
    public static final String COMPAT_OVERRIDE = "keystore.type.compat";
    private final JKSKeyStoreSpi jksStore;
    private final KeyStoreSpi primaryStore;
    private KeyStoreSpi keyStoreSpi;

    public AdaptingKeyStoreSpi(JcaJceHelper jcaJceHelper, KeyStoreSpi keyStoreSpi) {
        this.jksStore = new JKSKeyStoreSpi(jcaJceHelper);
        this.primaryStore = keyStoreSpi;
        this.keyStoreSpi = keyStoreSpi;
    }

    @Override
    public boolean engineProbe(InputStream inputStream2) throws IOException {
        if (this.keyStoreSpi instanceof PKCS12KeyStoreSpi) {
            return ((PKCS12KeyStoreSpi)this.keyStoreSpi).engineProbe(inputStream2);
        }
        return false;
    }

    @Override
    public Key engineGetKey(String string, char[] cArray) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        return this.keyStoreSpi.engineGetKey(string, cArray);
    }

    @Override
    public Certificate[] engineGetCertificateChain(String string) {
        return this.keyStoreSpi.engineGetCertificateChain(string);
    }

    @Override
    public Certificate engineGetCertificate(String string) {
        return this.keyStoreSpi.engineGetCertificate(string);
    }

    @Override
    public Date engineGetCreationDate(String string) {
        return this.keyStoreSpi.engineGetCreationDate(string);
    }

    @Override
    public void engineSetKeyEntry(String string, Key key, char[] cArray, Certificate[] certificateArray) throws KeyStoreException {
        this.keyStoreSpi.engineSetKeyEntry(string, key, cArray, certificateArray);
    }

    @Override
    public void engineSetKeyEntry(String string, byte[] byArray, Certificate[] certificateArray) throws KeyStoreException {
        this.keyStoreSpi.engineSetKeyEntry(string, byArray, certificateArray);
    }

    @Override
    public void engineSetCertificateEntry(String string, Certificate certificate) throws KeyStoreException {
        this.keyStoreSpi.engineSetCertificateEntry(string, certificate);
    }

    @Override
    public void engineDeleteEntry(String string) throws KeyStoreException {
        this.keyStoreSpi.engineDeleteEntry(string);
    }

    @Override
    public Enumeration<String> engineAliases() {
        return this.keyStoreSpi.engineAliases();
    }

    @Override
    public boolean engineContainsAlias(String string) {
        return this.keyStoreSpi.engineContainsAlias(string);
    }

    @Override
    public int engineSize() {
        return this.keyStoreSpi.engineSize();
    }

    @Override
    public boolean engineIsKeyEntry(String string) {
        return this.keyStoreSpi.engineIsKeyEntry(string);
    }

    @Override
    public boolean engineIsCertificateEntry(String string) {
        return this.keyStoreSpi.engineIsCertificateEntry(string);
    }

    @Override
    public String engineGetCertificateAlias(Certificate certificate) {
        return this.keyStoreSpi.engineGetCertificateAlias(certificate);
    }

    @Override
    public void engineStore(OutputStream outputStream2, char[] cArray) throws IOException, NoSuchAlgorithmException, CertificateException {
        this.keyStoreSpi.engineStore(outputStream2, cArray);
    }

    @Override
    public void engineStore(KeyStore.LoadStoreParameter loadStoreParameter) throws IOException, NoSuchAlgorithmException, CertificateException {
        this.keyStoreSpi.engineStore(loadStoreParameter);
    }

    @Override
    public void engineLoad(InputStream inputStream2, char[] cArray) throws IOException, NoSuchAlgorithmException, CertificateException {
        if (inputStream2 == null) {
            this.keyStoreSpi = this.primaryStore;
            this.keyStoreSpi.engineLoad(null, cArray);
        } else {
            if (Properties.isOverrideSet(COMPAT_OVERRIDE) || !(this.primaryStore instanceof PKCS12KeyStoreSpi)) {
                if (!inputStream2.markSupported()) {
                    inputStream2 = new BufferedInputStream(inputStream2);
                }
                inputStream2.mark(8);
                this.keyStoreSpi = this.jksStore.engineProbe(inputStream2) ? this.jksStore : this.primaryStore;
                inputStream2.reset();
            } else {
                this.keyStoreSpi = this.primaryStore;
            }
            this.keyStoreSpi.engineLoad(inputStream2, cArray);
        }
    }

    @Override
    public void engineLoad(KeyStore.LoadStoreParameter loadStoreParameter) throws IOException, NoSuchAlgorithmException, CertificateException {
        this.keyStoreSpi.engineLoad(loadStoreParameter);
    }
}

