/*
 * Decompiled with CFR 0.152.
 */
package org.openeuler;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.security.Provider;
import java.util.Map;
import org.openeuler.JavaVersion;

public class CompatibleOracleJdkHandler {
    private static Map verificationResults;
    private static Class<?> jceSecurityClass;
    private static Constructor<?> identityWrapperConstructor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void skipJarVerify(Provider provider) {
        if (jceSecurityClass != null && verificationResults != null) {
            Class<?> clazz = jceSecurityClass;
            synchronized (clazz) {
                if (identityWrapperConstructor != null) {
                    verificationResults.put(CompatibleOracleJdkHandler.newIdentityWrapper(provider), Boolean.TRUE);
                } else {
                    verificationResults.put(provider, Boolean.TRUE);
                }
            }
        }
    }

    private static void init() {
        if (!JavaVersion.isOracleJdk()) {
            return;
        }
        try {
            jceSecurityClass = Class.forName("javax.crypto.JceSecurity");
            Field verificationResultsField = jceSecurityClass.getDeclaredField("verificationResults");
            verificationResultsField.setAccessible(true);
            Object object = verificationResultsField.get(null);
            if (object instanceof Map) {
                verificationResults = (Map)object;
            }
            Class<?> identityWrapperClass = Class.forName("javax.crypto.JceSecurity$IdentityWrapper");
            identityWrapperConstructor = identityWrapperClass.getDeclaredConstructor(Provider.class);
            identityWrapperConstructor.setAccessible(true);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException | NoSuchMethodException reflectiveOperationException) {
            // empty catch block
        }
    }

    private static Object newIdentityWrapper(Provider provider) {
        try {
            return identityWrapperConstructor.newInstance(provider);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException reflectiveOperationException) {
            return null;
        }
    }

    static {
        CompatibleOracleJdkHandler.init();
    }
}

