/*
 * Decompiled with CFR 0.152.
 */
package org.openeuler.util;

import org.openeuler.util.Nat;

public class Mod {
    private static final int M30 = 0x3FFFFFFF;
    private static final long M32L = 0xFFFFFFFFL;

    public static void checkedModOddInverse(int[] m, int[] x, int[] z) {
        if (0 == Mod.modOddInverse(m, x, z)) {
            throw new ArithmeticException("Inverse does not exist.");
        }
    }

    public static int inverse32(int d) {
        int x = d;
        x *= 2 - d * x;
        x *= 2 - d * x;
        x *= 2 - d * x;
        x *= 2 - d * x;
        return x;
    }

    public static int modOddInverse(int[] m, int[] x, int[] z) {
        int len32 = m.length;
        int bits = (len32 << 5) - Integer.numberOfLeadingZeros(m[len32 - 1]);
        int len30 = (bits + 29) / 30;
        int[] t = new int[4];
        int[] D = new int[len30];
        int[] E = new int[len30];
        int[] F2 = new int[len30];
        int[] G = new int[len30];
        int[] M = new int[len30];
        E[0] = 1;
        Mod.encode30(bits, x, 0, G, 0);
        Mod.encode30(bits, m, 0, M, 0);
        System.arraycopy(M, 0, F2, 0, len30);
        int delta = 0;
        int m0Inv32 = Mod.inverse32(M[0]);
        int maxDivsteps = Mod.getMaximumDivsteps(bits);
        for (int divSteps = 0; divSteps < maxDivsteps; divSteps += 30) {
            delta = Mod.divsteps30(delta, F2[0], G[0], t);
            Mod.updateDE30(len30, D, E, t, m0Inv32, M);
            Mod.updateFG30(len30, F2, G, t);
        }
        int signF = F2[len30 - 1] >> 31;
        Mod.cnegate30(len30, signF, F2);
        Mod.cnormalize30(len30, signF, D, M);
        Mod.decode30(bits, D, 0, z, 0);
        return Nat.equalTo(len30, F2, 1) & Nat.equalToZero(len30, G);
    }

    private static void cnegate30(int len30, int cond, int[] D) {
        int c = 0;
        int last = len30 - 1;
        for (int i = 0; i < last; ++i) {
            D[i] = (c += (D[i] ^ cond) - cond) & 0x3FFFFFFF;
            c >>= 30;
        }
        D[last] = c += (D[last] ^ cond) - cond;
    }

    private static void cnormalize30(int len30, int condNegate, int[] D, int[] M) {
        int di;
        int i;
        int last = len30 - 1;
        int c = 0;
        int condAdd = D[last] >> 31;
        for (i = 0; i < last; ++i) {
            di = D[i] + (M[i] & condAdd);
            di = (di ^ condNegate) - condNegate;
            D[i] = (c += di) & 0x3FFFFFFF;
            c >>= 30;
        }
        int di2 = D[last] + (M[last] & condAdd);
        di2 = (di2 ^ condNegate) - condNegate;
        D[last] = c += di2;
        c = 0;
        condAdd = D[last] >> 31;
        for (i = 0; i < last; ++i) {
            di = D[i] + (M[i] & condAdd);
            D[i] = (c += di) & 0x3FFFFFFF;
            c >>= 30;
        }
        di2 = D[last] + (M[last] & condAdd);
        D[last] = c += di2;
    }

    private static void decode30(int bits, int[] x, int xOff, int[] z, int zOff) {
        int avail = 0;
        long data = 0L;
        while (bits > 0) {
            while (avail < Math.min(32, bits)) {
                data |= (long)x[xOff++] << avail;
                avail += 30;
            }
            z[zOff++] = (int)data;
            data >>>= 32;
            avail -= 32;
            bits -= 32;
        }
    }

    private static int divsteps30(int delta, int f0, int g0, int[] t) {
        int u = 0x40000000;
        int v = 0;
        int q = 0;
        int r = 0x40000000;
        int f = f0;
        int g = g0;
        for (int i = 0; i < 30; ++i) {
            int c1 = delta >> 31;
            int c2 = -(g & 1);
            int x = f ^ c1;
            int y = u ^ c1;
            int z = v ^ c1;
            g -= x & c2;
            q -= y & c2;
            r -= z & c2;
            delta = (delta ^ (c2 &= ~c1)) - (c2 - 1);
            f += g & c2;
            u += q & c2;
            v += r & c2;
            g >>= 1;
            q >>= 1;
            r >>= 1;
        }
        t[0] = u;
        t[1] = v;
        t[2] = q;
        t[3] = r;
        return delta;
    }

    private static void encode30(int bits, int[] x, int xOff, int[] z, int zOff) {
        int avail = 0;
        long data = 0L;
        while (bits > 0) {
            if (avail < Math.min(30, bits)) {
                data |= ((long)x[xOff++] & 0xFFFFFFFFL) << avail;
                avail += 32;
            }
            z[zOff++] = (int)data & 0x3FFFFFFF;
            data >>>= 30;
            avail -= 30;
            bits -= 30;
        }
    }

    private static int getMaximumDivsteps(int bits) {
        return (49 * bits + (bits < 46 ? 80 : 47)) / 17;
    }

    private static void updateDE30(int len30, int[] D, int[] E, int[] t, int m0Inv32, int[] M) {
        int u = t[0];
        int v = t[1];
        int q = t[2];
        int r = t[3];
        int sd = D[len30 - 1] >> 31;
        int se = E[len30 - 1] >> 31;
        int md = (u & sd) + (v & se);
        int me = (q & sd) + (r & se);
        int mi = M[0];
        int di = D[0];
        int ei = E[0];
        long cd = (long)u * (long)di + (long)v * (long)ei;
        long ce = (long)q * (long)di + (long)r * (long)ei;
        md -= m0Inv32 * (int)cd + md & 0x3FFFFFFF;
        me -= m0Inv32 * (int)ce + me & 0x3FFFFFFF;
        cd += (long)mi * (long)md;
        ce += (long)mi * (long)me;
        cd >>= 30;
        ce >>= 30;
        for (int i = 1; i < len30; ++i) {
            mi = M[i];
            di = D[i];
            ei = E[i];
            D[i - 1] = (int)(cd += (long)u * (long)di + (long)v * (long)ei + (long)mi * (long)md) & 0x3FFFFFFF;
            cd >>= 30;
            E[i - 1] = (int)(ce += (long)q * (long)di + (long)r * (long)ei + (long)mi * (long)me) & 0x3FFFFFFF;
            ce >>= 30;
        }
        D[len30 - 1] = (int)cd;
        E[len30 - 1] = (int)ce;
    }

    private static void updateFG30(int len30, int[] F2, int[] G, int[] t) {
        int u = t[0];
        int v = t[1];
        int q = t[2];
        int r = t[3];
        int fi = F2[0];
        int gi = G[0];
        long cf = (long)u * (long)fi + (long)v * (long)gi;
        long cg = (long)q * (long)fi + (long)r * (long)gi;
        cf >>= 30;
        cg >>= 30;
        for (int i = 1; i < len30; ++i) {
            fi = F2[i];
            gi = G[i];
            F2[i - 1] = (int)(cf += (long)u * (long)fi + (long)v * (long)gi) & 0x3FFFFFFF;
            cf >>= 30;
            G[i - 1] = (int)(cg += (long)q * (long)fi + (long)r * (long)gi) & 0x3FFFFFFF;
            cg >>= 30;
        }
        F2[len30 - 1] = (int)cf;
        G[len30 - 1] = (int)cg;
    }
}

