/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.iec60870.client;

import io.netty.channel.ChannelHandlerContext;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.camel.component.iec60870.DiscardAckModule;
import org.apache.camel.component.iec60870.ObjectAddress;
import org.apache.camel.component.iec60870.client.ClientOptions;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.ASDUAddress;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.InformationObjectAddress;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.Value;
import org.eclipse.neoscada.protocol.iec60870.client.AutoConnectClient;
import org.eclipse.neoscada.protocol.iec60870.client.data.AbstractDataProcessor;
import org.eclipse.neoscada.protocol.iec60870.client.data.DataHandler;
import org.eclipse.neoscada.protocol.iec60870.client.data.DataModule;
import org.eclipse.neoscada.protocol.iec60870.client.data.DataModuleContext;

public class ClientConnection {
    private final DataHandler dataHandler = new AbstractDataProcessor(){

        @Override
        public void activated(DataModuleContext dataModuleContext, ChannelHandlerContext ctx) {
            dataModuleContext.requestStartData();
            dataModuleContext.startInterrogation(ASDUAddress.BROADCAST, (short)20);
        }

        @Override
        public void started() {
        }

        @Override
        public void disconnected() {
        }

        @Override
        protected void fireEntry(ASDUAddress asduAddress, InformationObjectAddress address, Value<?> value) {
            ClientConnection.this.handleData(ObjectAddress.valueOf(asduAddress, address), value);
        }
    };
    private final Map<ObjectAddress, Value<?>> lastValue = new HashMap();
    private final Map<ObjectAddress, ValueListener> listeners = new HashMap<ObjectAddress, ValueListener>();
    private final String host;
    private final int port;
    private final ClientOptions options;
    private AutoConnectClient client;

    public ClientConnection(String host, int port, ClientOptions options) {
        this.host = host;
        this.port = port;
        this.options = options;
    }

    public void start() {
        DataModule dataModule = new DataModule(this.dataHandler, this.options.getDataModuleOptions());
        AutoConnectClient.ModulesFactory factory = () -> Arrays.asList(dataModule, new DiscardAckModule());
        CountDownLatch latch = new CountDownLatch(1);
        AutoConnectClient.StateListener stateListener = (state, e) -> {
            if (state == AutoConnectClient.State.CONNECTED) {
                latch.countDown();
            }
        };
        this.client = new AutoConnectClient(this.host, this.port, this.options.getProtocolOptions(), factory, stateListener);
        try {
            latch.await(this.options.getConnectionTimeout(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e2) {
            Thread.currentThread().interrupt();
        }
    }

    public void stop() {
        this.client.close();
    }

    protected synchronized void handleData(ObjectAddress address, Value<?> value) {
        this.lastValue.put(address, value);
        ValueListener listener = this.listeners.get(address);
        if (listener != null) {
            listener.update(address, value);
        }
    }

    public synchronized void setListener(ObjectAddress address, ValueListener listener) {
        if (listener != null) {
            this.listeners.put(address, listener);
            Value<?> last = this.lastValue.get(address);
            if (last != null) {
                listener.update(address, last);
            }
        } else {
            this.listeners.remove(address);
        }
    }

    public boolean executeCommand(Object command) {
        return this.client.writeCommand(command);
    }

    @FunctionalInterface
    public static interface ValueListener {
        public void update(ObjectAddress var1, Value<?> var2);
    }
}

