/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.iec60870.server;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.component.iec60870.ObjectAddress;
import org.apache.camel.component.iec60870.server.ServerEndpoint;
import org.apache.camel.component.iec60870.server.ServerInstance;
import org.apache.camel.support.DefaultConsumer;
import org.apache.camel.support.DefaultMessage;
import org.eclipse.neoscada.protocol.iec60870.server.data.model.WriteModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerConsumer
extends DefaultConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(ServerConsumer.class);
    private final ServerInstance server;
    private final ServerEndpoint endpoint;

    public ServerConsumer(ServerEndpoint endpoint, Processor processor, ServerInstance server) {
        super(endpoint, processor);
        this.endpoint = endpoint;
        this.server = server;
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        this.server.setListener(this.endpoint.getAddress(), this::updateValue);
    }

    @Override
    protected void doStop() throws Exception {
        this.server.setListener(this.endpoint.getAddress(), null);
        super.doStop();
    }

    private CompletionStage<Void> updateValue(WriteModel.Request<?> value) {
        try {
            Exchange exchange = this.getEndpoint().createExchange();
            exchange.setIn(this.mapMessage(value));
            CompletableFuture<Void> result = new CompletableFuture<Void>();
            this.getAsyncProcessor().process(exchange, doneSync -> result.complete(null));
            return result;
        }
        catch (Exception e) {
            LOG.debug("Failed to process message", (Throwable)e);
            CompletableFuture<Void> result = new CompletableFuture<Void>();
            result.completeExceptionally(e);
            return result;
        }
    }

    private Message mapMessage(WriteModel.Request<?> request) {
        DefaultMessage message = new DefaultMessage(this.endpoint.getCamelContext());
        message.setBody(request);
        message.setHeader("address", ObjectAddress.valueOf(request.getHeader().getAsduAddress(), request.getAddress()));
        message.setHeader("value", request.getValue());
        message.setHeader("informationObjectAddress", request.getAddress());
        message.setHeader("asduHeader", request.getHeader());
        message.setHeader("type", request.getType());
        message.setHeader("execute", request.isExecute());
        return message;
    }
}

