/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.neoscada.protocol.iec60870.asdu.message;

import io.netty.buffer.ByteBuf;
import org.eclipse.neoscada.protocol.iec60870.ProtocolOptions;
import org.eclipse.neoscada.protocol.iec60870.asdu.ASDUHeader;
import org.eclipse.neoscada.protocol.iec60870.asdu.message.AbstractInformationObjectMessage;
import org.eclipse.neoscada.protocol.iec60870.asdu.message.EncodeHelper;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.ASDU;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.InformationObjectAddress;

@ASDU(id=70, name="M_EI_NA_1")
public class EndOfInitialization
extends AbstractInformationObjectMessage {
    private static final int CAUSE_MASK = 127;
    public static final byte CAUSE_LOCAL_POWER_ON = 0;
    public static final byte CAUSE_LOCAL_MANUAL_RESET = 1;
    public static final byte CAUSE_REMOTE_RESET = 2;
    private final byte causeOfInitialization;
    private final boolean localParameterChange;

    public EndOfInitialization(ASDUHeader header, byte causeOfInitialization, boolean localParameterChange) {
        this(header, InformationObjectAddress.DEFAULT, causeOfInitialization, localParameterChange);
    }

    public EndOfInitialization(ASDUHeader header, InformationObjectAddress informationObjectAddress, byte causeOfInitialization, boolean localParameterChange) {
        super(header, informationObjectAddress);
        this.causeOfInitialization = causeOfInitialization;
        this.localParameterChange = localParameterChange;
    }

    public byte getCauseOfInitialization() {
        return this.causeOfInitialization;
    }

    public boolean isLocalParameterChange() {
        return this.localParameterChange;
    }

    public static EndOfInitialization parse(ProtocolOptions options, byte length, ASDUHeader header, ByteBuf data) {
        InformationObjectAddress informationObjectAddress = InformationObjectAddress.parse(options, data);
        byte b = data.readByte();
        byte causeOfInitialization = (byte)(b & 0x7F);
        boolean localParameterChange = (b & 0xFFFFFF80) > 0;
        EndOfInitialization result = new EndOfInitialization(header, informationObjectAddress, causeOfInitialization, localParameterChange);
        return result;
    }

    @Override
    public void encode(ProtocolOptions options, ByteBuf out) {
        EncodeHelper.encodeHeader(this, options, null, this.header, out);
        this.informationObjectAddress.encode(options, out);
        byte b = (byte)(this.causeOfInitialization & 0x7F | (this.localParameterChange ? 1 : 0));
        out.writeByte(b);
    }
}

