/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.neoscada.protocol.iec60870.asdu.message;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.neoscada.protocol.iec60870.ProtocolOptions;
import org.eclipse.neoscada.protocol.iec60870.asdu.ASDUHeader;
import org.eclipse.neoscada.protocol.iec60870.asdu.message.AbstractMeasuredValueFloatingPoint;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.ASDU;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.InformationEntry;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.InformationObjectAddress;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.InformationStructure;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.Value;

@ASDU(id=13, name="M_ME_NC_1", informationStructure=InformationStructure.SINGLE)
public class MeasuredValueShortFloatingPointSingle
extends AbstractMeasuredValueFloatingPoint {
    private MeasuredValueShortFloatingPointSingle(ASDUHeader header, List<InformationEntry<Float>> entries) {
        super(header, entries, false);
    }

    public static MeasuredValueShortFloatingPointSingle parse(ProtocolOptions options, byte length, ASDUHeader header, ByteBuf data) {
        return new MeasuredValueShortFloatingPointSingle(header, MeasuredValueShortFloatingPointSingle.parseEntries(options, length, data, false));
    }

    public static MeasuredValueShortFloatingPointSingle create(ASDUHeader header, InformationObjectAddress address, Value<Float> value) {
        return MeasuredValueShortFloatingPointSingle.createInternal(header, Collections.singletonList(new InformationEntry<Float>(address, value)));
    }

    public static MeasuredValueShortFloatingPointSingle create(ASDUHeader header, List<InformationEntry<Float>> values) {
        if (values.size() > 127) {
            throw new IllegalArgumentException(String.format("A maximum of %s values can be transmitted", 127));
        }
        return MeasuredValueShortFloatingPointSingle.createInternal(header, new ArrayList<InformationEntry<Float>>(values));
    }

    private static MeasuredValueShortFloatingPointSingle createInternal(ASDUHeader header, List<InformationEntry<Float>> values) {
        return new MeasuredValueShortFloatingPointSingle(header, values);
    }
}

