/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.neoscada.protocol.iec60870.server.data.event;

import org.eclipse.neoscada.protocol.iec60870.asdu.ASDUHeader;
import org.eclipse.neoscada.protocol.iec60870.asdu.message.MeasuredValueShortFloatingPointSequence;
import org.eclipse.neoscada.protocol.iec60870.asdu.message.MeasuredValueShortFloatingPointSingle;
import org.eclipse.neoscada.protocol.iec60870.asdu.message.MeasuredValueShortFloatingPointTimeSingle;
import org.eclipse.neoscada.protocol.iec60870.server.data.event.AbstractMessageBuilder;
import org.eclipse.neoscada.protocol.iec60870.server.data.event.MessageBuilder;
import org.eclipse.neoscada.protocol.iec60870.server.data.event.MessageBuilderFactory;

public class SimpleFloatBuilder
implements MessageBuilderFactory<Float> {
    private final boolean withTimestamps;

    public SimpleFloatBuilder(boolean withTimestamps) {
        this.withTimestamps = withTimestamps;
    }

    @Override
    public MessageBuilder<Float, ?> create() {
        return new AbstractMessageBuilder<Float, Object>(Float.class, 20, 20, this.withTimestamps ? 10 : -1){

            @Override
            public Object build() {
                this.validateStart();
                ASDUHeader header = new ASDUHeader(this.causeOfTransmission, this.asduAddress);
                if (this.isWithTimestamps()) {
                    return MeasuredValueShortFloatingPointTimeSingle.create(header, this.entries);
                }
                if (this.isContinuous()) {
                    return MeasuredValueShortFloatingPointSequence.create(this.getStartAddress(), header, this.getValues());
                }
                return MeasuredValueShortFloatingPointSingle.create(header, this.entries);
            }
        };
    }
}

