/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.neoscada.protocol.iec60870.server.data.model;

import java.util.Collections;
import java.util.List;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.ASDUAddress;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.InformationObjectAddress;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.Value;
import org.eclipse.neoscada.protocol.iec60870.server.data.model.ChangeModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstantChangeModel
implements ChangeModel {
    private static final Logger logger = LoggerFactory.getLogger(InstantChangeModel.class);
    private final Context context;

    public InstantChangeModel(Context context) {
        this.context = context;
    }

    @Override
    public Runnable dispose() {
        return () -> {};
    }

    @Override
    public void notifyChange(ASDUAddress asduAddress, InformationObjectAddress informationObjectAddress, Value<?> iecValue) {
        Object rawValue;
        logger.trace("Notify raw value: {} ({})", rawValue, (rawValue = iecValue.getValue()) != null ? rawValue.getClass() : null);
        if (rawValue instanceof Boolean) {
            this.context.notifyChangeBoolean(asduAddress, informationObjectAddress, Collections.singletonList(iecValue));
        } else if (rawValue instanceof Float) {
            this.context.notifyChangeFloat(asduAddress, informationObjectAddress, Collections.singletonList(iecValue));
        } else if (rawValue instanceof Short) {
            this.context.notifyChangeShort(asduAddress, informationObjectAddress, Collections.singletonList(iecValue));
        }
    }

    public static interface Context {
        public void notifyChangeBoolean(ASDUAddress var1, InformationObjectAddress var2, List<Value<Boolean>> var3);

        public void notifyChangeFloat(ASDUAddress var1, InformationObjectAddress var2, List<Value<Float>> var3);

        public void notifyChangeShort(ASDUAddress var1, InformationObjectAddress var2, List<Value<Short>> var3);
    }
}

