/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.neoscada.protocol.iec60870.asdu.message;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.neoscada.protocol.iec60870.ProtocolOptions;
import org.eclipse.neoscada.protocol.iec60870.asdu.ASDUHeader;
import org.eclipse.neoscada.protocol.iec60870.asdu.message.AbstractMessage;
import org.eclipse.neoscada.protocol.iec60870.asdu.message.EncodeHelper;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.DoublePoint;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.InformationEntry;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.InformationObjectAddress;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.TypeHelper;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.Value;

public abstract class AbstractDoublePointBaseSingle
extends AbstractMessage {
    private final List<InformationEntry<DoublePoint>> entries;
    private final boolean withTimestamp;

    public AbstractDoublePointBaseSingle(ASDUHeader header, List<InformationEntry<DoublePoint>> entries, boolean withTimestamp) {
        super(header);
        this.withTimestamp = withTimestamp;
        this.entries = entries;
    }

    public List<InformationEntry<DoublePoint>> getEntries() {
        return this.entries;
    }

    @Override
    public void encode(ProtocolOptions options, ByteBuf out) {
        EncodeHelper.encodeHeader(this, options, this.entries.size(), this.header, out);
        for (InformationEntry<DoublePoint> entry : this.entries) {
            entry.getAddress().encode(options, out);
            TypeHelper.encodeDoublePointValue(options, out, entry.getValue(), this.withTimestamp);
        }
    }

    protected static List<InformationEntry<DoublePoint>> parseEntries(ProtocolOptions options, byte length, ByteBuf data, boolean withTimestamp) {
        ArrayList<InformationEntry<DoublePoint>> values = new ArrayList<InformationEntry<DoublePoint>>(length);
        int i = 0;
        while (i < length) {
            InformationObjectAddress address = InformationObjectAddress.parse(options, data);
            Value<DoublePoint> value = TypeHelper.parseDoublePointValue(options, data, withTimestamp);
            values.add(new InformationEntry<DoublePoint>(address, value));
            ++i;
        }
        return values;
    }
}

