/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.neoscada.protocol.iec60870.asdu.types;

public class QualityInformation {
    private static final int MASK_VALID = 128;
    private static final int MASK_TOPICAL = 64;
    private static final int MASK_SUBSTITUTED = 32;
    private static final int MASK_BLOCKED = 16;
    public static final QualityInformation OK = new QualityInformation(false, false, true, true);
    public static final QualityInformation INVALID = new QualityInformation(false, false, true, false);
    private final boolean blocked;
    private final boolean substituted;
    private final boolean topical;
    private final boolean valid;

    public QualityInformation(boolean blocked, boolean substituted, boolean topical, boolean valid) {
        this.blocked = blocked;
        this.substituted = substituted;
        this.topical = topical;
        this.valid = valid;
    }

    public boolean isBlocked() {
        return this.blocked;
    }

    public boolean isSubstituted() {
        return this.substituted;
    }

    public boolean isTopical() {
        return this.topical;
    }

    public boolean isValid() {
        return this.valid;
    }

    public String toString() {
        return String.format("[%s%s%s%s]", this.blocked ? "B" : "", this.substituted ? "S" : "", this.topical ? "T" : "", this.valid ? "V" : "");
    }

    public byte apply(byte siq) {
        siq = QualityInformation.apply(siq, this.blocked, (byte)16);
        siq = QualityInformation.apply(siq, this.substituted, (byte)32);
        siq = QualityInformation.apply(siq, !this.topical, (byte)64);
        siq = QualityInformation.apply(siq, !this.valid, (byte)-128);
        return siq;
    }

    private static byte apply(byte siq, boolean value, byte mask) {
        siq = value ? (byte)(siq | mask) : (byte)(siq & ~mask);
        return siq;
    }

    public static QualityInformation parse(byte siq) {
        boolean blocked = (siq & 0x10) > 0;
        boolean substituted = (siq & 0x20) > 0;
        boolean topical = (siq & 0x40) == 0;
        boolean valid = (siq & 0x80) == 0;
        return new QualityInformation(blocked, substituted, topical, valid);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.blocked ? 1231 : 1237);
        result = 31 * result + (this.substituted ? 1231 : 1237);
        result = 31 * result + (this.topical ? 1231 : 1237);
        result = 31 * result + (this.valid ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        QualityInformation other = (QualityInformation)obj;
        if (this.blocked != other.blocked) {
            return false;
        }
        if (this.substituted != other.substituted) {
            return false;
        }
        if (this.topical != other.topical) {
            return false;
        }
        return this.valid == other.valid;
    }
}

